/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.config;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.common.crypto.HashUtils;
import java.util.ArrayList;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DiscoveryConfigUtils {
    public static final TraceComponent tc = Tr.register(DiscoveryConfigUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    private JSONObject discoveryjson;
    private String tokenEndpointAuthMethod;
    private String scope;
    private String signatureAlgorithm;
    private String id;
    private String discoveryURL;
    private CommonConfigUtils configUtils = new CommonConfigUtils();
    private String discoveryDocumentHash;
    private long discoveryPollingRate;
    public static final String OPDISCOVERY_AUTHZ_EP_URL = "authorization_endpoint";
    public static final String OPDISCOVERY_TOKEN_EP_URL = "token_endpoint";
    public static final String OPDISCOVERY_INTROSPECTION_EP_URL = "introspection_endpoint";
    public static final String OPDISCOVERY_JWKS_EP_URL = "jwks_uri";
    public static final String OPDISCOVERY_USERINFO_EP_URL = "userinfo_endpoint";
    public static final String OPDISCOVERY_ISSUER = "issuer";
    public static final String OPDISCOVERY_TOKEN_EP_AUTH = "token_endpoint_auth_methods_supported";
    public static final String OPDISCOVERY_SCOPES = "scopes_supported";
    public static final String OPDISCOVERY_IDTOKEN_SIGN_ALG = "id_token_signing_alg_values_supported";
    public static final String CFG_KEY_SCOPE = "scope";
    public static final String CFG_KEY_TOKEN_ENDPOINT_AUTH_METHOD = "tokenEndpointAuthMethod";
    public static final String CFG_KEY_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String KEY_authorizationEndpoint = "authorizationEndpoint";
    public static final String KEY_tokenEndpoint = "tokenEndpoint";
    public static final String KEY_USERINFO_ENDPOINT = "userInfoEndpoint";
    public static final String KEY_jwksUri = "jwksUri";
    public static final String KEY_ISSUER = "issuer";
    public static final String KEY_DISCOVERY_ENDPOINT = "discoveryEndpoint";
    static final long serialVersionUID = 140011431640492629L;

    public DiscoveryConfigUtils initialConfig(String configId, String ep, long discoveryRate) {
        this.id = configId;
        this.discoveryURL = ep;
        this.discoveryPollingRate = discoveryRate;
        return this;
    }

    public DiscoveryConfigUtils discoveredConfig(String alg, String tokenepAuthMethod, String scope) {
        this.signatureAlgorithm = alg;
        this.tokenEndpointAuthMethod = tokenepAuthMethod;
        this.scope = scope;
        return this;
    }

    public DiscoveryConfigUtils discoveryDocumentHash(String discoveryHash) {
        this.discoveryDocumentHash = discoveryHash;
        return this;
    }

    public DiscoveryConfigUtils discoveryDocumentResult(JSONObject json) {
        this.discoveryjson = json;
        return this;
    }

    public String adjustTokenEndpointAuthMethod() {
        ArrayList<String> discoveryTokenepAuthMethod = this.discoverOPConfig(this.discoveryjson.get((Object)OPDISCOVERY_TOKEN_EP_AUTH));
        if (this.isSocialRPUsingDefault("authMethod") && !this.opHasSocialRPDefault("authMethod", discoveryTokenepAuthMethod)) {
            String supported;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("See if we need to adjusted the token endpoint authmethod. The original is : " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            }
            if ((supported = this.socialRPSupportsOPConfig("authMethod", discoveryTokenepAuthMethod)) != null) {
                Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_OVERRIDE_DEFAULT", (Object[])new Object[]{this.tokenEndpointAuthMethod, CFG_KEY_TOKEN_ENDPOINT_AUTH_METHOD, supported, this.getId()});
                this.tokenEndpointAuthMethod = supported;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The adjusted value is : " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
                }
            }
        }
        return this.tokenEndpointAuthMethod;
    }

    private String getId() {
        return this.id;
    }

    public String adjustScopes() {
        ArrayList<String> discoveryScopes = this.discoverOPConfig(this.discoveryjson.get((Object)OPDISCOVERY_SCOPES));
        if (this.isSocialRPUsingDefault(CFG_KEY_SCOPE) && !this.opHasSocialRPDefault(CFG_KEY_SCOPE, discoveryScopes)) {
            String supported;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("See if we need to adjusted the scopes. The original is : " + this.scope), (Object[])new Object[0]);
            }
            if ((supported = this.socialRPSupportsOPConfig(CFG_KEY_SCOPE, discoveryScopes)) != null) {
                Tr.info((TraceComponent)tc, (String)"OIDC_CLIENT_DISCOVERY_OVERRIDE_DEFAULT", (Object[])new Object[]{this.scope, CFG_KEY_SCOPE, supported, this.getId()});
                this.scope = supported;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The adjusted value is : " + this.scope), (Object[])new Object[0]);
                }
            }
        }
        return this.scope;
    }

    private boolean isSocialRPUsingDefault(String key) {
        if ("authMethod".equals(key)) {
            return this.matches("client_secret_post", this.tokenEndpointAuthMethod);
        }
        if ("alg".equals(key)) {
            return this.matches("RS256", this.signatureAlgorithm);
        }
        if (CFG_KEY_SCOPE.equals(key)) {
            return this.matchesMultipleValues("openid profile email", this.scope);
        }
        return false;
    }

    private String socialRPSupportsOPConfig(String key, ArrayList<String> values) {
        String rpSupportedSignatureAlgorithms = "RS256";
        String rpSupportedTokenEndpointAuthMethods = "client_secret_post client_secret_basic";
        String rpSupportedScopes = "openid profile email";
        if ("alg".equals(key) && values != null) {
            for (String value : values) {
                if (!rpSupportedSignatureAlgorithms.contains(value)) continue;
                return value;
            }
        }
        if ("authMethod".equals(key) && values != null) {
            for (String value : values) {
                if (!rpSupportedTokenEndpointAuthMethods.contains(value)) continue;
                return value;
            }
        }
        if (CFG_KEY_SCOPE.equals(key) && values != null) {
            String scopes = null;
            for (String value : values) {
                if (!rpSupportedScopes.contains(value)) continue;
                if (scopes == null) {
                    scopes = value;
                    continue;
                }
                scopes = scopes + " " + value;
            }
            return scopes;
        }
        return null;
    }

    private String matchingRPValue(String value) {
        if ("client_secret_post".equals(value)) {
            return "post";
        }
        if ("client_secret_basic".equals(value)) {
            return "basic";
        }
        return value;
    }

    private ArrayList<String> discoverOPConfig(Object obj) {
        return this.jsonValue(obj);
    }

    private ArrayList<String> jsonValue(Object obj) {
        ArrayList<String> str = new ArrayList<String>();
        int index = 0;
        if (obj != null) {
            if (obj instanceof String) {
                str.add(index, (String)obj);
                return str;
            }
            if (obj instanceof JSONArray) {
                return this.parseJsonArray((JSONArray)obj);
            }
        }
        return null;
    }

    private ArrayList<String> parseJsonArray(JSONArray jsonArrayOfStrings) {
        ArrayList<String> jsonString = new ArrayList<String>();
        int index = 0;
        if (jsonArrayOfStrings != null) {
            for (Object strObj : jsonArrayOfStrings) {
                if (!(strObj instanceof String)) continue;
                jsonString.add(index, (String)strObj);
                ++index;
            }
        }
        return jsonString;
    }

    private boolean opHasRPDefault(String key, ArrayList<String> opconfig) {
        if ("authMethod".equals(key)) {
            return this.matches("client_secret_post", opconfig);
        }
        if ("alg".equals(key)) {
            return this.matches("HS256", opconfig);
        }
        if (CFG_KEY_SCOPE.equals(key)) {
            return this.matches("openid", opconfig) && this.matches("profile", opconfig);
        }
        return false;
    }

    private boolean opHasSocialRPDefault(String key, ArrayList<String> opconfig) {
        if ("authMethod".equals(key)) {
            return this.matches("client_secret_post", opconfig);
        }
        if ("alg".equals(key)) {
            return this.matches("RS256", opconfig);
        }
        if (CFG_KEY_SCOPE.equals(key)) {
            return this.matches("openid", opconfig) && this.matches("profile", opconfig) && this.matches("email", opconfig);
        }
        return false;
    }

    private boolean matches(String rpdefault, ArrayList<String> opconfig) {
        for (String str : opconfig) {
            if (!rpdefault.equals(str)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String rpdefault, String rpconfig) {
        return rpconfig.equals(rpdefault);
    }

    private boolean matchesMultipleValues(String rpdefault, String rpconfig) {
        String[] configuredScope = rpconfig.split(" ");
        if (configuredScope.length != 3) {
            return false;
        }
        for (String scope : configuredScope) {
            if (rpdefault.contains(scope)) continue;
            return false;
        }
        return true;
    }

    private boolean isRPUsingDefault(String key) {
        if ("authMethod".equals(key)) {
            return this.matches("post", this.tokenEndpointAuthMethod);
        }
        if ("alg".equals(key)) {
            return this.matches("HS256", this.signatureAlgorithm);
        }
        if (CFG_KEY_SCOPE.equals(key)) {
            return this.matches("openid profile", this.scope);
        }
        return false;
    }

    public String discoverOPConfigSingleValue(Object object) {
        String str = null;
        if (object != null) {
            return this.jsonValue(object).get(0);
        }
        return str;
    }

    public void logDiscoveryWarning(Map<String, Object> props) {
        String endpoints = "";
        String ep = null;
        ep = CommonConfigUtils.trim((String)props.get(KEY_authorizationEndpoint));
        if (ep != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, KEY_authorizationEndpoint);
        }
        if ((ep = CommonConfigUtils.trim((String)props.get(KEY_tokenEndpoint))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, KEY_tokenEndpoint);
        }
        if ((ep = CommonConfigUtils.trim((String)props.get(KEY_USERINFO_ENDPOINT))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, KEY_USERINFO_ENDPOINT);
        }
        if ((ep = CommonConfigUtils.trim((String)props.get(KEY_jwksUri))) != null) {
            endpoints = this.buildDiscoveryWarning(endpoints, KEY_jwksUri);
        }
        if (!endpoints.isEmpty()) {
            this.logWarning("OIDC_CLIENT_DISCOVERY_OVERRIDE_EP", endpoints);
        }
        if ((ep = CommonConfigUtils.trim((String)props.get("issuer"))) != null) {
            this.logWarning("OIDC_CLIENT_DISCOVERY_OVERRIDE_ISSUER", "issuer");
        }
    }

    private void logWarning(String key, String endpoints) {
        Tr.warning((TraceComponent)tc, (String)key, (Object[])new Object[]{this.discoveryURL, endpoints, this.getId()});
    }

    private String buildDiscoveryWarning(String endpoints, String ep) {
        return endpoints.concat(ep).concat(", ");
    }

    public void logDiscoveryMessage(String key, String nlsMessage, String defaultMessage) {
        if (nlsMessage != null) {
            Tr.info((TraceComponent)tc, (String)nlsMessage, (Object[])new Object[0]);
        } else {
            Tr.info((TraceComponent)tc, (String)this.getNlsMessage(key, defaultMessage), (Object[])new Object[0]);
        }
    }

    private String getNlsMessage(String key, String defaultMessage) {
        String message = defaultMessage;
        String bundleName = "com.ibm.ws.security.common.internal.resources.SSOCommonMessages";
        message = TraceNLS.getFormattedMessage(this.getClass(), (String)bundleName, (String)key, (Object[])new Object[]{this.getId(), this.discoveryURL}, (String)defaultMessage);
        return message;
    }

    public boolean calculateDiscoveryDocumentHash(JSONObject json) {
        String latestDiscoveryHash = HashUtils.digest(json.toString());
        String OIDC_CLIENT_DISCOVERY_UPDATED_CONFIG = "CWWKS6111I: The client [{" + this.getId() + "}] configuration has been updated with the new information received from the discovery endpoint URL [{" + this.discoveryURL + "}].";
        boolean updated = false;
        if (this.discoveryDocumentHash == null || !this.discoveryDocumentHash.equals(latestDiscoveryHash)) {
            if (this.discoveryDocumentHash != null) {
                this.logDiscoveryMessage("OIDC_CLIENT_DISCOVERY_UPDATED_CONFIG", null, OIDC_CLIENT_DISCOVERY_UPDATED_CONFIG);
            }
            updated = true;
            this.discoveryDocumentHash = latestDiscoveryHash;
        } else if (this.discoveryDocumentHash != null && this.discoveryDocumentHash.equals(latestDiscoveryHash)) {
            String OIDC_CLIENT_DISCOVERY_NOT_UPDATED_CONFIG = "CWWKS6112I: The client [{" + this.getId() + "}] configuration is consistent with the information from the discovery endpoint URL [{" + this.discoveryURL + "}], so no configuration updates are needed.";
            this.logDiscoveryMessage("OIDC_CLIENT_DISCOVERY_NOT_UPDATED_CONFIG", null, OIDC_CLIENT_DISCOVERY_NOT_UPDATED_CONFIG);
        }
        return updated;
    }

    public String getDiscoveryDocumentHash() {
        return this.discoveryDocumentHash;
    }
}

