/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.Configuration;
import com.ibm.ws.container.Container;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.util.EmptyIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractContainer
implements Container {
    protected String name = null;
    private boolean isAlive = false;
    protected Map subElements = null;
    protected Map attributes = null;
    protected Configuration config = null;
    static final long serialVersionUID = -8271459000149267764L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void start() {
        this.isAlive = true;
    }

    @Override
    public synchronized void stop() {
        this.isAlive = false;
    }

    @Override
    public synchronized void destroy() {
        if (!this.isAlive()) {
            return;
        }
        Iterator iter = this.subContainers();
        while (iter.hasNext()) {
            Container cont = (Container)iter.next();
            cont.destroy();
            this.removeSubContainer(cont.getName());
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container removeSubContainer(String name) {
        if (this.subElements != null) {
            AbstractContainer abstractContainer = this;
            synchronized (abstractContainer) {
                return (Container)this.subElements.remove(name);
            }
        }
        return null;
    }

    @Override
    public Container getSubContainer(String name) {
        Iterator i = this.subContainers();
        Container container = null;
        while (i.hasNext()) {
            Container c = (Container)i.next();
            if (!c.getName().equals(name)) continue;
            container = c;
        }
        return container;
    }

    @Override
    public Iterator subContainers() {
        if (this.subElements != null) {
            Map clonedElements = (Map)((HashMap)this.subElements).clone();
            return clonedElements.values().iterator();
        }
        return EmptyIterator.getInstance();
    }

    @Override
    public void initialize(Configuration config) {
        this.config = config;
        this.name = config.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubContainer(Container con) {
        if (con == null || con.getName() == null) {
            throw new RuntimeException("Container Name is null");
        }
        if (this.subElements == null) {
            this.subElements = new HashMap();
        }
        AbstractContainer abstractContainer = this;
        synchronized (abstractContainer) {
            this.subElements.put(con.getName(), con);
        }
    }

    protected Configuration getConfig() {
        return this.config;
    }

    protected void setConfig(Configuration config) {
        this.config = config;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AbstractContainer.class, null, null);
    }
}

