/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.eclipse.microprofile.context.ManagedExecutor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CompletionStageRxInvokerImpl
implements CompletionStageRxInvoker {
    private WebClient wc;
    private ExecutorService ex;
    private boolean isManagedExecutor = false;
    private boolean isExecutorNull = false;
    static final long serialVersionUID = 1612944853676004032L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    CompletionStageRxInvokerImpl(WebClient wc, ExecutorService ex) {
        this.ex = ex;
        if (this.ex instanceof ManagedExecutor) {
            this.isManagedExecutor = true;
        }
        if (this.ex == null) {
            this.isExecutorNull = true;
        }
        this.wc = wc;
    }

    public CompletionStage<Response> get() {
        return this.get(Response.class);
    }

    public <T> CompletionStage<T> get(Class<T> responseType) {
        return this.method("GET", (Class)responseType);
    }

    public <T> CompletionStage<T> get(GenericType<T> responseType) {
        return this.method("GET", (GenericType)responseType);
    }

    public CompletionStage<Response> put(Entity<?> entity) {
        return this.put((Entity)entity, Response.class);
    }

    public <T> CompletionStage<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", (Entity)entity, (Class)responseType);
    }

    public <T> CompletionStage<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", (Entity)entity, (GenericType)responseType);
    }

    public CompletionStage<Response> post(Entity<?> entity) {
        return this.post((Entity)entity, Response.class);
    }

    public <T> CompletionStage<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", (Entity)entity, (Class)responseType);
    }

    public <T> CompletionStage<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", (Entity)entity, (GenericType)responseType);
    }

    public CompletionStage<Response> delete() {
        return this.delete(Response.class);
    }

    public <T> CompletionStage<T> delete(Class<T> responseType) {
        return this.method("DELETE", (Class)responseType);
    }

    public <T> CompletionStage<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", (GenericType)responseType);
    }

    public CompletionStage<Response> head() {
        return this.method("HEAD");
    }

    public CompletionStage<Response> options() {
        return this.options(Response.class);
    }

    public <T> CompletionStage<T> options(Class<T> responseType) {
        return this.method("OPTIONS", (Class)responseType);
    }

    public <T> CompletionStage<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", (GenericType)responseType);
    }

    public CompletionStage<Response> trace() {
        return this.trace(Response.class);
    }

    public <T> CompletionStage<T> trace(Class<T> responseType) {
        return this.method("TRACE", (Class)responseType);
    }

    public <T> CompletionStage<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", (GenericType)responseType);
    }

    public CompletionStage<Response> method(String name) {
        return this.method(name, Response.class);
    }

    public CompletionStage<Response> method(String name, Entity<?> entity) {
        return this.method(name, (Entity)entity, Response.class);
    }

    public <T> CompletionStage<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.supplyAsync(() -> this.wc.sync().method(name, entity, responseType));
    }

    public <T> CompletionStage<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.supplyAsync(() -> this.wc.sync().method(name, entity, responseType));
    }

    public <T> CompletionStage<T> method(String name, Class<T> responseType) {
        return this.supplyAsync(() -> this.wc.sync().method(name, responseType));
    }

    public <T> CompletionStage<T> method(String name, GenericType<T> responseType) {
        return this.supplyAsync(() -> this.wc.sync().method(name, responseType));
    }

    private <T> CompletionStage<T> supplyAsync(Supplier<T> supplier) {
        if (this.isExecutorNull) {
            return CompletableFuture.supplyAsync(supplier);
        }
        if (this.isManagedExecutor) {
            return ((ManagedExecutor)this.ex).supplyAsync(supplier);
        }
        return CompletableFuture.supplyAsync(supplier, this.ex);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CompletionStageRxInvokerImpl.class, null, null);
    }
}

