/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.yoko.orb.OB.CorbalocProtocol;
import org.apache.yoko.orb.OB.CorbalocURLScheme;
import org.apache.yoko.orb.OB.CorbalocURLSchemePackage.ProtocolAlreadyExists;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectFactory;
import org.apache.yoko.orb.OB.URLUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedProfile;

public class CorbalocURLScheme_impl
extends LocalObject
implements CorbalocURLScheme {
    private ORBInstance orbInstance_;
    private Hashtable protocols_ = new Hashtable();

    private static byte[] stringToKey(String keyStr) {
        byte[] result = new byte[keyStr.length()];
        for (int i = 0; i < result.length; ++i) {
            char ch = keyStr.charAt(i);
            if (ch > '\u00ff') {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": invalid character in key, char value = 0x" + Integer.toHexString(ch), 1330446345, CompletionStatus.COMPLETED_NO);
            }
            result[i] = (byte)ch;
        }
        return result;
    }

    private Object parse_addresses(String str, int startIdx, int endIdx, String keyStr) {
        if (str.substring(startIdx, startIdx + 4).equals("rir:")) {
            int comma = str.indexOf(44, startIdx);
            if (comma != -1 && comma <= endIdx) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": rir cannot be used with other protocols", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            if (startIdx + 3 != endIdx) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": rir does not allow an address", 1330446344, CompletionStatus.COMPLETED_NO);
            }
            try {
                InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
                return initialServiceManager.resolveInitialReferences(keyStr);
            }
            catch (InvalidName ex) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": invalid initial reference token \"" + keyStr + "\"", 1330446345, CompletionStatus.COMPLETED_NO);
            }
        }
        byte[] key = CorbalocURLScheme_impl.stringToKey(URLUtil.unescapeURL(keyStr));
        Vector<TaggedProfile> profiles = new Vector<TaggedProfile>();
        int pos = startIdx;
        while (pos <= endIdx) {
            CorbalocProtocol p;
            String addr;
            int colon = str.indexOf(58, pos);
            if (colon == -1) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": no protocol", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            if (colon > endIdx) break;
            String protocol = colon == pos ? "iiop" : str.substring(pos, colon).toLowerCase();
            pos = colon;
            if (protocol.equals("rir")) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": rir cannot be used with other protocols", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            if (pos == endIdx) {
                addr = "";
                ++pos;
            } else {
                int addrEnd;
                int addrStart = pos + 1;
                int comma = str.indexOf(44, addrStart);
                if (comma == -1 || comma > endIdx) {
                    addrEnd = endIdx;
                    pos = endIdx + 1;
                } else {
                    addrEnd = comma - 1;
                    pos = comma + 1;
                }
                addr = str.substring(addrStart, addrEnd + 1);
            }
            if ((p = this.find_protocol(protocol)) == null) continue;
            TaggedProfile profile = p.parse_address(addr, key);
            profiles.addElement(profile);
        }
        if (profiles.size() == 0) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": no valid protocol addresses", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        IOR ior = new IOR();
        ior.type_id = "";
        ior.profiles = new TaggedProfile[profiles.size()];
        profiles.copyInto(ior.profiles);
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        return objectFactory.createObject(ior);
    }

    public CorbalocURLScheme_impl(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
    }

    @Override
    public String name() {
        return "corbaloc";
    }

    @Override
    public Object parse_url(String url) {
        int slash = url.indexOf(47);
        if (slash == -1) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": no key specified", 1330446346, CompletionStatus.COMPLETED_NO);
        }
        int addrStart = 9;
        int addrEnd = slash - 1;
        if (addrStart == slash) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": no protocol address", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        String key = url.substring(slash + 1);
        return this.parse_addresses(url, addrStart, addrEnd, key);
    }

    @Override
    public void destroy() {
        Enumeration e = this.protocols_.elements();
        while (e.hasMoreElements()) {
            CorbalocProtocol protocol = (CorbalocProtocol)e.nextElement();
            protocol.destroy();
        }
        this.protocols_.clear();
        this.orbInstance_ = null;
    }

    @Override
    public void add_protocol(CorbalocProtocol protocol) throws ProtocolAlreadyExists {
        String name = protocol.name();
        if (this.protocols_.containsKey(name)) {
            throw new ProtocolAlreadyExists();
        }
        this.protocols_.put(name, protocol);
    }

    @Override
    public CorbalocProtocol find_protocol(String name) {
        return (CorbalocProtocol)this.protocols_.get(name);
    }
}

