/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.ObjectKeyData;
import org.apache.yoko.orb.OBPortableServer.POANameHasher;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;

final class POALocator {
    static final Logger logger = Logger.getLogger(POALocator.class.getName());
    Hashtable poas_ = new Hashtable(63);

    POALocator() {
    }

    synchronized POA locate(ObjectKeyData data) throws LocationForward {
        logger.fine("Searching for POA " + data);
        if (data.poaId.length == 0) {
            return null;
        }
        POA poa = (POA)this.poas_.get(new POANameHasher(data.poaId));
        if (poa == null) {
            Object key;
            logger.fine("POA not found by direct lookup, searching the hierarchy");
            String[] poaId = new String[data.poaId.length];
            System.arraycopy(data.poaId, 0, poaId, 0, data.poaId.length);
            Vector<String> remaining = new Vector<String>();
            do {
                remaining.addElement(poaId[poaId.length - 1]);
                String[] newID = new String[poaId.length - 1];
                System.arraycopy(poaId, 0, newID, 0, poaId.length - 1);
                poaId = newID;
                key = new POANameHasher(poaId);
                logger.fine("Searching POA hierarchy for " + key);
                poa = (POA)this.poas_.get(key);
                if (poa == null) continue;
                logger.fine("Located POA using " + key);
                break;
            } while (poaId.length > 0);
            for (int i = remaining.size(); i > 0 && poa != null; --i) {
                key = (String)remaining.elementAt(i - 1);
                try {
                    logger.fine("Searching up hierarchy using key " + (String)key);
                    poa = poa.find_POA((String)key, true);
                    continue;
                }
                catch (AdapterNonExistent ex) {
                    logger.fine("Failure locating POA using key " + (String)key);
                    poa = null;
                }
            }
        }
        return poa;
    }

    synchronized void add(POA poa, String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        logger.fine("Adding POA to locater using key " + idkey);
        Assert._OB_assert(!this.poas_.containsKey(idkey));
        this.poas_.put(idkey, poa);
    }

    synchronized void remove(String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        logger.fine("Removing POA from locater using key " + idkey);
        Assert._OB_assert(this.poas_.containsKey(idkey));
        this.poas_.remove(idkey);
    }
}

