/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OBPortableServer.POAPolicies;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.AcceptorInfo;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.IIOP.AcceptorInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.Transport_impl;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoSeqHolder;
import org.apache.yoko.orb.OCI.Transport;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHolder;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;

final class Acceptor_impl
extends LocalObject
implements Acceptor {
    static final Logger logger = Logger.getLogger(Acceptor.class.getName());
    public String[] hosts_;
    public ServerSocket socket_;
    private boolean multiProfile_;
    private int port_;
    private boolean keepAlive_;
    private InetAddress localAddress_;
    private final AcceptorInfo_impl info_;
    private ListenerMap listenMap_;
    private final ConnectionHelper connectionHelper_;
    private final ExtendedConnectionHelper extendedConnectionHelper_;
    private final Codec codec_;

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public int handle() {
        throw new NO_IMPLEMENT();
    }

    @Override
    public void close() {
        logger.log(Level.FINE, "Closing server socket with host=" + this.localAddress_ + ", port=" + this.port_, new Exception("Stack trace"));
        this.info_._OB_destroy();
        try {
            this.socket_.close();
            this.socket_ = null;
            logger.log(Level.FINE, "Closed server socket with host=" + this.localAddress_ + ", port=" + this.port_);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Exception closing server socket with host=" + this.localAddress_ + ", port=" + this.port_, ex);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void listen() {
    }

    @Override
    public Transport accept(boolean block) {
        Socket socket;
        try {
            if (!block) {
                this.socket_.setSoTimeout(1);
            } else {
                this.socket_.setSoTimeout(0);
            }
            logger.fine("Accepting connection for host=" + this.localAddress_ + ", port=" + this.port_);
            socket = this.socket_.accept();
            logger.fine("Received inbound connection on socket " + socket);
        }
        catch (InterruptedIOException ex) {
            if (!block) {
                return null;
            }
            logger.log(Level.FINE, "Failure accepting connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974923);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failure accepting connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974923);
        }
        try {
            socket.setTcpNoDelay(true);
            if (this.keepAlive_) {
                socket.setKeepAlive(true);
            }
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Failure configuring server connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974918);
        }
        Transport_impl tr = null;
        try {
            tr = new Transport_impl(this, socket, this.listenMap_);
            logger.fine("Inbound connection received from " + socket.getInetAddress());
        }
        catch (SystemException ex) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.log(Level.FINE, "error creating inbound connection", ex);
            throw ex;
        }
        return tr;
    }

    @Override
    public Transport connect_self() {
        Socket socket = null;
        try {
            socket = this.connectionHelper_ != null ? this.connectionHelper_.createSelfConnection(this.localAddress_, this.port_) : this.extendedConnectionHelper_.createSelfConnection(this.localAddress_, this.port_);
        }
        catch (ConnectException ex) {
            logger.log(Level.FINE, "Failure making self connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asTransient(ex, 1095974913);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failure making self connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            throw Exceptions.asCommFailure(ex, 1095974917);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            logger.log(Level.FINE, "Failure configuring self connection for host=" + this.localAddress_ + ", port=" + this.port_, ex);
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw Exceptions.asCommFailure(ex);
        }
        try {
            return new Transport_impl(this, socket, this.listenMap_);
        }
        catch (SystemException ex) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }

    @Override
    public void add_profiles(ProfileInfo profileInfo, POAPolicies policies, IORHolder ior) {
        int i;
        if (this.port_ == 0) {
            throw new RuntimeException();
        }
        Vector<TaggedComponent> components = new Vector<TaggedComponent>();
        if (profileInfo.major != 1 || profileInfo.minor != 0) {
            for (i = 0; i < profileInfo.components.length; ++i) {
                components.addElement(profileInfo.components[i]);
            }
        }
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            for (i = 0; i < this.hosts_.length; ++i) {
                ProfileBody_1_0 body = new ProfileBody_1_0();
                body.iiop_version = new Version(profileInfo.major, profileInfo.minor);
                body.host = this.hosts_[i];
                body.port = policies.zeroPortPolicy() ? (short)0 : (this.port_ >= 32768 ? (short)(this.port_ - 65535 - 1) : (short)this.port_);
                body.object_key = profileInfo.key;
                int len = ior.value.profiles.length + 1;
                TaggedProfile[] profiles = new TaggedProfile[len];
                System.arraycopy(ior.value.profiles, 0, profiles, 0, ior.value.profiles.length);
                ior.value.profiles = profiles;
                ior.value.profiles[len - 1] = new TaggedProfile();
                ior.value.profiles[len - 1].tag = 0;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                ProfileBody_1_0Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_0)body);
                ior.value.profiles[len - 1].profile_data = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, ior.value.profiles[len - 1].profile_data, 0, buf.length());
            }
        } else if (this.multiProfile_) {
            for (i = 0; i < this.hosts_.length; ++i) {
                ProfileBody_1_1 body = new ProfileBody_1_1();
                body.iiop_version = new Version(profileInfo.major, profileInfo.minor);
                body.host = this.hosts_[i];
                body.port = policies.zeroPortPolicy() ? (short)0 : (this.port_ >= 32768 ? (short)(this.port_ - 65535 - 1) : (short)this.port_);
                body.object_key = profileInfo.key;
                body.components = new TaggedComponent[components.size()];
                components.copyInto(body.components);
                int len = ior.value.profiles.length + 1;
                TaggedProfile[] profiles = new TaggedProfile[len];
                System.arraycopy(ior.value.profiles, 0, profiles, 0, ior.value.profiles.length);
                ior.value.profiles = profiles;
                ior.value.profiles[len - 1] = new TaggedProfile();
                ior.value.profiles[len - 1].tag = 0;
                Buffer buf = new Buffer();
                OutputStream out = new OutputStream(buf);
                out._OB_writeEndian();
                ProfileBody_1_1Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_1)body);
                ior.value.profiles[len - 1].profile_data = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, ior.value.profiles[len - 1].profile_data, 0, buf.length());
            }
        } else {
            OutputStream out;
            Buffer buf;
            ProfileBody_1_1 body = new ProfileBody_1_1();
            body.iiop_version = new Version(profileInfo.major, profileInfo.minor);
            body.host = this.hosts_[0];
            body.port = policies.zeroPortPolicy() ? (short)0 : (this.port_ >= 32768 ? (short)(this.port_ - 65535 - 1) : (short)this.port_);
            body.object_key = profileInfo.key;
            for (int i2 = 1; i2 < this.hosts_.length; ++i2) {
                TaggedComponent c = new TaggedComponent();
                c.tag = 3;
                buf = new Buffer();
                out = new OutputStream(buf);
                out._OB_writeEndian();
                out.write_string(this.hosts_[i2]);
                out.write_ushort(body.port);
                c.component_data = new byte[buf.length()];
                System.arraycopy(buf.data(), 0, c.component_data, 0, buf.length());
                components.addElement(c);
            }
            body.components = new TaggedComponent[components.size()];
            components.copyInto(body.components);
            int len = ior.value.profiles.length + 1;
            TaggedProfile[] profiles = new TaggedProfile[len];
            System.arraycopy(ior.value.profiles, 0, profiles, 0, ior.value.profiles.length);
            ior.value.profiles = profiles;
            ior.value.profiles[len - 1] = new TaggedProfile();
            ior.value.profiles[len - 1].tag = 0;
            buf = new Buffer();
            out = new OutputStream(buf);
            out._OB_writeEndian();
            ProfileBody_1_1Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_1)body);
            ior.value.profiles[len - 1].profile_data = new byte[buf.length()];
            System.arraycopy(buf.data(), 0, ior.value.profiles[len - 1].profile_data, 0, buf.length());
        }
    }

    @Override
    public ProfileInfo[] get_local_profiles(IOR ior) {
        ProfileInfoSeqHolder profileInfoSeq = new ProfileInfoSeqHolder();
        profileInfoSeq.value = new ProfileInfo[0];
        for (int i = 0; i < this.hosts_.length; ++i) {
            Util.extractAllProfileInfos(ior, profileInfoSeq, true, this.hosts_[i], this.port_, true, this.codec_);
        }
        return profileInfoSeq.value;
    }

    @Override
    public AcceptorInfo get_info() {
        return this.info_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Acceptor_impl(String address, String[] hosts, boolean multiProfile, int port, int backlog, boolean keepAlive, ConnectionHelper helper, ExtendedConnectionHelper extendedConnectionHelper, ListenerMap lm, String[] params, Codec codec) {
        Assert._OB_assert(helper == null ^ extendedConnectionHelper == null);
        this.hosts_ = hosts;
        this.multiProfile_ = multiProfile;
        this.keepAlive_ = keepAlive;
        this.connectionHelper_ = helper;
        this.extendedConnectionHelper_ = extendedConnectionHelper;
        this.codec_ = codec;
        this.info_ = new AcceptorInfo_impl(this);
        this.listenMap_ = lm;
        if (backlog == 0) {
            backlog = 50;
        }
        try {
            this.localAddress_ = address == null ? InetAddress.getLocalHost() : Util.getInetAddress(address);
        }
        catch (UnknownHostException ex) {
            logger.log(Level.FINE, "Host resolution failure", ex);
            throw Exceptions.asCommFailure(ex);
        }
        try {
            this.socket_ = address == null ? (this.connectionHelper_ != null ? this.connectionHelper_.createServerSocket(port, backlog) : this.extendedConnectionHelper_.createServerSocket(port, backlog, params)) : (this.connectionHelper_ != null ? this.connectionHelper_.createServerSocket(port, backlog, this.localAddress_) : this.extendedConnectionHelper_.createServerSocket(port, backlog, this.localAddress_, params));
            this.port_ = this.socket_.getLocalPort();
            logger.fine("Acceptor created using socket " + this.socket_);
        }
        catch (BindException ex) {
            logger.log(Level.FINE, "Failure creating server socket for host=" + this.localAddress_ + ", port=" + port, ex);
            throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974920) + ": " + ex.getMessage(), 1095974920, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failure creating server socket for host=" + this.localAddress_ + ", port=" + port, ex);
            throw Exceptions.asCommFailure(ex, 1095974917);
        }
        ListenerMap listenerMap = this.listenMap_;
        synchronized (listenerMap) {
            for (int i = 0; i < this.hosts_.length; ++i) {
                this.listenMap_.add(this.hosts_[i], (short)this.port_);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        ListenerMap listenerMap = this.listenMap_;
        synchronized (listenerMap) {
            for (int i = 0; i < this.hosts_.length; ++i) {
                this.listenMap_.remove(this.hosts_[i], (short)this.port_);
            }
        }
        super.finalize();
    }

    public String toString() {
        return "Acceptor listening on " + this.socket_;
    }
}

