/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.IIOP.Exceptions;
import org.apache.yoko.orb.OCI.IIOP.InternalError;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.TransportInfo_impl;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;

public final class Transport_impl
extends LocalObject
implements Transport {
    public final Socket socket_;
    private InputStream in_;
    private OutputStream out_;
    private volatile boolean shutdown_;
    private int soTimeout_ = 0;
    private TransportInfo_impl info_;
    static final Logger logger = Logger.getLogger(Transport.class.getName());

    private void setSoTimeout(int t) {
        if (this.soTimeout_ != t) {
            this.soTimeout_ = t;
            try {
                this.socket_.setSoTimeout(this.soTimeout_);
            }
            catch (SocketException ex) {
                logger.log(Level.FINE, "Socket setup error", ex);
                throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974938) + ": socket error during setSoTimeout: " + ex.getMessage(), 1095974938, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket setup error", ex);
                throw (COMM_FAILURE)new COMM_FAILURE(MinorCodes.describeCommFailure(1095974938) + ": NullPointerException error during setSoTimeout: " + ex.getMessage(), 1095974938, CompletionStatus.COMPLETED_NO).initCause((Throwable)ex);
            }
        }
    }

    private void setBlock(boolean block) {
        if (block) {
            this.setSoTimeout(0);
        } else {
            this.setSoTimeout(1);
        }
    }

    private void shutdownSocket() {
        try {
            try {
                this.socket_.shutdownInput();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                this.socket_.shutdownOutput();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        catch (SocketException socketException) {
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket shutdown error", ex);
            throw (InternalError)new InternalError().initCause(ex);
        }
    }

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public SendReceiveMode mode() {
        return SendReceiveMode.SendReceive;
    }

    @Override
    public int handle() {
        throw new NO_IMPLEMENT();
    }

    @Override
    public void close() {
        this.shutdownSocket();
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        logger.info("shutdown: " + this);
        this.shutdown_ = true;
        this.shutdownSocket();
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void receive(Buffer buf, boolean block) {
        this.setBlock(block);
        logger.fine("receiving a buffer of " + buf.rest_length() + " from " + this.socket_ + " using transport " + this);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                logger.log(Level.FINE, "Received interrupted exception", ex);
                buf.advance(ex.bytesTransferred);
                if (!block) {
                    return;
                }
                if (!this.shutdown_) continue;
                throw Exceptions.asCommFailure(ex, 1095974913, "Interrupted I/O exception during shutdown");
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket read error", ex);
                throw Exceptions.asCommFailure(ex, 1095974913, "I/O error during read");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket read error", ex);
                throw Exceptions.asCommFailure(ex, 1095974913, "NullPointerException during read");
            }
        }
    }

    @Override
    public boolean receive_detect(Buffer buf, boolean block) {
        this.setBlock(block);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    return false;
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void receive_timeout(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            this.receive(buf, false);
            return;
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974915), 1095974915, CompletionStatus.COMPLETED_NO);
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return;
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket read error", ex);
                throw Exceptions.asCommFailure(ex, 1095974913, "I/O error during read");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket read error", ex);
                throw Exceptions.asCommFailure(ex, 1095974913, "NullPointerException during read");
            }
        }
    }

    @Override
    public boolean receive_timeout_detect(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            return this.receive_detect(buf, false);
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    return false;
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void send(Buffer buf, boolean block) {
        this.setBlock(block);
        logger.fine("Sending buffer of size " + buf.rest_length() + " to " + this.socket_);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return;
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "I/O error during write");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "NullPointerException during write");
            }
        }
    }

    @Override
    public boolean send_detect(Buffer buf, boolean block) {
        this.setBlock(block);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void send_timeout(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            this.send(buf, false);
            return;
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return;
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "I/O error during write");
            }
            catch (NullPointerException ex) {
                logger.log(Level.FINE, "Socket write error", ex);
                throw Exceptions.asCommFailure(ex, 1095974914, "NullPointerException during write");
            }
        }
    }

    @Override
    public boolean send_timeout_detect(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            return this.send_detect(buf, false);
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public TransportInfo get_info() {
        return this.info_;
    }

    public Transport_impl(Socket socket, ListenerMap lm) {
        this.socket_ = socket;
        this.shutdown_ = false;
        try {
            this.in_ = this.socket_.getInputStream();
            this.out_ = this.socket_.getOutputStream();
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            throw Exceptions.asCommFailure(ex, 1095974917, "unable to obtain socket InputStream");
        }
        this.info_ = new TransportInfo_impl(this, lm);
    }

    public Transport_impl(Acceptor acceptor, Socket socket, ListenerMap lm) {
        this.socket_ = socket;
        this.shutdown_ = false;
        logger.fine("Creating new transport for socket " + socket);
        try {
            this.in_ = this.socket_.getInputStream();
            this.out_ = this.socket_.getOutputStream();
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Socket setup error", ex);
            throw Exceptions.asCommFailure(ex, 1095974917, "unable to obtain socket InputStream");
        }
        this.info_ = new TransportInfo_impl(this, acceptor, lm);
    }

    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        super.finalize();
    }

    public String toString() {
        return "iiop transport using socket " + this.socket_;
    }
}

