/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.impl.NumericMatcher;
import com.ibm.ws.sib.matchspace.impl.SetValEvaluationContext;
import com.ibm.ws.sib.matchspace.impl.WrappedNodeResults;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceComponent;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.ArrayList;
import java.util.Iterator;

public class SetValNumericMatcher
extends NumericMatcher {
    private static final Class cclass = SetValNumericMatcher.class;
    private static Trace tc = TraceUtils.getTrace(SetValNumericMatcher.class, (String)"SIBMatchSpace");

    SetValNumericMatcher(Identifier id) {
        super(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "SetValNumericMatcher", (Object)("identifier: " + id));
            tc.exit(cclass, "SetValNumericMatcher", (Object)this);
        }
    }

    @Override
    void handleGet(Object value, MatchSpaceKey msg, EvalCache cache, Object contextValue, SearchResults result) throws MatchingException, BadMessageFormatMatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry((Object)this, cclass, "handleGet", new Object[]{value, msg, cache, contextValue, result});
        }
        if (value != null && value instanceof SetValEvaluationContext) {
            ArrayList nodeList = ((SetValEvaluationContext)value).getWrappedNodeList();
            for (WrappedNodeResults wrappedNode : nodeList) {
                ArrayList numberList;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug((Object)this, cclass, "handleGet", (Object)("Processing node: " + wrappedNode));
                }
                if ((numberList = wrappedNode.getNumberList(this.id.getName())) == null) continue;
                for (Number num : numberList) {
                    SetValEvaluationContext xpEval = new SetValEvaluationContext(wrappedNode);
                    super.handleGet(num, msg, cache, xpEval, result);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "handleGet");
        }
    }

    @Override
    Object getValue(MatchSpaceKey msg, Object contextValue) throws MatchingException, BadMessageFormatMatchingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "getValue", (Object)("msg: " + msg + "contextValue: " + contextValue));
        }
        SetValEvaluationContext xpEval = null;
        if (contextValue != null && contextValue instanceof SetValEvaluationContext) {
            SetValEvaluationContext evalContext = (SetValEvaluationContext)contextValue;
            ArrayList wrappedParentList = evalContext.getWrappedNodeList();
            if (wrappedParentList.isEmpty()) {
                Object docRoot = Matching.getEvaluator().getDocumentRoot(msg);
                WrappedNodeResults wrapper = new WrappedNodeResults(docRoot);
                evalContext.addNode(wrapper);
            }
            for (WrappedNodeResults nextWrappedParentNode : wrappedParentList) {
                ArrayList numberList;
                Object nextParentNode = nextWrappedParentNode.getNode();
                String debugString = "";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug((Object)this, cclass, "getValue", (Object)("Evaluation context node: " + nextWrappedParentNode));
                }
                if ((numberList = nextWrappedParentNode.getEvalNumberResult(this.id.getName())) == null) {
                    ArrayList childNodeList = (ArrayList)msg.getIdentifierValue(this.id, false, nextParentNode, true);
                    numberList = Matching.getEvaluator().castToNumberList(childNodeList);
                    nextWrappedParentNode.addEvalNumberResult(this.id.getName(), numberList);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        debugString = "Result from MFP ";
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    debugString = "Result from Cache ";
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    String asString = ", type: Numeric - <";
                    if (numberList == null) {
                        asString = asString + "null";
                    } else {
                        Iterator iterDebug = numberList.iterator();
                        boolean first = true;
                        while (iterDebug.hasNext()) {
                            Number num = (Number)iterDebug.next();
                            if (!first) {
                                asString = asString + "," + num;
                                continue;
                            }
                            asString = asString + num;
                            first = false;
                        }
                    }
                    asString = asString + ">";
                    tc.debug((Object)this, cclass, "getValue", (Object)(debugString + "for identifier " + this.id.getName() + asString));
                }
                if (xpEval == null) {
                    xpEval = new SetValEvaluationContext();
                }
                xpEval.addNode(nextWrappedParentNode);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "getValue", xpEval);
        }
        return xpEval;
    }
}

