/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd.statestream;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.gd.statestream.LinkedRangeList;
import com.ibm.ws.sib.processor.gd.statestream.TickData;
import com.ibm.ws.sib.processor.gd.statestream.TickRange;
import com.ibm.ws.sib.processor.gd.statestream.TickRangeType;
import com.ibm.ws.sib.utils.ras.SibTr;

public class StateStream
extends LinkedRangeList {
    private static final TraceComponent tc = SibTr.register(StateStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public boolean writeValueRange(long tick, TickData data) {
        return this.writeRange(TickRangeType.VALUE, tick, tick, data, true);
    }

    public boolean writeRange(TickRangeType type, long start, long end, TickData data, boolean errorCheck) {
        TickRange tr = this.getNewTickRange(type, start, end, data);
        return this.setRange(tr, errorCheck);
    }

    public boolean containsState(TickRangeType state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsState", (Object)new Object[]{state});
        }
        boolean containsState = this.containsState(state, 0L, Long.MAX_VALUE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsState", (Object)new Boolean(containsState));
        }
        return containsState;
    }

    public TickRangeType getState(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState", (Object)new Long(tick));
        }
        TickRange curr = this.findRange(tick);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)curr.type);
        }
        return curr.type;
    }

    public long discoverPrevCompleted(long stamp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Object[]{new Long(stamp)});
        }
        long prevCompleted = stamp;
        TickRange tr = this.findRange(stamp);
        if (tr.type == TickRangeType.COMPLETED) {
            prevCompleted = tr.start;
        }
        for (TickRange prev = (TickRange)tr.getPrevious(); prev != null && prev.type == TickRangeType.COMPLETED; prev = (TickRange)prev.getPrevious()) {
            prevCompleted = prev.start;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"discoverPrevCompleted", (Object)new Long(prevCompleted));
        }
        return prevCompleted;
    }

    public TickRange getCurrent() {
        return this.getCursor();
    }

    public TickRange getRange(long tick) {
        TickRange range = null;
        range = tick == 0L ? this.moveCursorToStart() : (tick == Long.MAX_VALUE ? this.moveCursorToEnd() : this.findRange(tick));
        return range;
    }

    public TickRange getNext() {
        TickRange next = this.next();
        return next;
    }

    public TickRange getPrev() {
        TickRange prev = this.previous();
        return prev;
    }

    @Override
    public long getCompletedPrefix() {
        return 0L;
    }

    public boolean setCompletedPrefix(long newprefix) {
        if (newprefix > this.getCompletedPrefix()) {
            return this.writeRange(TickRangeType.COMPLETED, 0L, newprefix, null, true);
        }
        return false;
    }

    public String stateString(String str) {
        String ret = "Elements in stream " + str + ": Completedpre=" + this.getCompletedPrefix() + ":\n";
        TickRange ro = this.getRange(0L);
        while (ro != null) {
            ret = ret + ro.toString() + "\n";
            ro = this.getNext();
        }
        return ret;
    }
}

