/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionListener;
import com.ibm.ws.sib.comms.ProtocolVersion;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.io.MECommsTrc;
import com.ibm.ws.sib.processor.io.MPConnection;
import com.ibm.ws.sib.processor.io.RemoteMessageReceiver;
import com.ibm.ws.sib.processor.utils.Enumarray;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.trm.contact.CommsErrorListener;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.LinkCellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.trm.topology.RoutingManager;
import com.ibm.ws.sib.trm.topology.TopologyListener;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class MPIO
implements TopologyListener,
MEConnectionListener {
    private static final TraceComponent tc = SibTr.register(MPIO.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private CommsErrorListener _commsErrorListener;
    private RoutingManager _routingManager;
    private RemoteMessageReceiver _remoteMessageReciever;
    private HashMap<MEConnection, MPConnection> _mpConnectionsByMEConnection = new HashMap();
    private HashMap<SIBUuid8, MPConnection> _mpConnectionsByMEUuid = new HashMap();
    private LockManager mpioLockManager = new LockManager();
    private boolean started;
    private MessageProcessor _messageProcessor;

    public MPIO(MessageProcessor messageProcessor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPIO", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPIO", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CommsErrorListener CEL, RoutingManager RM) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{CEL, RM});
        }
        this.mpioLockManager.lockExclusive();
        this._commsErrorListener = CEL;
        this._routingManager = RM;
        HashMap<MEConnection, MPConnection> hashMap = this._mpConnectionsByMEConnection;
        synchronized (hashMap) {
            this._mpConnectionsByMEUuid.clear();
            this._mpConnectionsByMEConnection.clear();
        }
        if (this._remoteMessageReciever == null) {
            this._remoteMessageReciever = new RemoteMessageReceiver(this._messageProcessor, this);
        } else {
            this._remoteMessageReciever.init();
        }
        this.started = true;
        this.mpioLockManager.unlockExclusive();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.mpioLockManager.lockExclusive();
        this.started = false;
        this.mpioLockManager.unlockExclusive();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(MEConnection conn, AbstractMessage aMessage) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receiveMessage", (Object)new Object[]{conn, aMessage, "verboseMsg IN : " + aMessage.toVerboseString()});
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            MECommsTrc.traceMessage(tc, this._messageProcessor, aMessage.getGuaranteedSourceMessagingEngineUUID(), "<-RECV--", conn, aMessage);
        }
        this.mpioLockManager.lock();
        try {
            if (this.started) {
                this._remoteMessageReciever.receiveMessage(aMessage);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignoring message as in stopped state");
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.io.MPIO.receiveMessage", (String)"1:228:1.32", (Object[])new Object[]{this, aMessage, conn, this._messageProcessor.getMessagingEngineName()});
            if (e instanceof Exception) {
                SibTr.exception((TraceComponent)tc, (Exception)((Exception)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Exception occurred when processing a message " + e));
            }
            if (e instanceof ThreadDeath) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"receiveMessage", (Object)e);
                }
                throw (ThreadDeath)e;
            }
        }
        finally {
            this.mpioLockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPConnection getOrCreateNewMPConnection(SIBUuid8 remoteUuid, MEConnection conn) {
        MPConnection mpConn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOrCreateNewMPConnection", (Object)new Object[]{remoteUuid, conn});
        }
        HashMap<MEConnection, MPConnection> hashMap = this._mpConnectionsByMEConnection;
        synchronized (hashMap) {
            mpConn = this._mpConnectionsByMEConnection.get(conn);
            if (mpConn == null) {
                if (remoteUuid == null) {
                    remoteUuid = new SIBUuid8(conn.getMessagingEngine().getUuid());
                }
                mpConn = new MPConnection(this, conn, remoteUuid);
                this._mpConnectionsByMEConnection.put(conn, mpConn);
                this._mpConnectionsByMEUuid.put(remoteUuid, mpConn);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getOrCreateNewMPConnection", (Object)mpConn);
        }
        return mpConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPConnection getMPConnection(SIBUuid8 remoteUuid) {
        MPConnection mpConn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPConnection", (Object)new Object[]{remoteUuid});
        }
        HashMap<MEConnection, MPConnection> hashMap = this._mpConnectionsByMEConnection;
        synchronized (hashMap) {
            mpConn = this._mpConnectionsByMEUuid.get(remoteUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMPConnection", (Object)mpConn);
        }
        return mpConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPConnection getMPConnection(MEConnection conn) {
        MPConnection mpConn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPConnection", (Object)new Object[]{conn});
        }
        HashMap<MEConnection, MPConnection> hashMap = this._mpConnectionsByMEConnection;
        synchronized (hashMap) {
            mpConn = this._mpConnectionsByMEConnection.get(conn);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMPConnection", (Object)mpConn);
        }
        return mpConn;
    }

    public MPConnection findMPConnection(SIBUuid8 remoteUuid) {
        MEConnection[] choices;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findMPConnection", (Object)new Object[]{remoteUuid});
        }
        MPConnection mpConn = this.getMPConnection(remoteUuid);
        if (remoteUuid != null && mpConn == null && this._routingManager != null && (choices = this._routingManager.listConnections((Cellule)new MessagingEngine(remoteUuid))) != null && choices.length > 0 && choices[0] != null) {
            if (choices.length > 1) {
                SIMPErrorException e = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.io.MPIO", "1:378:1.32", this}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.io.MPIO.findMPConnection", (String)"1:385:1.32", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findMPConnection");
                }
                throw e;
            }
            mpConn = this.getOrCreateNewMPConnection(remoteUuid, choices[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findMPConnection", (Object)mpConn);
        }
        return mpConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPConnection removeConnection(MEConnection conn) {
        MPConnection mpConn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConnection", (Object)new Object[]{conn});
        }
        HashMap<MEConnection, MPConnection> hashMap = this._mpConnectionsByMEConnection;
        synchronized (hashMap) {
            mpConn = this._mpConnectionsByMEConnection.remove(conn);
            if (mpConn != null) {
                this._mpConnectionsByMEUuid.remove(mpConn.getRemoteMEUuid());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConnection", (Object)mpConn);
        }
        return mpConn;
    }

    public void error(MEConnection conn, Throwable ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"error", (Object)new Object[]{this, conn, ex});
        }
        this._commsErrorListener.error(conn, ex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"error");
        }
    }

    public void increaseInReachability(LinkCellule[] celluleList, MessagingEngine[] rmeList) {
    }

    public void decreaseInReachability(MEConnection conn, LinkCellule[] celluleList, MessagingEngine[] rmeList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decreaseInReachability", (Object)new Object[]{this, conn, new Enumarray(celluleList), new Enumarray(rmeList)});
        }
        this.removeConnection(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decreaseInReachability");
        }
    }

    public void changeConnection(MEConnection downConn, MEConnection upConn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"changeConnection", (Object)new Object[]{this, downConn, upConn});
        }
        if (downConn != null) {
            this.removeConnection(downConn);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"changeConnection");
        }
    }

    public void sendToMe(SIBUuid8 targetME, int priority, AbstractMessage aMessage) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{aMessage, priority, targetME});
        }
        MPConnection firstChoice = this.findMPConnection(targetME);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"sendToMe", (Object)firstChoice);
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            MECommsTrc.traceMessage(tc, this._messageProcessor, aMessage.getGuaranteedTargetMessagingEngineUUID(), "--SEND->", firstChoice, aMessage);
        }
        if (firstChoice != null) {
            firstChoice.send(aMessage, priority);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    public void sendDownTree(SIBUuid8[] targets, int priority, AbstractMessage cMsg) {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendDownTree", (Object)new Object[]{this, cMsg, priority, targets});
        }
        int length = targets.length;
        MPConnection[] send = new MPConnection[length];
        int[] cCount = new int[length];
        int numSendConnections = 0;
        block0: for (i = 0; i < length; ++i) {
            SIBUuid8 targetMEUuid = targets[i];
            MPConnection firstChoice = this.findMPConnection(targetMEUuid);
            if (TraceComponent.isAnyTracingEnabled()) {
                MECommsTrc.traceMessage(tc, this._messageProcessor, cMsg.getGuaranteedTargetMessagingEngineUUID(), "--SEND->", firstChoice, cMsg);
            }
            if (firstChoice == null) continue;
            int j = 0;
            for (j = 0; j < i && send[j] != null; ++j) {
                if (!send[j].equals(firstChoice)) continue;
                int n = j;
                cCount[n] = cCount[n] + 1;
                continue block0;
            }
            if (j + 1 > numSendConnections) {
                numSendConnections = j + 1;
            }
            send[j] = firstChoice;
            int n = j;
            cCount[n] = cCount[n] + 1;
        }
        for (i = 0; i < numSendConnections; ++i) {
            if (send[i] == null) continue;
            send[i].send(cMsg, priority);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendDownTree");
        }
    }

    public boolean isMEReachable(SIBUuid8 meUuid) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMEReachable", (Object)new Object[]{this, meUuid});
        }
        boolean bl = result = this.findMPConnection(meUuid) != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMEReachable", (Object)result);
        }
        return result;
    }

    public boolean isCompatibleME(SIBUuid8 meUuid, ProtocolVersion version) {
        ProtocolVersion otherVersion;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isCompatibleME", (Object)new Object[]{meUuid});
        }
        boolean result = false;
        MPConnection conn = this.findMPConnection(meUuid);
        if (conn != null && (otherVersion = conn.getVersion()) != null && otherVersion.compareTo(version) >= 0) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isCompatibleME", (Object)result);
        }
        return result;
    }

    public void forceConnect(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceConnect", (Object)meUuid);
        }
        if (this._routingManager != null) {
            this._routingManager.connectToME(meUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceConnect");
        }
    }
}

