/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.proxyhandler.BusGroup;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

final class Neighbours {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(Neighbours.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Hashtable _neighbours;
    private Hashtable _recoveredNeighbours;
    private HashMap _topicSpaces;
    private BusGroup[] _buses;
    private MultiMEProxyHandler _proxyHandler;
    private DestinationManager _destinationManager;
    private String _localBusName;

    Neighbours(MultiMEProxyHandler proxyHandler, String localBusName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Neighbours", (Object)new Object[]{proxyHandler, localBusName});
        }
        this._proxyHandler = proxyHandler;
        this._neighbours = new Hashtable();
        this._buses = new BusGroup[0];
        this._topicSpaces = new HashMap();
        this._recoveredNeighbours = new Hashtable();
        this._localBusName = localBusName;
        this._destinationManager = this._proxyHandler.getMessageProcessor().getDestinationManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Neighbours", (Object)this);
        }
    }

    final BusGroup[] getAllBuses() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllBuses");
            SibTr.exit((TraceComponent)tc, (String)"getAllBuses", (Object)this._buses);
        }
        return this._buses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Enumeration getAllNeighbours() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllNeighbours");
        }
        Enumeration allNeighbours = null;
        Hashtable hashtable = this._neighbours;
        synchronized (hashtable) {
            allNeighbours = ((Hashtable)this._neighbours.clone()).elements();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllNeighbours");
        }
        return allNeighbours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Enumeration getAllRecoveredNeighbours() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllRecoveredNeighbours");
        }
        Enumeration allRecoveredNeighbours = null;
        Hashtable hashtable = this._recoveredNeighbours;
        synchronized (hashtable) {
            allRecoveredNeighbours = this._recoveredNeighbours.elements();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllRecoveredNeighbours");
        }
        return allRecoveredNeighbours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTopicSpaceReference(SIBUuid8 neighbourUuid, SIBUuid12 topicSpace, String topic, boolean warmRestarted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopicSpaceReference", (Object)new Object[]{neighbourUuid, topicSpace, topic, new Boolean(warmRestarted)});
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            TemporarySubscription sub = (TemporarySubscription)this._topicSpaces.get(topicSpace);
            Neighbour neighbour = null;
            if (warmRestarted) {
                Hashtable hashtable = this._recoveredNeighbours;
                synchronized (hashtable) {
                    neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(neighbourUuid));
                }
            } else {
                neighbour = this.getNeighbour(neighbourUuid);
            }
            MESubscription subscription = neighbour.getSubscription(topicSpace, topic);
            if (sub == null) {
                sub = new TemporarySubscription(neighbourUuid, subscription);
                this._topicSpaces.put(topicSpace, sub);
            } else {
                sub.addTopic(neighbourUuid, subscription);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopicSpaceReference");
        }
    }

    protected TemporarySubscription getTemporarySubscription(SIBUuid12 topicSpace) {
        return (TemporarySubscription)this._topicSpaces.get(topicSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTopicSpaceReference(SIBUuid8 neighbourUuid, MESubscription subscription, SIBUuid12 topicSpace, String topic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTopicSpaceReference", (Object)new Object[]{neighbourUuid, subscription, topicSpace, topic});
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            TemporarySubscription sub = (TemporarySubscription)this._topicSpaces.get(topicSpace);
            if (sub == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"TemporarySubscription not found");
                }
            } else if (sub.removeTopic(neighbourUuid, subscription)) {
                this._topicSpaces.remove(topicSpace);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTopicSpaceReference");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void topicSpaceCreated(DestinationHandler destination) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceCreated", (Object)destination);
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            if (this._topicSpaces.containsKey(destination.getUuid())) {
                ArrayList<SIBUuid12> topicSpacesCreated = new ArrayList<SIBUuid12>();
                ArrayList<String> topicsCreated = new ArrayList<String>();
                TemporarySubscription tsubscription = (TemporarySubscription)this._topicSpaces.get(destination.getUuid());
                Iterator neighbourUuids = tsubscription.iMETopicList.keySet().iterator();
                while (neighbourUuids.hasNext()) {
                    boolean recoveredNeighbour;
                    topicSpacesCreated.clear();
                    topicsCreated.clear();
                    SIBUuid8 neighbourUuid = (SIBUuid8)neighbourUuids.next();
                    Iterator subscriptions = ((List)tsubscription.iMETopicList.get(neighbourUuid)).iterator();
                    Neighbour neighbour = this.getNeighbour(neighbourUuid);
                    boolean bl = recoveredNeighbour = neighbour == null;
                    if (neighbour == null) {
                        Hashtable hashtable = this._recoveredNeighbours;
                        synchronized (hashtable) {
                            neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(neighbourUuid));
                        }
                    }
                    while (subscriptions.hasNext()) {
                        MESubscription subscription = (MESubscription)((Object)subscriptions.next());
                        boolean proxyCreated = this.createProxy(neighbour, destination, subscription, destination.getUuid(), subscription.getTopic(), false);
                        try {
                            if (!recoveredNeighbour) {
                                subscription.eventPostCommitAdd(null);
                            }
                        }
                        catch (SevereMessageStoreException severeMessageStoreException) {
                            // empty catch block
                        }
                        if (proxyCreated) {
                            if (!recoveredNeighbour) {
                                topicSpacesCreated.add(destination.getUuid());
                                topicsCreated.add(subscription.getTopic());
                                continue;
                            }
                            PubSubOutputHandler h = destination.getPubSubOutputHandler(neighbour.getUUID());
                            neighbour.addPubSubOutputHandler(h);
                            continue;
                        }
                        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:463:1.113"}, null));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.topicSpaceCreated", (String)"1:469:1.113", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"topicSpaceCreated", (Object)((Object)e));
                        }
                        throw e;
                    }
                    this._proxyHandler.subscribeEvent(topicSpacesCreated, topicsCreated, neighbour.getBusId(), null);
                }
                this._topicSpaces.remove(destination.getUuid());
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No proxy subscriptions to register");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void topicSpaceDeleted(DestinationHandler destination) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceDeleted", (Object)destination);
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            HashMap pubsubOutputHandlers = (HashMap)destination.getAllPubSubOutputHandlers().clone();
            destination.unlockPubsubOutputHandlers();
            if (pubsubOutputHandlers != null && pubsubOutputHandlers.size() > 0) {
                ArrayList<SIBUuid12> topicSpacesDeleted = new ArrayList<SIBUuid12>();
                ArrayList<String> topicsDeleted = new ArrayList<String>();
                Iterator neighbourUuids = pubsubOutputHandlers.keySet().iterator();
                while (neighbourUuids.hasNext()) {
                    topicSpacesDeleted.clear();
                    topicsDeleted.clear();
                    SIBUuid8 neighbourUuid = (SIBUuid8)neighbourUuids.next();
                    PubSubOutputHandler handler = (PubSubOutputHandler)pubsubOutputHandlers.get(neighbourUuid);
                    String[] topics = handler.getTopics();
                    Neighbour neighbour = this.getNeighbour(neighbourUuid);
                    boolean warmRestarted = false;
                    if (neighbour == null) {
                        Hashtable hashtable = this._recoveredNeighbours;
                        synchronized (hashtable) {
                            neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(neighbourUuid));
                        }
                        warmRestarted = true;
                    }
                    if (neighbour != null && topics != null) {
                        for (int i = 0; i < topics.length; ++i) {
                            if (!warmRestarted) {
                                MESubscription meSub = neighbour.getSubscription(destination.getUuid(), topics[i]);
                                ControllableProxySubscription sub = meSub.getMatchspaceSub();
                                this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().removePubSubOutputHandlerMatchTarget(sub);
                                destination.getSubscriptionIndex().remove(sub);
                            }
                            handler.removeTopic(topics[i]);
                            this.addTopicSpaceReference(neighbourUuid, destination.getUuid(), topics[i], warmRestarted);
                            topicSpacesDeleted.add(destination.getUuid());
                            topicsDeleted.add(topics[i]);
                        }
                    }
                    destination.deletePubSubOutputHandler(neighbourUuid);
                    if (neighbour == null) continue;
                    this._proxyHandler.unsubscribeEvent(topicSpacesDeleted, topicsDeleted, neighbour.getBusId(), null);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceDeleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int size() {
        int theSize = 0;
        Hashtable hashtable = this._neighbours;
        synchronized (hashtable) {
            theSize = this._neighbours.size();
        }
        return theSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Neighbour addNeighbour(SIBUuid8 meUUID, String busId, Transaction transaction) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNeighbour", (Object)new Object[]{meUUID, busId});
        }
        Neighbour neighbour = null;
        Hashtable hashtable = this._neighbours;
        synchronized (hashtable) {
            if (this._neighbours.containsKey(meUUID)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addNeighbour", (Object)"Neighbour already exists");
                }
                return (Neighbour)((Object)this._neighbours.get(meUUID));
            }
        }
        hashtable = this._recoveredNeighbours;
        synchronized (hashtable) {
            neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(meUUID));
        }
        if (neighbour != null) {
            hashtable = this._recoveredNeighbours;
            synchronized (hashtable) {
                this._recoveredNeighbours.remove(meUUID);
            }
            HashSet handlers = neighbour.getPubSubOutputHandlers();
            if (handlers != null) {
                for (PubSubOutputHandler h : handlers) {
                    String[] topics = h.getTopics();
                    if (topics == null) continue;
                    for (int i = 0; i < topics.length; ++i) {
                        MESubscription meSub = neighbour.getSubscription(h.getTopicSpaceUuid(), topics[i]);
                        ControllableProxySubscription sub = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().addPubSubOutputHandlerMatchTarget(h, h.getTopicSpaceUuid(), h.getTopics()[i], meSub.isForeignSecuredProxy(), meSub.getMESubUserId());
                        meSub.setMatchspaceSub(sub);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Neighbour recovered " + (Object)((Object)neighbour)));
            }
        } else {
            try {
                neighbour = new Neighbour(this._proxyHandler, meUUID, busId, this);
                if (transaction == null) {
                    transaction = this._proxyHandler.getMessageProcessor().getTXManager().createAutoCommitTransaction();
                }
                this._proxyHandler.addItemStream(neighbour, transaction);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.addNeighbour", (String)"1:755:1.113", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addNeighbour", (Object)"SIResourceException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:764:1.113", e, meUUID});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:773:1.113", e, meUUID}, null), (Throwable)e);
            }
        }
        Hashtable e = this._neighbours;
        synchronized (e) {
            this._neighbours.put(meUUID, neighbour);
        }
        BusGroup group = this.findBus(busId);
        if (group == null) {
            group = this.createBus(busId);
        }
        group.addNeighbour(neighbour);
        neighbour.setBus(group);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNeighbour", (Object)((Object)neighbour));
        }
        return neighbour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNeighbour(SIBUuid8 meUUID, String busId, Transaction transaction) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeNeighbour", (Object)new Object[]{busId, transaction});
        }
        boolean recoveredNeighbour = false;
        Neighbour neighbour = null;
        Hashtable hashtable = this._neighbours;
        synchronized (hashtable) {
            neighbour = (Neighbour)((Object)this._neighbours.get(meUUID));
        }
        if (neighbour == null) {
            recoveredNeighbour = true;
            hashtable = this._recoveredNeighbours;
            synchronized (hashtable) {
                neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(meUUID));
            }
        }
        if (neighbour != null) {
            BusGroup group = neighbour.getBus();
            if (group != null) {
                group.removeNeighbour(neighbour);
                if (group.getMembers().length == 0) {
                    this.deleteBus(group);
                }
            }
            this.removeRegisteredProxies(neighbour, transaction, !recoveredNeighbour);
            try {
                neighbour.remove(transaction, neighbour.getLockID());
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.removeRegisteredProxies", (String)"1:879:1.113", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeRegisteredProxies", (Object)"SIResourceException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:888:1.113", e, neighbour.getUUID()});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:897:1.113", e, neighbour.getUUID()}, null), (Throwable)e);
            }
            if (!recoveredNeighbour) {
                Hashtable hashtable2 = this._neighbours;
                synchronized (hashtable2) {
                    this._neighbours.remove(meUUID);
                }
            } else {
                Hashtable hashtable3 = this._recoveredNeighbours;
                synchronized (hashtable3) {
                    this._recoveredNeighbours.remove(meUUID);
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeNeighbour", (Object)"Neighbour Unknown");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:932:1.113", meUUID});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:940:1.113", meUUID}, null));
        }
        neighbour.deleteDestination();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeNeighbour");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRecoveredNeighbour(SIBUuid8 neighbourUuid, Transaction transaction) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRecoveredNeighbour", (Object)new Object[]{neighbourUuid, transaction});
        }
        Neighbour neighbour = null;
        Hashtable hashtable = this._recoveredNeighbours;
        synchronized (hashtable) {
            neighbour = (Neighbour)((Object)this._recoveredNeighbours.remove(neighbourUuid));
        }
        this.removeRegisteredProxies(neighbour, transaction, false);
        neighbour.deleteDestination();
        neighbour.deleteSystemDestinations();
        try {
            neighbour.remove(transaction, neighbour.getLockID());
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.removeNeighbour", (String)"1:994:1.113", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeRecoveredNeighbour", (Object)"SIResourceException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1003:1.113", e, neighbour.getUUID()});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1012:1.113", e, neighbour.getUUID()}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRecoveredNeighbour");
        }
    }

    private void removeRegisteredProxies(Neighbour neighbour, Transaction transaction, boolean wasRecovered) throws SIResourceException {
        Hashtable registeredProxies;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRegisteredProxies", (Object)new Object[]{neighbour, transaction, new Boolean(wasRecovered)});
        }
        if (!(registeredProxies = neighbour.getRegisteredProxies()).isEmpty()) {
            boolean proxiesDeregistered = false;
            Enumeration subscriptions = registeredProxies.elements();
            ArrayList<String> topics = new ArrayList<String>();
            ArrayList<SIBUuid12> topicSpaces = new ArrayList<SIBUuid12>();
            while (subscriptions.hasMoreElements()) {
                MESubscription subscription = (MESubscription)((Object)subscriptions.nextElement());
                neighbour.proxyDeregistered(subscription.getTopicSpaceUuid(), subscription.getTopic(), transaction);
                DestinationHandler destination = this._destinationManager.getDestinationInternal(subscription.getTopicSpaceUuid(), false);
                boolean deleted = this.deleteProxy(destination, subscription, neighbour, subscription.getTopicSpaceUuid(), subscription.getTopic(), wasRecovered, true);
                if (!deleted) continue;
                topics.add(subscription.getTopic());
                topicSpaces.add(subscription.getTopicSpaceUuid());
                proxiesDeregistered = true;
            }
            if (proxiesDeregistered && wasRecovered) {
                this._proxyHandler.unsubscribeEvent(topicSpaces, topics, neighbour.getBusId(), null);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("no proxies registered for neighbour " + neighbour.getUUID().toString()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRegisteredProxies");
        }
    }

    private BusGroup findBus(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findBus", (Object)name);
        }
        for (int i = 0; i < this._buses.length; ++i) {
            if (!this._buses[i].getName().equals(name)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findBus", (Object)this._buses[i]);
            }
            return this._buses[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findBus", (Object)"null");
        }
        return null;
    }

    private BusGroup createBus(String busId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBus", (Object)busId);
        }
        boolean isLocalBus = busId.equals(this._localBusName);
        BusGroup group = new BusGroup(busId, this._proxyHandler, isLocalBus);
        BusGroup[] tempBuses = this._buses;
        this._buses = new BusGroup[tempBuses.length + 1];
        System.arraycopy(tempBuses, 0, this._buses, 0, tempBuses.length);
        this._buses[tempBuses.length] = group;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBus", (Object)group);
        }
        return group;
    }

    private void deleteBus(BusGroup group) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteBus", (Object)group);
        }
        BusGroup[] t = this._buses;
        for (int i = 0; i < this._buses.length; ++i) {
            if (!this._buses[i].equals(group)) continue;
            this._buses = new BusGroup[t.length - 1];
            if (i > 0) {
                System.arraycopy(t, 0, this._buses, 0, i);
            }
            if (i >= t.length - 1) break;
            System.arraycopy(t, i + 1, this._buses, i, t.length - 1 - i);
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteBus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Neighbour getNeighbour(SIBUuid8 neighbourUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNeighbour", (Object)neighbourUuid);
        }
        Neighbour neighbour = null;
        Hashtable hashtable = this._neighbours;
        synchronized (hashtable) {
            neighbour = (Neighbour)((Object)this._neighbours.get(neighbourUuid));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNeighbour", (Object)((Object)neighbour));
        }
        return neighbour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Neighbour getRecoveredNeighbour(SIBUuid8 neighbourUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRecoveredNeighbour", (Object)neighbourUuid);
        }
        Neighbour neighbour = null;
        Hashtable hashtable = this._recoveredNeighbours;
        synchronized (hashtable) {
            neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(neighbourUuid));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRecoveredNeighbour", (Object)((Object)neighbour));
        }
        return neighbour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Neighbour getBusNeighbour(String busId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusNeighbour", (Object)busId);
        }
        Neighbour neighbour = null;
        Hashtable hashtable = this._neighbours;
        synchronized (hashtable) {
            Iterator neighbours = this._neighbours.keySet().iterator();
            while (neighbours.hasNext()) {
                neighbour = this.getNeighbour((SIBUuid8)neighbours.next());
                if (!neighbour.getBusId().equals(busId)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getBusNeighbour", (Object)((Object)neighbour));
                }
                return neighbour;
            }
        }
        hashtable = this._recoveredNeighbours;
        synchronized (hashtable) {
            Iterator recoveredNeighbours = this._recoveredNeighbours.keySet().iterator();
            while (recoveredNeighbours.hasNext()) {
                neighbour = (Neighbour)((Object)this._recoveredNeighbours.get(recoveredNeighbours.next()));
                if (!neighbour.getBusId().equals(busId)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getBusNeighbour", (Object)((Object)neighbour));
                }
                return neighbour;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBusNeighbour", null);
        }
        return null;
    }

    protected boolean createProxy(Neighbour neighbour, DestinationHandler destination, MESubscription subscription, SIBUuid12 topicSpace, String topic, boolean warmRestarted) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxy", (Object)new Object[]{neighbour, destination, subscription, topicSpace, topic, new Boolean(warmRestarted)});
        }
        boolean outputHandlerCreated = false;
        if (destination != null) {
            PubSubOutputHandler handler = destination.getPubSubOutputHandler(neighbour.getUUID());
            if (handler == null) {
                handler = destination.createPubSubOutputHandler(neighbour);
            }
            handler.setTopicSpaceMapping(subscription.getForeignTSName());
            handler.addTopic(topic);
            subscription.registerForPostCommit(this._proxyHandler, destination, handler, neighbour);
            outputHandlerCreated = true;
        } else {
            this.addTopicSpaceReference(neighbour.getUUID(), topicSpace, topic, warmRestarted);
            subscription.registerForPostCommit(neighbour, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxy", (Object)new Boolean(outputHandlerCreated));
        }
        return outputHandlerCreated;
    }

    protected boolean deleteProxy(DestinationHandler destination, MESubscription subscription, Neighbour neighbour, SIBUuid12 topicSpace, String topic, boolean wasRecovered, boolean deleteHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteProxy", (Object)new Object[]{destination, neighbour, subscription, topicSpace, topic});
        }
        boolean outputHandlerDeleted = false;
        if (destination != null) {
            PubSubOutputHandler handler = destination.getPubSubOutputHandler(neighbour.getUUID());
            if (handler != null) {
                handler.removeTopic(topic);
                if (!deleteHandler) {
                    handler = null;
                }
                if (wasRecovered) {
                    subscription.registerForPostCommit(this._proxyHandler, destination, handler, neighbour);
                } else {
                    subscription.registerForPostCommit(null, destination, handler, neighbour);
                }
                outputHandlerDeleted = true;
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"PubSubOutputHandler not found");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Destination object not found");
            }
            if (wasRecovered) {
                subscription.registerForPostCommit(neighbour, this);
            } else {
                subscription.registerForPostCommit(null, destination, null, neighbour);
            }
            this.removeTopicSpaceReference(neighbour.getUUID(), subscription, topicSpace, topic);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteProxy", (Object)new Boolean(outputHandlerDeleted));
        }
        return outputHandlerDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverNeighbours() throws MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverNeighbours");
        }
        NonLockingCursor cursor = null;
        try {
            cursor = this._proxyHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(Neighbour.class));
            AbstractItem item = null;
            while ((item = cursor.next()) != null) {
                Neighbour neighbour = null;
                neighbour = (Neighbour)item;
                Hashtable hashtable = this._recoveredNeighbours;
                synchronized (hashtable) {
                    this._recoveredNeighbours.put(neighbour.getUUID(), neighbour);
                }
                neighbour.intialiseNonPersistent(this._proxyHandler, this);
                neighbour.recoverSubscriptions(this._proxyHandler);
                if (neighbour.getBusId().equals(this._proxyHandler.getMessageProcessor().getMessagingEngineBus())) continue;
                ForeignBusDefinition bus = this._proxyHandler.getMessageProcessor().getForeignBus(neighbour.getBusId());
                if (bus != null) {
                    try {
                        VirtualLinkDefinition vLinkDef = bus.getLink();
                        if (vLinkDef != null && vLinkDef.getLinkLocalitySet() != null && vLinkDef.getLinkLocalitySet().contains(neighbour.getUUID().toString())) {
                            try {
                                this.addNeighbour(neighbour.getUUID(), neighbour.getBusId(), null);
                                continue;
                            }
                            catch (SIException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.recoverNeighbours", (String)"1:1534:1.113", (Object)this);
                                SIErrorException finalE = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1542:1.113", e}, null), (Throwable)e);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1551:1.113", e});
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"recoverNeighbours", (Object)((Object)finalE));
                                }
                                throw finalE;
                            }
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Link no longer exists " + neighbour.getBusId() + " for neighbour " + neighbour.getUUID()));
                    }
                    catch (SIBExceptionNoLinkExists e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Link no longer exists " + neighbour.getBusId() + " for neighbour " + neighbour.getUUID() + " : " + (Object)((Object)e)));
                    }
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Bus no longer exists " + neighbour.getBusId() + " for neighbour " + neighbour.getUUID()));
            }
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverNeighbours");
        }
    }

    private void addSubscriptionsToBus(BusGroup group, String busId) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscriptionsToBus", (Object)new Object[]{group, busId});
        }
        ArrayList cdList = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().getAllCDMatchTargets();
        ListIterator cdIterator = cdList.listIterator();
        while (cdIterator.hasNext()) {
            ConsumerDispatcher cd = (ConsumerDispatcher)cdIterator.next();
            group.addLocalSubscription(cd.getConsumerDispatcherState(), null, null, false);
        }
        ArrayList phList = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().getAllPubSubOutputHandlerMatchTargets();
        ArrayList<PubSubOutputHandler> outputSeenList = new ArrayList<PubSubOutputHandler>();
        ListIterator phIterator = phList.listIterator();
        while (phIterator.hasNext()) {
            PubSubOutputHandler oh = (PubSubOutputHandler)phIterator.next();
            if (outputSeenList.contains(oh) || !oh.neighbourOnDifferentBus(busId)) continue;
            String[] topics = oh.getTopics();
            SIBUuid12 topicSpaceUuid = oh.getTopicSpaceUuid();
            if (topics != null && topics.length > 0) {
                for (int i = 0; i < topics.length; ++i) {
                    group.addRemoteSubscription(topicSpaceUuid, topics[i], null, false);
                }
            }
            outputSeenList.add(oh);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscriptionsToBus");
        }
    }

    protected void resetBusSubscriptionList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetBusSubscriptionList");
        }
        for (int i = 0; i < this._buses.length; ++i) {
            BusGroup group = this._buses[i];
            group.reset();
            try {
                this.addSubscriptionsToBus(group, group.getName());
                SubscriptionMessage message = group.generateResetSubscriptionMessage();
                LocalTransaction transaction = this._proxyHandler.getMessageProcessor().getTXManager().createLocalTransaction(true);
                group.sendToNeighbours(message, (Transaction)transaction, true);
                transaction.commit();
                continue;
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                group.resetListFailed();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetBusSubscriptionList");
        }
    }

    class TemporarySubscription {
        private HashMap iMETopicList;

        TemporarySubscription(SIBUuid8 neighbourUuid, MESubscription subscription) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"TemporarySubscription", (Object)new Object[]{neighbourUuid, subscription});
            }
            this.iMETopicList = new HashMap();
            LinkedList<MESubscription> topics = new LinkedList<MESubscription>();
            topics.add(subscription);
            this.iMETopicList.put(neighbourUuid, topics);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"TemporarySubscription", (Object)this);
            }
        }

        protected void addTopic(SIBUuid8 neighbourUuid, MESubscription subscription) {
            LinkedList<MESubscription> list;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"addTopic", (Object)new Object[]{neighbourUuid, subscription});
            }
            if ((list = (LinkedList<MESubscription>)this.iMETopicList.get(neighbourUuid)) == null) {
                list = new LinkedList<MESubscription>();
            }
            list.add(subscription);
            this.iMETopicList.put(neighbourUuid, list);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTopic");
            }
        }

        protected boolean removeTopic(SIBUuid8 neighbourUuid, MESubscription subscription) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeTopic", (Object)new Object[]{neighbourUuid, subscription});
            }
            boolean returnVal = false;
            List list = (List)this.iMETopicList.get(neighbourUuid);
            if (list != null) {
                list.remove((Object)subscription);
                if (list.isEmpty()) {
                    this.iMETopicList.remove(neighbourUuid);
                    returnVal = this.iMETopicList.isEmpty();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeTopic", (Object)new Boolean(returnVal));
            }
            return returnVal;
        }
    }
}

