/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.session.SessionContextRegistry;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionProperties;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.utils.EncodeCloneID;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.staticvalue.StaticValue;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class SessionMgrComponentImpl
implements SessionManager {
    public static final StaticValue<AtomicReference<SessionMgrComponentImpl>> INSTANCE = StaticValue.createStaticValue((Callable)new Callable<AtomicReference<SessionMgrComponentImpl>>(){

        @Override
        public AtomicReference<SessionMgrComponentImpl> call() throws Exception {
            return new AtomicReference<SessionMgrComponentImpl>();
        }
    });
    private final SessionManagerConfig serverLevelSessionManagerConfig = new SessionManagerConfig();
    private final WsLocationAdmin wsLocationAdmin;
    private final SessionStoreService sessionStoreService;
    private final Map<String, Object> mergedConfiguration;
    private final ScheduledExecutorService scheduledExecutorService;
    private boolean initialized = false;
    private static final String methodClassName = "SessionMgrComponentImpl";

    public static SessionManagerConfig getServerSessionManagerConfig() {
        SessionMgrComponentImpl service = (SessionMgrComponentImpl)((AtomicReference)INSTANCE.get()).get();
        if (service == null) {
            return null;
        }
        return service.getServerConfig();
    }

    @Override
    public SessionManagerConfig getServerConfig() {
        this.initialize();
        return this.serverLevelSessionManagerConfig;
    }

    @Override
    public SessionStoreService getSessionStoreService() {
        this.initialize();
        return this.sessionStoreService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        this.initialize();
        return this.scheduledExecutorService;
    }

    private SessionStoreService getSessionStoreService(SessionStoreService storeService, Object storageRef) {
        if (storeService == null) {
            return null;
        }
        if (!storeService.isValid()) {
            return null;
        }
        Map<String, Object> storeProperties = storeService.getConfiguration();
        if (storeProperties == null) {
            return null;
        }
        Object storeId = storeProperties.get("id");
        if (storageRef == null) {
            return storeService;
        }
        if (storeId == null) {
            return null;
        }
        if (storageRef.equals(storeId)) {
            return storeService;
        }
        return null;
    }

    private String getServerId() {
        UUID fullServerId = null;
        WsLocationAdmin locationService = this.wsLocationAdmin;
        if (locationService != null) {
            fullServerId = locationService.getServerId();
        }
        if (fullServerId == null) {
            fullServerId = UUID.randomUUID();
        }
        return fullServerId.toString().toLowerCase();
    }

    @Override
    public void start(SessionContextRegistry scr) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "start");
        }
        this.initialize();
        scr.setPropertiesInSMC(this.serverLevelSessionManagerConfig);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            this.serverLevelSessionManagerConfig.printSessionManagerConfigForDebug(LoggingUtil.SESSION_LOGGER_CORE);
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "start");
        }
    }

    public SessionMgrComponentImpl(ScheduledExecutorService scheduledExecutorService, WsLocationAdmin wsLocationAdmin, SessionStoreService sessionStoreService, Dictionary<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "<init>", "properties=" + properties);
        }
        this.wsLocationAdmin = wsLocationAdmin;
        this.scheduledExecutorService = scheduledExecutorService;
        this.mergedConfiguration = new HashMap<String, Object>();
        if (properties != null) {
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = properties.get(key);
                this.mergedConfiguration.put(key, value);
            }
        }
        Object storageRef = this.mergedConfiguration.get("storageRef");
        this.sessionStoreService = this.getSessionStoreService(sessionStoreService, storageRef);
        if (this.sessionStoreService != null) {
            Map<String, Object> storeProperties = this.sessionStoreService.getConfiguration();
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "<init>", "storeProperties=" + storeProperties);
            }
            if (storeProperties != null) {
                this.mergedConfiguration.putAll(storeProperties);
            }
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        if (LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.INFO)) {
            if (this.sessionStoreService == null) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, "initialize", "SessionMgrComponentImpl.noPersistence");
            } else {
                String modeName = "sessionPersistenceMode";
                Object modeValue = this.mergedConfiguration.get(modeName);
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.INFO, methodClassName, "initialize", "SessionMgrComponentImpl.persistenceMode", new Object[]{modeValue});
            }
        }
        SessionProperties.setPropertiesInSMC(this.serverLevelSessionManagerConfig, this.mergedConfiguration);
        String cloneId = SessionManagerConfig.getCloneId();
        if (cloneId == null) {
            if (this.sessionStoreService == null && SessionManagerConfig.isTurnOffCloneId()) {
                cloneId = "";
            } else {
                String serverId = this.getServerId();
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "initialize", "serverId=" + serverId);
                }
                SessionManagerConfig.setServerId(serverId);
                cloneId = EncodeCloneID.encodeString(serverId);
            }
            SessionManagerConfig.setCloneId(cloneId);
        }
        this.initialized = true;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getCloneID() {
        this.initialize();
        return SessionManagerConfig.getCloneId();
    }

    @Override
    public char getCloneSeparator() {
        this.initialize();
        return SessionManagerConfig.getCloneSeparator();
    }

    @Override
    public String getAffinityUrlIdentifier() {
        this.initialize();
        String rewriteId = this.serverLevelSessionManagerConfig.getSessUrlRewritePrefix();
        return rewriteId.substring(1, rewriteId.length() - 1);
    }

    @Override
    public String getDefaultAffinityCookie() {
        this.initialize();
        return this.serverLevelSessionManagerConfig.getSessionCookieName();
    }

    public void stop() {
    }
}

