/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v11.cdi.internal;

import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.beanvalidation.service.ValidationReleasable;
import com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationReleasableImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.bval.ValidationConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.bval.cdi.BValExtension;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ValidationExtensionService {
    private static final TraceComponent tc = Tr.register(ValidationExtensionService.class, (String)"BeanValidation", null);
    private static final String REFERENCE_BEANVALIDATION_SERVICE = "beanValidation";
    private static final String REFERENCE_CLASSLOADING_SERVICE = "classLoadingService";
    protected final AtomicServiceReference<BeanValidation> beanValidation = new AtomicServiceReference("beanValidation");
    final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    protected ValidationConfig validationConfig;
    private static volatile ValidationExtensionService svInstance = null;
    protected static final PrivilegedAction<ThreadContextAccessor> getThreadContextAccessorAction = new PrivilegedAction<ThreadContextAccessor>(){
        static final long serialVersionUID = -7195880083988677679L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public ThreadContextAccessor run() {
            return ThreadContextAccessor.getThreadContextAccessor();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String)"BeanValidation", null);
        }
    };
    private static PrivilegedAction<ClassLoader> getContextClassLoaderAction = new PrivilegedAction<ClassLoader>(){
        static final long serialVersionUID = -8034793122342385275L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class, (String)"BeanValidation", null);
        }
    };
    static final long serialVersionUID = -6427473387764147705L;

    static ValidationExtensionService instance() {
        return svInstance;
    }

    static void setInstance(ValidationExtensionService instance) {
        if (svInstance != null && instance != null) {
            throw new IllegalStateException("instance already set");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInstance : " + Util.identity((Object)instance)), (Object[])new Object[0]);
        }
        svInstance = instance;
    }

    protected void activate(ComponentContext compcontext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        ValidationExtensionService.setInstance(this);
        this.beanValidation.activate(compcontext);
        this.classLoadingServiceSR.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        ValidationExtensionService.setInstance(null);
        this.beanValidation.deactivate(compcontext);
        this.classLoadingServiceSR.deactivate(compcontext);
    }

    @Reference(name="beanValidation", service=BeanValidation.class)
    protected void setBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidation.setReference(ref);
    }

    protected void unsetBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidation.unsetReference(ref);
    }

    @Reference(name="classLoadingService", service=ClassLoadingService.class)
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public Validator getDefaultValidator() {
        BeanValidation beanValidation = (BeanValidation)ValidationExtensionService.instance().beanValidation.getService();
        if (beanValidation == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning a null Validator because the BeanValidation service is not currently unavailable. Is the bean validation feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return beanValidation.getValidator(componentMetaData);
        }
        catch (ValidationException componentMetaData) {
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtensionService", (String)"158", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Returning a null Validator: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ValidatorFactory getDefaultValidatorFactory() {
        BeanValidation beanValidation = (BeanValidation)ValidationExtensionService.instance().beanValidation.getService();
        if (beanValidation == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning a null ValidatorFactory because the BeanValidation service is not currently available.  Is the bean validation feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return beanValidation.getValidatorFactory(componentMetaData);
        }
        catch (ValidationException componentMetaData) {
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtensionService", (String)"177", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Returning a null ValidatorFactory: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BValExtension createBValExtension(BeanManager beanManager) {
        BValExtension bValExtension;
        ClassLoader classLoader;
        SetContextClassLoaderPrivileged setClassLoader;
        block15: {
            ValidationExtensionService validatorService = ValidationExtensionService.instance();
            if (validatorService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Returning a null BValExtension object because the validatorService service is not currently unavailable.", (Object[])new Object[0]);
                }
                return null;
            }
            setClassLoader = null;
            ClassLoader oldClassLoader = null;
            classLoader = null;
            try {
                classLoader = this.configureBvalClassloader(null);
                ThreadContextAccessor tca = System.getSecurityManager() == null ? ThreadContextAccessor.getThreadContextAccessor() : AccessController.doPrivileged(getThreadContextAccessorAction);
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of" + oldClassLoader + " and newClassLoader of " + classLoader), (Object[])new Object[0]);
                }
                bValExtension = (BValExtension)this.createValidationReleasable(beanManager, BValExtension.class).getInstance();
                if (setClassLoader == null) break block15;
            }
            catch (ValidationException tca) {
                block16: {
                    try {
                        FFDCFilter.processException((Throwable)tca, (String)"com.ibm.ws.beanvalidation.v11.cdi.internal.ValidationExtensionService", (String)"210", (Object)this, (Object[])new Object[]{beanManager});
                        if (tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)("Returning a null Configuration: " + e.getMessage()), (Object[])new Object[0]);
                        }
                        bValExtension = null;
                        if (setClassLoader == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (setClassLoader != null) {
                            setClassLoader.execute(oldClassLoader);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                            }
                        }
                        if (setClassLoader != null && setClassLoader.wasChanged) {
                            this.releaseLoader(classLoader);
                        }
                        throw throwable;
                    }
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (setClassLoader != null && setClassLoader.wasChanged) {
                    this.releaseLoader(classLoader);
                }
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
            }
        }
        if (setClassLoader != null && setClassLoader.wasChanged) {
            this.releaseLoader(classLoader);
        }
        return bValExtension;
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(parentCL);
    }

    protected void releaseLoader(ClassLoader tccl) {
        ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).destroyThreadContextClassLoader(tccl);
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(getContextClassLoaderAction);
    }

    protected ClassLoader configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = ValidationExtensionService.getContextClassLoader();
        }
        if (cl != null) {
            ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getServiceWithException();
            if (classLoadingService.isThreadContextClassLoader(cl)) {
                return cl;
            }
            if (classLoadingService.isAppClassLoader(cl)) {
                return this.createTCCL(cl);
            }
        }
        return this.createTCCL(BeanValidation.class.getClassLoader());
    }

    private <T> ValidationReleasable<T> createValidationReleasable(BeanManager beanManager, Class<T> clazz) {
        if (beanManager != null) {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(clazz);
            InjectionTarget it = beanManager.createInjectionTarget(annotatedType);
            CreationalContext context = beanManager.createCreationalContext(null);
            Object instance = it.produce(context);
            it.inject(instance, context);
            it.postConstruct(instance);
            return new ValidationReleasableImpl<Object>(context, it, instance);
        }
        return null;
    }
}

