/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config13.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.config.sources.DynamicConfigSource;
import com.ibm.ws.microprofile.config.sources.InternalConfigSource;
import com.ibm.ws.microprofile.config13.sources.OSGiConfigUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerXMLDefaultVariableConfigSource
extends InternalConfigSource
implements DynamicConfigSource {
    private static final TraceComponent tc = Tr.register(ServerXMLDefaultVariableConfigSource.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config13.resources.Config13");
    private BundleContext bundleContext;
    static final long serialVersionUID = -3944350900265366366L;

    public ServerXMLDefaultVariableConfigSource() {
        super(1, Tr.formatMessage((TraceComponent)tc, (String)"server.xml.variable.config.source", (Object[])new Object[0]));
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Map<String, String> serverXMLDefaultVariables = this.getServerXMLVariables();
        if (serverXMLDefaultVariables != null) {
            props.putAll(serverXMLDefaultVariables);
        }
        return props;
    }

    private Map<String, String> getServerXMLVariables() {
        PrivilegedAction<Map> configAction = () -> {
            if (this.bundleContext == null) {
                this.bundleContext = OSGiConfigUtils.getBundleContext(((Object)((Object)this)).getClass());
            }
            Map<String, String> serverXMLDefaultVariables = null;
            if (this.bundleContext != null) {
                serverXMLDefaultVariables = OSGiConfigUtils.getDefaultVariablesFromServerXML(this.bundleContext);
            }
            return serverXMLDefaultVariables;
        };
        Map props = AccessController.doPrivileged(configAction);
        return props;
    }
}

