/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.serialization.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.DeserializationClassProvider;
import com.ibm.ws.serialization.DeserializationContext;
import com.ibm.ws.serialization.DeserializationObjectResolver;
import com.ibm.ws.serialization.SerializationContext;
import com.ibm.ws.serialization.SerializationObjectReplacer;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.serialization.internal.DeserializationContextImpl;
import com.ibm.ws.serialization.internal.SerializationContextImpl;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={SerializationService.class})
public class SerializationServiceImpl
implements SerializationService {
    private static final TraceComponent tc = Tr.register(SerializationServiceImpl.class, (String)"serialization", null);
    private static final String REFERENCE_REPLACERS = "replacers";
    private static final String REFERENCE_CLASS_PROVIDERS = "classProviders";
    private static final String REFERENCE_RESOLVERS = "resolvers";
    private final ConcurrentServiceReferenceSet<SerializationObjectReplacer> replacers = new ConcurrentServiceReferenceSet("replacers");
    private final ConcurrentServiceReferenceMap<String, DeserializationClassProvider> classProviders = new ConcurrentServiceReferenceMap("classProviders");
    private final ConcurrentServiceReferenceMap<String, DeserializationClassProvider> packageProviders = new ConcurrentServiceReferenceMap("classProviders");
    private final ConcurrentServiceReferenceSet<DeserializationObjectResolver> resolvers = new ConcurrentServiceReferenceSet("resolvers");
    private final SerializationContext defaultSerializationContext = new SerializationContextImpl(this);
    private final DeserializationContext defaultDeserializationContext = new DeserializationContextImpl(this);
    static final long serialVersionUID = 1588725075148965520L;

    public void activate(ComponentContext cc) {
        this.replacers.activate(cc);
        this.classProviders.activate(cc);
        this.packageProviders.activate(cc);
        this.resolvers.activate(cc);
    }

    public void deactivate(ComponentContext cc) {
        this.replacers.deactivate(cc);
        this.classProviders.deactivate(cc);
        this.packageProviders.deactivate(cc);
        this.resolvers.deactivate(cc);
    }

    @Reference(name="replacers", service=SerializationObjectReplacer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addReplacer(ServiceReference<SerializationObjectReplacer> reference) {
        this.replacers.addReference(reference);
    }

    protected void removeReplacer(ServiceReference<SerializationObjectReplacer> reference) {
        this.replacers.removeReference(reference);
    }

    @Reference(name="classProviders", service=DeserializationClassProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addClassProvider(ServiceReference<DeserializationClassProvider> reference) {
        this.updateClassProvider(true, reference);
    }

    protected void removeClassProvider(ServiceReference<DeserializationClassProvider> reference) {
        this.updateClassProvider(false, reference);
    }

    private void updateClassProvider(boolean add, ServiceReference<DeserializationClassProvider> reference) {
        this.updateClassProvider(add, reference, this.classProviders, "classes");
        this.updateClassProvider(add, reference, this.packageProviders, "packages");
    }

    private void updateClassProvider(boolean add, ServiceReference<DeserializationClassProvider> reference, ConcurrentServiceReferenceMap<String, DeserializationClassProvider> map, String key) {
        Object value = reference.getProperty(key);
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String name = (String)value;
            if (add) {
                map.putReference((Object)name, reference);
            } else {
                map.removeReference((Object)name, reference);
            }
        } else if (value instanceof String[]) {
            String[] names;
            for (String name : names = (String[])value) {
                if (add) {
                    map.putReference((Object)name, reference);
                    continue;
                }
                map.removeReference((Object)key, reference);
            }
        }
    }

    @Reference(name="resolvers", service=DeserializationObjectResolver.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addResolver(ServiceReference<DeserializationObjectResolver> reference) {
        this.resolvers.addReference(reference);
    }

    protected void removeResolver(ServiceReference<DeserializationObjectResolver> reference) {
        this.resolvers.removeReference(reference);
    }

    @Override
    public SerializationContext createSerializationContext() {
        return new SerializationContextImpl(this);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream output) throws IOException {
        return this.defaultSerializationContext.createObjectOutputStream(output);
    }

    @Override
    public DeserializationContext createDeserializationContext() {
        return new DeserializationContextImpl(this);
    }

    @Override
    public ObjectInputStream createObjectInputStream(InputStream input, ClassLoader classLoader) throws IOException {
        return this.defaultDeserializationContext.createObjectInputStream(input, classLoader);
    }

    public boolean isReplaceObjectNeeded() {
        return !this.replacers.isEmpty();
    }

    @Sensitive
    public Object replaceObject(@Sensitive Object object) {
        for (SerializationObjectReplacer replacer : this.replacers.services()) {
            Object replacedObject = replacer.replaceObject(object);
            if (replacedObject == null) continue;
            return replacedObject;
        }
        return object;
    }

    @Override
    @Sensitive
    public Object replaceObjectForSerialization(@Sensitive Object object) {
        for (SerializationObjectReplacer replacer : this.replacers.services()) {
            Object replacedObject = replacer.replaceObject(object);
            if (replacedObject == null) continue;
            return replacedObject;
        }
        if (object instanceof Serializable || object instanceof Externalizable) {
            return object;
        }
        return null;
    }

    public boolean isResolveObjectNeeded() {
        return !this.resolvers.isEmpty();
    }

    @Override
    @Sensitive
    public Object resolveObjectWithException(@Sensitive Object object) throws IOException {
        for (DeserializationObjectResolver resolver : this.resolvers.services()) {
            Object resolvedObject = resolver.resolveObject(object);
            if (resolvedObject == null) continue;
            return resolvedObject;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Sensitive
    public Object resolveObject(@Sensitive Object object) {
        try {
            return this.resolveObjectWithException(object);
        }
        catch (IOException iOException) {
            void e;
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.Object>";
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.serialization.internal.SerializationServiceImpl", (String)"234", (Object)this, (Object[])objectArray);
            throw new RuntimeException((Throwable)e);
        }
    }

    Class<?> loadClass(String name) throws ClassNotFoundException {
        String pkg;
        ServiceReference provider = this.classProviders.getReference((Object)name);
        if (provider != null) {
            return this.loadClass(provider, name);
        }
        int index = name.lastIndexOf(46);
        if (index != -1 && (provider = this.packageProviders.getReference((Object)(pkg = name.substring(0, index)))) != null) {
            return this.loadClass(provider, name);
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private Class<?> loadClass(final ServiceReference<?> ref, final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){
                static final long serialVersionUID = 6483039155217603790L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return ref.getBundle().loadClass(name);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"serialization", null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unable to load " + name + " from " + ref), (Object[])new Object[]{e});
            }
            if ((cause = e.getCause()) instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)cause;
            }
            throw new IllegalStateException(cause);
        }
    }
}

