/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryLog;

public class HADBLogAvailabilityManager {
    private static final TraceComponent tc = Tr.register(HADBLogAvailabilityManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static TimeoutInfo _info;

    public static void setTimeout(RecoveryAgent recoveryAgent, RecoveryLog customPartnerLog, int peerLockTimeBetweenHeartbeats) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeout", (Object)new Object[]{recoveryAgent, customPartnerLog, peerLockTimeBetweenHeartbeats});
        }
        HADBLogAvailabilityManager.stopTimeout();
        _info = new TimeoutInfo(recoveryAgent, customPartnerLog, peerLockTimeBetweenHeartbeats);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeout", (Object)_info);
        }
    }

    public static void stopTimeout() {
        if (_info != null) {
            _info.cancelAlarm();
        }
    }

    private static class TimeoutInfo
    implements AlarmListener {
        protected RecoveryAgent _recoveryAgent;
        protected RecoveryLog _customPartnerLog;
        protected final int _duration;
        private Alarm _alarm;
        private final AlarmManager _alarmManager = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager();

        protected TimeoutInfo(RecoveryAgent recoveryAgent, RecoveryLog customPartnerLog, int duration) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TimeoutInfo", (Object)new Object[]{recoveryAgent, customPartnerLog});
            }
            this._duration = duration;
            this._recoveryAgent = recoveryAgent;
            this._customPartnerLog = customPartnerLog;
            this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TimeoutInfo");
            }
        }

        public void alarm(Object alarmContext) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"alarm");
            }
            if (this._recoveryAgent != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Update the HADB timestamp");
                }
                this._recoveryAgent.updateHADBTimestamp(this._customPartnerLog);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"NULL recoveryAgent");
            }
            this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        public void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object)this._alarm);
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancelAlarm");
            }
        }
    }
}

