/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.tx.util.alarm.AlarmManager;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.recoverylog.spi.LibertyRecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.util.ArrayList;

public class LeaseTimeoutManager {
    private static final TraceComponent tc = Tr.register(LeaseTimeoutManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static TimeoutInfo _info;

    public static void setTimeout(SharedServerLeaseLog leaseLog, String recoveryIdentity, String recoveryGroup, RecoveryAgent recoveryAgent, RecoveryDirector recoveryDirector, int seconds) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeout", (Object)new Object[]{leaseLog, recoveryIdentity, recoveryAgent, seconds});
        }
        LeaseTimeoutManager.stopTimeout();
        _info = new TimeoutInfo(leaseLog, recoveryIdentity, recoveryGroup, recoveryAgent, recoveryDirector, seconds);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeout", (Object)_info);
        }
    }

    public static void stopTimeout() {
        if (_info != null) {
            _info.cancelAlarm();
        }
    }

    private static class TimeoutInfo
    implements AlarmListener {
        protected final SharedServerLeaseLog _leaseLog;
        protected String _recoveryIdentity;
        protected String _recoveryGroup;
        protected RecoveryAgent _recoveryAgent;
        protected RecoveryDirector _recoveryDirector;
        protected final int _duration;
        private Alarm _alarm;
        private final AlarmManager _alarmManager = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager();

        protected TimeoutInfo(SharedServerLeaseLog leaseLog, String recoveryIdentity, String recoveryGroup, RecoveryAgent recoveryAgent, RecoveryDirector recoveryDirector, int duration) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TimeoutInfo", (Object)leaseLog);
            }
            this._leaseLog = leaseLog;
            this._duration = duration;
            this._recoveryIdentity = recoveryIdentity;
            this._recoveryGroup = recoveryGroup;
            this._recoveryAgent = recoveryAgent;
            this._recoveryDirector = recoveryDirector;
            this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TimeoutInfo");
            }
        }

        public void alarm(Object alarmContext) {
            block12: {
                block11: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"alarm", (Object)this._leaseLog);
                    }
                    try {
                        if (this._leaseLog.lockLocalLease(this._recoveryIdentity)) {
                            this._leaseLog.updateServerLease(this._recoveryIdentity, this._recoveryGroup, false);
                            this._leaseLog.releaseLocalLease(this._recoveryIdentity);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Could not lock lease for " + this._recoveryIdentity));
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug((TraceComponent)tc, (String)("Swallow exception " + e));
                    }
                }
                if (this._recoveryAgent != null) {
                    ArrayList peersToRecover = this._recoveryAgent.processLeasesForPeers(this._recoveryIdentity, this._recoveryGroup);
                    if (this._recoveryDirector != null && this._recoveryDirector instanceof RecoveryDirectorImpl) {
                        try {
                            ((LibertyRecoveryDirectorImpl)this._recoveryDirector).peerRecoverServers(this._recoveryAgent, this._recoveryIdentity, peersToRecover);
                        }
                        catch (RecoveryFailedException e) {
                            if (!tc.isDebugEnabled()) break block12;
                            Tr.debug((TraceComponent)tc, (String)("Swallow exception " + (Object)((Object)e)));
                        }
                    }
                }
            }
            this._alarm = this._alarmManager.scheduleAlarm((long)this._duration * 1000L, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        public void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object)this._alarm);
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancelAlarm");
            }
        }
    }
}

