/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annotations.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.annotations.internal.WebAnnotationsImpl;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.anno.service.AnnotationService_Service;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAnnotationsAdapter
implements ContainerAdapter<WebAnnotations> {
    private static final TraceComponent tc = Tr.register(WebAnnotationsAdapter.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    private final AtomicServiceReference<AnnotationService_Service> annoServiceSRRef = new AtomicServiceReference("annoService");
    static final long serialVersionUID = -6612038625029800083L;

    public void activate(ComponentContext context) {
        this.annoServiceSRRef.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.annoServiceSRRef.deactivate(context);
    }

    protected void setAnnoService(ServiceReference<AnnotationService_Service> ref) {
        this.annoServiceSRRef.setReference(ref);
    }

    protected void unsetAnnoService(ServiceReference<AnnotationService_Service> ref) {
        this.annoServiceSRRef.unsetReference(ref);
    }

    public WebAnnotations adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        AnnotationService_Service annotationService = (AnnotationService_Service)this.annoServiceSRRef.getService();
        if (annotationService == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"annotation.service.not.available.CWWKM0463E", (Object[])new Object[]{"Annotation service not available", containerToAdapt});
            throw new UnableToAdaptException(msg);
        }
        Object webModuleInfo = rootOverlay.getFromNonPersistentCache(artifactContainer.getPath(), WebModuleInfo.class);
        if (webModuleInfo == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"container.is.not.a.web.module.CWWKM0464E", (Object[])new Object[]{"Container is not a web module", containerToAdapt});
            throw new UnableToAdaptException(msg);
        }
        return new WebAnnotationsImpl(root, rootOverlay, artifactContainer, containerToAdapt, annotationService);
    }
}

