/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.util.HelperConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CommonCfg {
    private static TraceComponent tc = Tr.register(CommonCfg.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    public static final String TYPE_KEY = "config.referenceType";
    public static final String KEY_STATEFUL = "stateful";
    public static final String KEY_LAYERS = "layers";
    public static final String KEY_LAYER_AUTHENTICATION = "authenticationLayer";
    public static final String KEY_LAYER_ATTRIBUTE = "attributeLayer";
    public static final String KEY_LAYER_TRANSPORT = "transportLayer";
    public static final String KEY_SSL_REF = "sslRef";
    public static final String KEY_SSL_ENABLED = "sslEnabled";
    public static final String KEY_ESTABLISH_TRUST_IN_CLIENT = "establishTrustInClient";
    public static final String KEY_IDENTITY_ASSERTION_ENABLED = "identityAssertionEnabled";
    public static final String KEY_IDENTITY_ASSERTION_TYPES = "identityAssertionTypes";
    public static final String OPTION_SUPPORTED = "Supported";
    public static final String OPTION_REQUIRED = "Required";
    public static final String OPTION_NEVER = "Never";
    public static final String AUTHENTICATION_MECHANISM_GSSUP = "GSSUP";
    public static final String AUTHENTICATION_MECHANISM_LTPA = "LTPA";
    protected final String defaultAlias;
    static final long serialVersionUID = 8540391786767863217L;

    public CommonCfg(String defaultAlias) {
        this.defaultAlias = defaultAlias;
    }

    protected Set<String> extractSslRefs(Map<String, Object> properties, String keyPolicy, String policyType) {
        HashSet<String> sslRefs = new HashSet<String>();
        PolicyData policyData = this.extractPolicyData(properties, keyPolicy, policyType);
        if (policyData != null) {
            for (LayersData layers : policyData.layersData) {
                if (layers.transportLayer == null) {
                    sslRefs.add(this.defaultAlias);
                    continue;
                }
                if (Boolean.FALSE.equals(layers.transportLayer.get(KEY_SSL_ENABLED))) continue;
                if (layers.transportLayer.get(KEY_SSL_REF) != null) {
                    sslRefs.add((String)layers.transportLayer.get(KEY_SSL_REF));
                    continue;
                }
                sslRefs.add(this.defaultAlias);
            }
        }
        return sslRefs;
    }

    protected PolicyData extractPolicyData(Map<String, Object> properties, String keyPolicy, String policyType) {
        List<Map<String, Object>> compoundSecurityMechLists = Nester.nest(keyPolicy, properties);
        Map<String, Object> compoundSecurityMechList = null;
        Map<String, Object> configFromDefaultInstances = null;
        for (Map<String, Object> tempCompoundSecurityMechList : compoundSecurityMechLists) {
            if (!policyType.equals(tempCompoundSecurityMechList.get(TYPE_KEY))) continue;
            if (configFromDefaultInstances == null) {
                configFromDefaultInstances = tempCompoundSecurityMechList;
            }
            compoundSecurityMechList = tempCompoundSecurityMechList;
        }
        if (compoundSecurityMechList == null) {
            return null;
        }
        boolean stateful = (Boolean)compoundSecurityMechList.get(KEY_STATEFUL);
        List<LayersData> layersList = this.gatherLayersWithDefaultsIfNeeded(compoundSecurityMechList, configFromDefaultInstances);
        return new PolicyData(stateful, layersList);
    }

    protected List<LayersData> gatherLayersWithDefaultsIfNeeded(Map<String, Object> compoundSecurityMechList, Map<String, Object> configFromDefaultInstances) {
        ArrayList<LayersData> layersList = new ArrayList<LayersData>();
        List<Map<String, Object>> mechs = Nester.nest(KEY_LAYERS, configFromDefaultInstances);
        LayersData layersFromDefaultInstancesXML = this.getLayers(this.first(mechs));
        if (compoundSecurityMechList != configFromDefaultInstances) {
            mechs = Nester.nest(KEY_LAYERS, compoundSecurityMechList);
            for (Map<String, Object> mech : mechs) {
                LayersData layersFromServerXML = this.getLayers(mech);
                LayersData merged = this.mergeLayers(layersFromDefaultInstancesXML, layersFromServerXML);
                layersList.add(merged);
            }
        }
        if (layersList.isEmpty()) {
            layersList.add(layersFromDefaultInstancesXML);
        }
        return layersList;
    }

    private LayersData mergeLayers(LayersData result, LayersData toMerge) {
        if (toMerge.attributeLayer != null) {
            result.attributeLayer = toMerge.attributeLayer;
        }
        if (toMerge.authenticationLayer != null) {
            result.authenticationLayer = toMerge.authenticationLayer;
        }
        if (toMerge.transportLayer != null) {
            result.transportLayer = toMerge.transportLayer;
        }
        return result;
    }

    private LayersData getLayers(Map<String, Object> config) {
        Map<String, List<Map<String, Object>>> layers = Nester.nest(config, KEY_LAYER_TRANSPORT, KEY_LAYER_AUTHENTICATION, KEY_LAYER_ATTRIBUTE);
        return new LayersData(this.first(layers.get(KEY_LAYER_ATTRIBUTE)), this.first(layers.get(KEY_LAYER_AUTHENTICATION)), this.first(layers.get(KEY_LAYER_TRANSPORT)));
    }

    private Map<String, Object> first(List<Map<String, Object>> list) {
        return list.isEmpty() ? null : list.get(0);
    }

    public List<String> getAsMechanisms(Map<String, Object> authenticationLayerProperties) {
        ArrayList<String> mechs = new ArrayList<String>();
        String[] mechanisms = (String[])authenticationLayerProperties.get("mechanisms");
        if (mechanisms != null) {
            for (String mech : mechanisms) {
                if (mech == null || mech.length() <= 1) continue;
                mechs.add(mech);
            }
        }
        return mechs;
    }

    public static void preProcessAssociationOptions(List<HelperConstants.AssociationOptions> supported, List<HelperConstants.AssociationOptions> required, String value, HelperConstants.AssociationOptions option) {
        if (OPTION_SUPPORTED.equals(value)) {
            supported.add(option);
        } else if (OPTION_REQUIRED.equals(value)) {
            required.add(option);
        }
    }

    public static short extractAssociationOptions(List<HelperConstants.AssociationOptions> options) {
        short result = 0;
        for (HelperConstants.AssociationOptions option : options) {
            switch (option) {
                case NoProtection: {
                    result = (short)(result | 1);
                    break;
                }
                case Integrity: {
                    result = (short)(result | 2);
                    break;
                }
                case Confidentiality: {
                    result = (short)(result | 4);
                    break;
                }
                case DetectReplay: {
                    result = (short)(result | 8);
                    break;
                }
                case DetectMisordering: {
                    result = (short)(result | 0x10);
                    break;
                }
                case EstablishTrustInTarget: {
                    result = (short)(result | 0x20);
                    break;
                }
                case EstablishTrustInClient: {
                    result = (short)(result | 0x40);
                    break;
                }
                case NoDelegation: {
                    result = (short)(result | 0x80);
                    break;
                }
                case SimpleDelegation: {
                    result = (short)(result | 0x100);
                    break;
                }
                case CompositeDelegation: {
                    result = (short)(result | 0x200);
                    break;
                }
            }
        }
        return result;
    }

    @Trivial
    public static void printTrace(String key, Object value, int tabLevel) {
        if (tc.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (int count = 0; count < tabLevel; ++count) {
                msg.append("\t");
            }
            if (value != null) {
                msg.append(key);
                msg.append(":");
                msg.append(value);
            } else {
                msg.append(key);
            }
            Tr.debug((TraceComponent)tc, (String)msg.toString(), (Object[])new Object[0]);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class PolicyData {
        public boolean stateful;
        public List<LayersData> layersData;
        static final long serialVersionUID = -4405679779430770554L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public PolicyData(boolean stateful, List<LayersData> layersData) {
            this.stateful = stateful;
            this.layersData = layersData;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PolicyData.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class LayersData {
        public Map<String, Object> attributeLayer;
        public Map<String, Object> authenticationLayer;
        public Map<String, Object> transportLayer;
        static final long serialVersionUID = 8481381081089629176L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LayersData(Map<String, Object> attributeLayer, Map<String, Object> authenticationLayer, Map<String, Object> transportLayer) {
            this.attributeLayer = attributeLayer;
            this.authenticationLayer = authenticationLayer;
            this.transportLayer = transportLayer;
        }

        public LayersData() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LayersData.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
        }
    }
}

