/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DERGeneralizedTime
extends DERObject {
    String time;
    static final long serialVersionUID = -7365120872707959583L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static DERGeneralizedTime getInstance(Object obj) {
        if (obj == null || obj instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERGeneralizedTime.getInstance(obj.getObject());
    }

    public DERGeneralizedTime(String time) {
        this.time = time;
    }

    public DERGeneralizedTime(Date time) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = dateF.format(time);
    }

    DERGeneralizedTime(byte[] bytes) {
        char[] dateC = new char[bytes.length];
        for (int i = 0; i != dateC.length; ++i) {
            dateC[i] = (char)(bytes[i] & 0xFF);
        }
        this.time = new String(dateC);
    }

    public String getTime() {
        if (this.time.charAt(this.time.length() - 1) == 'Z') {
            return this.time.substring(0, this.time.length() - 1) + "GMT+00:00";
        }
        int signPos = this.time.length() - 5;
        char sign = this.time.charAt(signPos);
        if (sign == '-' || sign == '+') {
            return this.time.substring(0, signPos) + "GMT" + this.time.substring(signPos, signPos + 3) + ":" + this.time.substring(signPos + 3);
        }
        signPos = this.time.length() - 3;
        sign = this.time.charAt(signPos);
        if (sign == '-' || sign == '+') {
            return this.time.substring(0, signPos) + "GMT" + this.time.substring(signPos) + ":00";
        }
        return this.time;
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat dateF = this.time.indexOf(46) == 14 ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        return dateF.parse(this.time);
    }

    private byte[] getOctets() {
        char[] cs = this.time.toCharArray();
        byte[] bs = new byte[cs.length];
        for (int i = 0; i != cs.length; ++i) {
            bs[i] = (byte)cs[i];
        }
        return bs;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(24, this.getOctets());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.time.equals(((DERGeneralizedTime)o).time);
    }

    @Override
    public int hashCode() {
        return this.time.hashCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DERGeneralizedTime.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

