/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Choice;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERBMPString;
import com.ibm.ws.transport.iiop.asn1.DERIA5String;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DERString;
import com.ibm.ws.transport.iiop.asn1.DERUTF8String;
import com.ibm.ws.transport.iiop.asn1.DERVisibleString;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DisplayText
extends ASN1Encodable
implements ASN1Choice {
    public static final int CONTENT_TYPE_IA5STRING = 0;
    public static final int CONTENT_TYPE_BMPSTRING = 1;
    public static final int CONTENT_TYPE_UTF8STRING = 2;
    public static final int CONTENT_TYPE_VISIBLESTRING = 3;
    public static final int DISPLAY_TEXT_MAXIMUM_SIZE = 200;
    int contentType;
    DERString contents;
    static final long serialVersionUID = 6283993150972269126L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DisplayText(int type, String text) {
        if (text.length() > 200) {
            text = text.substring(0, 200);
        }
        this.contentType = type;
        switch (type) {
            case 0: {
                this.contents = new DERIA5String(text);
                break;
            }
            case 2: {
                this.contents = new DERUTF8String(text);
                break;
            }
            case 3: {
                this.contents = new DERVisibleString(text);
                break;
            }
            case 1: {
                this.contents = new DERBMPString(text);
                break;
            }
            default: {
                this.contents = new DERUTF8String(text);
            }
        }
    }

    private boolean canBeUTF8(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public DisplayText(String text) {
        if (text.length() > 200) {
            text = text.substring(0, 200);
        }
        if (this.canBeUTF8(text)) {
            this.contentType = 2;
            this.contents = new DERUTF8String(text);
        } else {
            this.contentType = 1;
            this.contents = new DERBMPString(text);
        }
    }

    public DisplayText(DERString de) {
        this.contents = de;
    }

    public static DisplayText getInstance(Object de) {
        if (de instanceof DERString) {
            return new DisplayText((DERString)de);
        }
        if (de instanceof DisplayText) {
            return (DisplayText)de;
        }
        throw new IllegalArgumentException("illegal object in getInstance");
    }

    public static DisplayText getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DisplayText.getInstance(obj.getObject());
    }

    @Override
    public DERObject toASN1Object() {
        return (DERObject)((Object)this.contents);
    }

    public String getString() {
        return this.contents.getString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DisplayText.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

