/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERBoolean;
import com.ibm.ws.transport.iiop.asn1.DERObject;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IssuingDistributionPoint
extends ASN1Encodable {
    private boolean onlyContainsUserCerts;
    private boolean onlyContainsCACerts;
    private boolean indirectCRL;
    private boolean onlyContainsAttributeCerts;
    private ASN1Sequence seq;
    static final long serialVersionUID = -4345551736150516631L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static IssuingDistributionPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return IssuingDistributionPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static IssuingDistributionPoint getInstance(Object obj) {
        if (obj == null || obj instanceof IssuingDistributionPoint) {
            return (IssuingDistributionPoint)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new IssuingDistributionPoint((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public IssuingDistributionPoint(ASN1Sequence seq) {
        this.seq = seq;
        block8: for (int i = 0; i != seq.size(); ++i) {
            ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (o.getTagNo()) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    this.onlyContainsUserCerts = DERBoolean.getInstance(o, false).isTrue();
                    continue block8;
                }
                case 2: {
                    this.onlyContainsCACerts = DERBoolean.getInstance(o, false).isTrue();
                    continue block8;
                }
                case 3: {
                    continue block8;
                }
                case 4: {
                    this.indirectCRL = DERBoolean.getInstance(o, false).isTrue();
                    continue block8;
                }
                case 5: {
                    this.onlyContainsAttributeCerts = DERBoolean.getInstance(o, false).isTrue();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in IssuingDistributionPoint");
                }
            }
        }
    }

    public boolean onlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public boolean onlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public boolean isIndirectCRL() {
        return this.indirectCRL;
    }

    public boolean onlyContainsAttributeCerts() {
        return this.onlyContainsAttributeCerts;
    }

    @Override
    public DERObject toASN1Object() {
        return this.seq;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IssuingDistributionPoint.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

