/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidEvidenceException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.util.Util;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.IOP.Codec;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TSSITTPrincipalNameGSSUP
extends TSSSASIdentityToken {
    public static final String OID;
    private final String realmName;
    private final String domainName;
    private final transient Authenticator authenticator;
    static final long serialVersionUID = 5788574301719349895L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSITTPrincipalNameGSSUP(Class principalClass, String realmName, String domainName) throws NoSuchMethodException {
        this.realmName = realmName;
        this.domainName = domainName;
        this.authenticator = null;
    }

    public TSSITTPrincipalNameGSSUP(Authenticator authenticator, String realmName) {
        this.authenticator = authenticator;
        this.realmName = realmName;
        this.domainName = realmName;
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    @FFDCIgnore(value={AuthenticationException.class})
    public Subject check(IdentityToken identityToken, Codec codec) throws SASException {
        Subject identityAssertionSubject = null;
        try {
            String principalName = this.getPrincipalName(identityToken, codec);
            identityAssertionSubject = this.authenticator.authenticate(principalName);
        }
        catch (AuthenticationException e) {
            throw new SASInvalidEvidenceException(e.getMessage(), 1229079296);
        }
        return identityAssertionSubject;
    }

    /*
     * WARNING - void declaration
     */
    private String getPrincipalName(IdentityToken identityToken, Codec codec) throws SASException {
        byte[] principalNameToken = identityToken.principal_name();
        Any any = null;
        try {
            any = codec.decode_value(principalNameToken, GSS_NT_ExportedNameHelper.type());
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transport.iiop.security.config.tss.TSSITTPrincipalNameGSSUP", (String)"89", (Object)this, (Object[])new Object[]{identityToken, codec});
            throw new SASException(1, (Throwable)e);
        }
        byte[] principalNameBytes = GSS_NT_ExportedNameHelper.extract((Any)any);
        String principalName = Util.decodeGSSExportedName(principalNameBytes).getName();
        principalName = Util.extractUserNameFromScopedName(principalName);
        return principalName;
    }

    @Override
    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSITTPrincipalNameGSSUP: [\n");
        buf.append(moreSpaces).append("domain: ").append(this.domainName).append("\n");
        buf.append(moreSpaces).append("realm: ").append(this.realmName).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSITTPrincipalNameGSSUP.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
        OID = "oid:2.23.130.1.1.1".substring(4);
    }
}

