/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.ContentLengthHeader;

public class ContentLengthHeaderImpl
extends HeaderImpl
implements ContentLengthHeader {
    private static final long serialVersionUID = 3391206701910414069L;
    private int m_length = 0;
    private final boolean m_compactForm;

    public ContentLengthHeaderImpl() {
        this(false);
    }

    public ContentLengthHeaderImpl(boolean compactForm) {
        this.m_compactForm = compactForm;
    }

    @Override
    public void setContentLength(int contentlength) throws SipParseException {
        this.m_length = contentlength;
    }

    @Override
    public int getContentLength() {
        return this.m_length;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.m_length = parser.number();
    }

    @Override
    protected void encodeValue(CharsBuffer buf) {
        buf.append(this.m_length);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof ContentLengthHeaderImpl)) {
            return false;
        }
        ContentLengthHeaderImpl o = (ContentLengthHeaderImpl)other;
        return this.m_length == o.m_length;
    }

    @Override
    public String getName() {
        return "Content-Length";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public String getName(boolean isUseCompactHeaders) {
        if (isUseCompactHeaders) {
            return String.valueOf('l');
        }
        return this.getName();
    }

    @Override
    public boolean isCompactFormSupported() {
        return true;
    }

    @Override
    public boolean isCompactForm() {
        return this.m_compactForm;
    }
}

