/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.proxy.BranchManager;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.message.Response;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;

public class StatefulProxyBestResponse {
    private static final LogMgr c_logger = Log.get(StatefulProxyBestResponse.class);
    private static final int[][] c_responsesAndTheirPreference = new int[][]{{300, 300}, {301, 303}, {302, 302}, {305, 301}, {380, 304}, {400, 410}, {401, 400}, {402, 412}, {403, 414}, {404, 416}, {405, 418}, {406, 420}, {407, 401}, {408, 422}, {409, 424}, {410, 426}, {411, 428}, {413, 430}, {414, 432}, {415, 402}, {420, 403}, {421, 434}, {480, 436}, {481, 438}, {482, 440}, {483, 442}, {484, 404}, {485, 444}, {486, 446}, {487, 448}, {488, 450}, {500, 501}, {501, 503}, {502, 502}, {503, 506}, {504, 504}, {505, 505}};
    private static Map c_responseMap = new HashMap(75);
    private SipServletResponse m_bestResponse = null;
    private ProxyBranchImpl _proxyBranch = null;
    private int m_bestResponsePreference = 1000;

    public SipServletResponse getBestResponse() {
        return this.m_bestResponse;
    }

    public ProxyBranchImpl getProxyBranch() {
        return this._proxyBranch;
    }

    public int getNewPreference(int errorCode) {
        int newPrefernce = -1;
        if (errorCode >= 200) {
            newPrefernce = StatefulProxyBestResponse.getPreference(errorCode);
            if (this.m_bestResponse != null && this.m_bestResponsePreference <= newPrefernce) {
                newPrefernce = -1;
            }
        }
        return newPrefernce;
    }

    public void updateBestResponse(SipServletResponse response, ProxyBranchImpl branch) {
        int newPrefernce;
        if (c_logger.isTraceDebugEnabled()) {
            int current = -1;
            if (this.m_bestResponse != null) {
                current = this.m_bestResponse.getStatus();
            }
            c_logger.traceDebug(this, "updateBestResponse", "Current: " + current + (this.m_bestResponse == null ? "" : ", TU=" + ((SipServletResponseImpl)this.m_bestResponse).getTransactionUser()));
        }
        boolean needToAggregateAuthHeaders = false;
        if (this.m_bestResponse != null && ((this.m_bestResponse.getStatus() == 401 || this.m_bestResponse.getStatus() == 407) && response.getStatus() == 401 || response.getStatus() == 407)) {
            needToAggregateAuthHeaders = true;
        }
        if ((newPrefernce = this.getNewPreference(response.getStatus())) != -1) {
            TransactionUserWrapper tuw;
            if (needToAggregateAuthHeaders) {
                this.aggregateAuthHeaders(this.m_bestResponse, response);
            }
            if (this.m_bestResponse != null && (tuw = ((SipServletResponseImpl)this.m_bestResponse).getTransactionUser()) != null && SipUtil.isErrorResponse(this.m_bestResponse.getStatus())) {
                tuw.setSessionState(SipSession.State.TERMINATED, this.m_bestResponse.getRequest());
                TransactionUserWrapper origTU = ((SipServletRequestImpl)this._proxyBranch.getProxy().getOriginalRequest()).getTransactionUser();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "updateBestResponse", "origRequestTU: " + origTU + ", previous best=" + tuw);
                }
                if (!origTU.equals(tuw)) {
                    tuw.transactionCompleted();
                    tuw.invalidateIfReady();
                }
            }
            this.m_bestResponse = response;
            this._proxyBranch = branch;
            this.m_bestResponsePreference = newPrefernce;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateBestResponse", "Updated To: " + this.m_bestResponse.getStatus());
            }
        } else {
            if (needToAggregateAuthHeaders) {
                this.aggregateAuthHeaders(response, this.m_bestResponse);
            }
            TransactionUserWrapper tuw = ((SipServletResponseImpl)response).getTransactionUser();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateBestResponse", "invalidating tu for branch who is not the best response, tu=" + tuw);
            }
            if (tuw != null && SipUtil.isErrorResponse(response.getStatus())) {
                tuw.setSessionState(SipSession.State.TERMINATED, response);
                tuw.transactionCompleted();
                tuw.invalidateIfReady();
            }
        }
    }

    private void aggregateAuthHeaders(SipServletResponse source, SipServletResponse target) {
        Response src = ((SipServletResponseImpl)source).getResponse();
        Response trg = ((SipServletResponseImpl)target).getResponse();
        try {
            HeaderIterator iter = src.getHeaders("WWW-Authenticate");
            while (null != iter && iter.hasNext()) {
                trg.addHeader(iter.next(), false);
            }
            iter = src.getHeaders("Proxy-Authenticate");
            while (null != iter && iter.hasNext()) {
                trg.addHeader(iter.next(), false);
            }
        }
        catch (SipParseException e2) {
            BranchManager.logException(e2);
        }
    }

    private static int getPreference(int responseValue) {
        Integer preference = (Integer)c_responseMap.get(new Integer(responseValue));
        if (null == preference) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug((Object)null, "getPreference", "Response value not exist, value is " + responseValue);
            }
            int i = responseValue / 100;
            preference = new Integer(i * 100 + 99);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "getPreference", "Returned: " + preference);
        }
        return preference;
    }

    static {
        int size = c_responsesAndTheirPreference.length;
        for (int i = 0; i < size; ++i) {
            c_responseMap.put(new Integer(c_responsesAndTheirPreference[i][0]), new Integer(c_responsesAndTheirPreference[i][1]));
        }
    }
}

