/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.chfw;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.sip.stack.transport.chfw.GenericChain;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.Map;

public class ActiveConfiguration {
    boolean isTls = false;
    final int configPort;
    final String configHost;
    Map<String, Object> tcpOptions = null;
    Map<String, Object> sslOptions = null;
    Map<String, Object> udpOptions = null;
    final Map<String, Object> endpointOptions;
    private GenericChain _chain = null;
    volatile int activePort = -1;
    String activeHost = null;
    boolean validConfiguration = false;

    ActiveConfiguration(boolean isTls, Map<String, Object> tcp, Map<String, Object> ssl, Map<String, Object> endpoint, GenericChain chain) {
        this.isTls = isTls;
        this.tcpOptions = tcp;
        this.sslOptions = ssl;
        this.endpointOptions = endpoint;
        this._chain = chain;
        String attribute = isTls ? "sipTLSPort" : "sipTCPPort";
        this.configPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)attribute, (Object)this.endpointOptions.get(attribute), (int)-1);
        this.configHost = (String)this.endpointOptions.get("host");
    }

    ActiveConfiguration(Map<String, Object> udp, Map<String, Object> endpoint, GenericChain chain) {
        this.udpOptions = udp;
        this.endpointOptions = endpoint;
        this._chain = chain;
        String attribute = "sipUDPPort";
        this.configPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)attribute, (Object)this.endpointOptions.get(attribute), (int)-1);
        this.configHost = (String)this.endpointOptions.get("host");
    }

    public int getActivePort() {
        if (this.configPort < 0) {
            return -1;
        }
        if (this.activePort == -1) {
            try {
                this.activePort = this._chain.getCfw().getListeningPort(this._chain.getChainName());
            }
            catch (ChainException ce) {
                this.activePort = -1;
            }
        }
        return this.activePort;
    }

    @Trivial
    public boolean isReady() {
        if (this.tcpOptions == null && this.udpOptions == null) {
            return false;
        }
        return !this.isTls || this.sslOptions != null;
    }

    protected boolean unchanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        if (this.isTls) {
            return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions && this.sslOptions == other.sslOptions && this.udpOptions == other.udpOptions && !this.endpointChanged(other);
        }
        return this.configHost.equals(other.configHost) && this.configPort == other.configPort && this.tcpOptions == other.tcpOptions && this.udpOptions == other.udpOptions && !this.endpointChanged(other);
    }

    protected boolean tcpChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return !this.configHost.equals(other.configHost) || this.configPort != other.configPort || this.tcpOptions != other.tcpOptions;
    }

    protected boolean sslChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return this.sslOptions != other.sslOptions;
    }

    protected boolean udpChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return !this.configHost.equals(other.configHost) || this.configPort != other.configPort || this.udpOptions != other.udpOptions;
    }

    protected boolean endpointChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return !this.endpointOptions.get("service.pid").equals(other.endpointOptions.get("service.pid"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[host=" + this.configHost + ",port=" + this.configPort + ",listening=" + this.activePort + ",complete=" + this.isReady() + ",tcpOptions=" + System.identityHashCode(this.tcpOptions) + ",udpOptions=" + System.identityHashCode(this.udpOptions) + ",sslOptions=" + (this.isTls ? Integer.valueOf(System.identityHashCode(this.sslOptions)) : "0") + "]";
    }
}

