/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.security.social.tai.AuthorizationCodeAuthenticator;
import com.ibm.ws.security.social.tai.TAISubjectUtils;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import com.ibm.ws.security.social.web.utils.SocialWebUtils;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthLoginFlow {
    public static final TraceComponent tc = Tr.register(OAuthLoginFlow.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    ReferrerURLCookieHandler referrerURLCookieHandler = null;
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    SocialWebUtils webUtils = new SocialWebUtils();
    static final long serialVersionUID = 5882953905548549290L;

    public OAuthLoginFlow() {
        this.referrerURLCookieHandler = this.taiWebUtils.getCookieHandler();
    }

    TAIResult handleOAuthRequest(HttpServletRequest request, HttpServletResponse response, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        String code = this.webUtils.getAndClearCookie(request, response, "WASSocialState");
        if (code == null) {
            return this.handleRedirectToServer(request, response, clientConfig);
        }
        return this.handleAuthorizationCode(request, response, code, clientConfig);
    }

    @FFDCIgnore(value={SocialLoginException.class})
    TAIResult handleRedirectToServer(HttpServletRequest req, HttpServletResponse res, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        try {
            req.getSession(true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"59", (Object)this, (Object[])new Object[]{req, res, clientConfig});
        }
        String stateValue = this.taiWebUtils.createStateCookie(req, res);
        String redirect_url = this.taiWebUtils.getRedirectUrl(req, clientConfig);
        try {
            this.taiWebUtils.savePostParameters(req);
            String acr_values = req.getParameter("acr_values");
            String authzEndPointUrlWithQuery = this.buildAuthorizationUrlWithQuery(stateValue, clientConfig, redirect_url, acr_values);
            if (clientConfig.isClientSideRedirectSupported()) {
                this.webUtils.doClientSideRedirect(res, "WASReqUrlSocial_" + stateValue.hashCode(), authzEndPointUrlWithQuery);
                return TAIResult.create((int)403);
            }
            String cookieName = "WASReqUrlSocial_" + stateValue.hashCode();
            Cookie c = this.referrerURLCookieHandler.createCookie(cookieName, this.webUtils.getRequestUrlWithEncodedQueryString(req), req);
            res.addCookie(c);
            res.sendRedirect(authzEndPointUrlWithQuery);
            return TAIResult.create((int)403);
        }
        catch (SocialLoginException e) {
            Tr.error((TraceComponent)tc, (String)"FAILED_TO_REDIRECT_TO_AUTHZ_ENDPOINT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"84", (Object)this, (Object[])new Object[]{req, res, clientConfig});
            Tr.error((TraceComponent)tc, (String)"FAILED_TO_REDIRECT_TO_AUTHZ_ENDPOINT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        return this.taiWebUtils.sendToErrorPage(res, TAIResult.create((int)403));
    }

    /*
     * WARNING - void declaration
     */
    String buildAuthorizationUrlWithQuery(String state, SocialLoginConfig clientConfig, String redirectUrl, String acr_values) throws SocialLoginException {
        String scope;
        if (state == null) {
            throw new SocialLoginException("STATE_IS_NULL", null, new Object[]{clientConfig.getUniqueId()});
        }
        if (redirectUrl == null) {
            throw new SocialLoginException("REDIRECT_URL_IS_NULL", null, new Object[]{clientConfig.getUniqueId()});
        }
        String authzEndpoint = this.taiWebUtils.getAuthorizationEndpoint(clientConfig);
        String strResponse_type = clientConfig.getResponseType();
        String clientId = clientConfig.getClientId();
        if (clientId == null) {
            Tr.warning((TraceComponent)tc, (String)"OUTGOING_REQUEST_MISSING_PARAMETER", (Object[])new Object[]{authzEndpoint, "client_id"});
            clientId = "";
        }
        if ((scope = clientConfig.getScope()) == null) {
            scope = "";
        }
        String query = "";
        try {
            String resources;
            query = String.format("response_type=%s&client_id=%s&state=%s&redirect_uri=%s&scope=%s", URLEncoder.encode(strResponse_type, "UTF-8"), URLEncoder.encode(clientId, "UTF-8"), URLEncoder.encode(state, "UTF-8"), URLEncoder.encode(redirectUrl, "UTF-8"), URLEncoder.encode(scope, "UTF-8"));
            if (clientConfig.createNonce()) {
                String nonceValue = SocialUtil.generateRandom();
                query = String.format("%s&nonce=%s", query, URLEncoder.encode(nonceValue, "UTF-8"));
            }
            if (acr_values != null && !acr_values.isEmpty()) {
                query = String.format("%s&acr_values=%s", query, URLEncoder.encode(acr_values, "UTF-8"));
            }
            query = this.addResponseModeToQuery(query, clientConfig);
            if (!strResponse_type.equals("code") && (resources = clientConfig.getResource()) != null) {
                query = String.format("%s&%s", query, URLEncoder.encode(resources, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException resources) {
            void e;
            FFDCFilter.processException((Throwable)resources, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"136", (Object)this, (Object[])new Object[]{state, clientConfig, redirectUrl, acr_values});
            throw new SocialLoginException((Exception)e);
        }
        String s = authzEndpoint + "?" + query;
        return s;
    }

    String addResponseModeToQuery(String query, SocialLoginConfig config) throws UnsupportedEncodingException {
        String responseMode = config.getResponseMode();
        String responseType = config.getResponseType();
        if (!responseType.equals("code")) {
            responseMode = "form_post";
        }
        if (responseMode != null) {
            query = String.format("%s&response_mode=%s", query, URLEncoder.encode(responseMode, "UTF-8"));
        }
        return query;
    }

    /*
     * WARNING - void declaration
     */
    TAIResult handleAuthorizationCode(HttpServletRequest req, HttpServletResponse res, String authzCode, SocialLoginConfig clientConfig) throws WebTrustAssociationFailedException {
        AuthorizationCodeAuthenticator authzCodeAuthenticator = this.getAuthorizationCodeAuthenticator(req, res, authzCode, clientConfig);
        try {
            authzCodeAuthenticator.generateJwtAndTokenInformation();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"161", (Object)this, (Object[])new Object[]{req, res, authzCode, clientConfig});
            return this.taiWebUtils.sendToErrorPage(res, TAIResult.create((int)401));
        }
        TAIResult authnResult = null;
        try {
            TAISubjectUtils subjectUtils = this.getTAISubjectUtils(authzCodeAuthenticator);
            authnResult = subjectUtils.createResult(res, clientConfig);
        }
        catch (Exception subjectUtils) {
            void e;
            FFDCFilter.processException((Throwable)subjectUtils, (String)"com.ibm.ws.security.social.tai.OAuthLoginFlow", (String)"169", (Object)this, (Object[])new Object[]{req, res, authzCode, clientConfig});
            Tr.error((TraceComponent)tc, (String)"AUTH_CODE_ERROR_CREATING_RESULT", (Object[])new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
            return this.taiWebUtils.sendToErrorPage(res, TAIResult.create((int)401));
        }
        this.taiWebUtils.restorePostParameters(req);
        return authnResult;
    }

    AuthorizationCodeAuthenticator getAuthorizationCodeAuthenticator(HttpServletRequest req, HttpServletResponse res, String authzCode, SocialLoginConfig clientConfig) {
        return new AuthorizationCodeAuthenticator(req, res, authzCode, clientConfig);
    }

    TAISubjectUtils getTAISubjectUtils(AuthorizationCodeAuthenticator authzCodeAuthenticator) {
        return new TAISubjectUtils(authzCodeAuthenticator);
    }
}

