/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.error.ErrorHandlerImpl;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.web.EndpointServices;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointServlet
extends HttpServlet {
    private static TraceComponent tc = Tr.register(EndpointServlet.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private transient EndpointServices endpointServices = null;
    private transient ServletContext servletContext = null;
    private transient BundleContext bundleContext = null;
    private transient ServiceReference<EndpointServices> endpointServicesRef = null;
    private transient ReferrerURLCookieHandler referrerURLCookieHandler = null;
    private static final long serialVersionUID = 1L;

    public void init() {
        this.servletContext = this.getServletContext();
        this.bundleContext = (BundleContext)this.servletContext.getAttribute("osgi-bundlecontext");
        this.endpointServicesRef = this.bundleContext.getServiceReference(EndpointServices.class);
        this.referrerURLCookieHandler = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
        EndpointServices.setReferrerURLCookieHandler(this.referrerURLCookieHandler);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("init:" + this.servletContext + "   " + this.bundleContext + "  " + this.endpointServicesRef), (Object[])new Object[0]);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    @FFDCIgnore(value={SocialLoginException.class})
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            EndpointServices socialLoginEndpointServices = this.getSocialLoginEndpointServices();
            socialLoginEndpointServices.handleSocialLoginRequest(request, response);
        }
        catch (SocialLoginException e) {
            e.logErrorMessage();
            ErrorHandlerImpl.getInstance().handleErrorResponse(response, 403);
        }
    }

    private EndpointServices getSocialLoginEndpointServices() throws ServletException {
        if (this.endpointServicesRef != null) {
            this.endpointServices = (EndpointServices)this.bundleContext.getService(this.endpointServicesRef);
            if (this.endpointServices == null) {
                this.init();
                this.endpointServices = (EndpointServices)this.bundleContext.getService(this.endpointServicesRef);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSocialLoginEndpointServices:" + this.servletContext + "   " + this.bundleContext + " " + this.endpointServices), (Object[])new Object[0]);
        }
        if (this.endpointServices == null) {
            throw new ServletException(TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.social.resources.SocialMessages", (String)"SOCIAL_LOGIN_OSGI_ENDPOINT_SERVICE_ERROR", null, (String)"CWWKS5408E: A Social Login request cannot be processed because there is no Social Login feature available."));
        }
        return this.endpointServices;
    }
}

