/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.client.ApplicationClientType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ApplicationClientDDParser
extends DDParser {
    private final int maxVersion;
    private static final String APPCLIENT_DTD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
    private static final String APPCLIENT_DTD_PUBLIC_ID_13 = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    static final long serialVersionUID = -4765150802064045996L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ApplicationClientDDParser(Container ddRootContainer, Entry ddEntry, int maxVersion) throws DDParser.ParseException {
        super(ddRootContainer, ddEntry);
        this.maxVersion = maxVersion;
    }

    ApplicationClient parse() throws DDParser.ParseException {
        super.parseRootElement();
        return (ApplicationClient)this.rootParsable;
    }

    @Override
    protected DDParser.ParsableElement createRootParsable() throws DDParser.ParseException {
        if (!"application-client".equals(this.rootElementLocalName)) {
            throw new DDParser.ParseException(this.invalidRootElement());
        }
        String vers = this.getAttributeValue("", "version");
        if (vers == null) {
            if (this.namespace == null && this.dtdPublicId != null) {
                if (APPCLIENT_DTD_PUBLIC_ID_12.equals(this.dtdPublicId)) {
                    this.version = 12;
                    this.eePlatformVersion = 12;
                    return new ApplicationClientType(this.getDeploymentDescriptorPath());
                }
                if (APPCLIENT_DTD_PUBLIC_ID_13.equals(this.dtdPublicId)) {
                    this.version = 13;
                    this.eePlatformVersion = 13;
                    return new ApplicationClientType(this.getDeploymentDescriptorPath());
                }
            }
            throw new DDParser.ParseException(this.unknownDeploymentDescriptorVersion());
        }
        if ("1.4".equals(vers)) {
            if ("http://java.sun.com/xml/ns/j2ee".equals(this.namespace)) {
                this.version = 14;
                this.eePlatformVersion = 14;
                return new ApplicationClientType(this.getDeploymentDescriptorPath());
            }
        } else if ("5".equals(vers)) {
            if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                this.version = 50;
                this.eePlatformVersion = 50;
                return new ApplicationClientType(this.getDeploymentDescriptorPath());
            }
        } else if ("6".equals(vers)) {
            if ("http://java.sun.com/xml/ns/javaee".equals(this.namespace)) {
                this.version = 60;
                this.eePlatformVersion = 60;
                return new ApplicationClientType(this.getDeploymentDescriptorPath());
            }
        } else if ("7".equals(vers)) {
            if (this.maxVersion >= 70 && "http://xmlns.jcp.org/xml/ns/javaee".equals(this.namespace)) {
                this.version = 70;
                this.eePlatformVersion = 70;
                return new ApplicationClientType(this.getDeploymentDescriptorPath());
            }
        } else if ("8".equals(vers) && this.maxVersion >= 80 && "http://xmlns.jcp.org/xml/ns/javaee".equals(this.namespace)) {
            this.version = 80;
            this.eePlatformVersion = 80;
            return new ApplicationClientType(this.getDeploymentDescriptorPath());
        }
        throw new DDParser.ParseException(this.invalidDeploymentDescriptorNamespace(vers));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationClientDDParser.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    }
}

