/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.wsat;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.policy.WSATAssertionBuilder;
import com.ibm.ws.wsat.policy.WSATAssertionPolicyProvider;
import com.ibm.ws.wsat.policy.WSATPolicyAwareInterceptor;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.neethi.builders.AssertionBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSATFeatureBusListener
implements LibertyApplicationBusListener {
    private static final TraceComponent tc = Tr.register(WSATFeatureBusListener.class, (String)"WSAT", null);
    private static final Set<Bus> busSet = Collections.newSetFromMap(new ConcurrentHashMap());
    static final long serialVersionUID = 3402389142642895610L;

    public static Set<Bus> getBusSet() {
        return busSet;
    }

    public void preInit(Bus bus) {
    }

    public void initComplete(Bus bus) {
        if (bus == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initComplete", (Object[])new Object[]{"bus == NULL"});
            }
            return;
        }
        LibertyApplicationBus.Type busType = (LibertyApplicationBus.Type)bus.getExtension(LibertyApplicationBus.Type.class);
        if (busType == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initComplete", (Object[])new Object[]{"Can not determine server type, not Liberty BUS?"});
            }
            return;
        }
        busSet.add(bus);
        AssertionBuilderRegistry reg = (AssertionBuilderRegistry)bus.getExtension(AssertionBuilderRegistry.class);
        if (reg != null) {
            reg.registerBuilder((AssertionBuilder)new WSATAssertionBuilder());
        }
        PolicyInterceptorProviderRegistry regIPR = (PolicyInterceptorProviderRegistry)bus.getExtension(PolicyInterceptorProviderRegistry.class);
        if (reg != null) {
            WSATAssertionPolicyProvider _policyProvider = new WSATAssertionPolicyProvider();
            regIPR.register((PolicyInterceptorProvider)_policyProvider);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initComplete", (Object[])new Object[]{"If we've got here, then the interceptors should be inserted"});
            LoggingInInterceptor in = new LoggingInInterceptor();
            in.setPrettyLogging(true);
            bus.getInInterceptors().add(in);
            LoggingOutInterceptor out = new LoggingOutInterceptor();
            out.setPrettyLogging(true);
            bus.getOutInterceptors().add(out);
        }
        bus.getInInterceptors().add(new WSATPolicyAwareInterceptor("pre-protocol", false));
        bus.getInInterceptors().add(new WSATPolicyAwareInterceptor("receive", false));
        bus.getOutInterceptors().add(new WSATPolicyAwareInterceptor("setup", true));
        bus.getOutInterceptors().add(new WSATPolicyAwareInterceptor("write", true));
    }

    public void preShutdown(Bus bus) {
    }

    public void postShutdown(Bus bus) {
        busSet.remove(bus);
    }
}

