/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.web.impl.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.interfaces.SecurityContextStore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.Principal;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.cdi.WebSecurityContextStore", immediate=true, property={"service.vendor=IBM", "service.ranking:Integer=100"})
public class WebSecurityContextStore
implements SecurityContextStore {
    private static final TraceComponent tc = Tr.register(WebSecurityContextStore.class, (String)"JCDI", (String)"com.ibm.ws.cdi.impl.resources.CDI");
    private static final AtomicReference<WebSecurityContextStore> INSTANCE = new AtomicReference();
    private final ThreadLocal<HttpServletRequest> httpServletRequests = new ThreadLocal();
    static final long serialVersionUID = 4427189467779505870L;

    public void activate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        INSTANCE.set(this);
    }

    public void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        INSTANCE.compareAndSet(this, null);
    }

    public static WebSecurityContextStore getCurrentInstance() {
        return INSTANCE.get();
    }

    public Principal getCurrentPrincipal() {
        if (this.httpServletRequests.get() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (this.httpServletRequests.get().getUserPrincipal() == null) {
                    Tr.debug((TraceComponent)tc, (String)"getCurrentPrincipal: null", (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("getCurrentPrincipal: " + this.httpServletRequests.get().getUserPrincipal().getName()), (Object[])new Object[0]);
                }
            }
            return this.httpServletRequests.get().getUserPrincipal();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCurrentPrincipal: null web context", (Object[])new Object[0]);
        }
        return null;
    }

    public void storeHttpServletRequest(HttpServletRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("storeHttpServletRequest: " + req), (Object[])new Object[0]);
        }
        this.httpServletRequests.set(req);
    }

    public void removeHttpServletRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeHttpServletRequest: " + this.httpServletRequests.get()), (Object[])new Object[0]);
        }
        this.httpServletRequests.remove();
    }
}

