/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.ConflictingCredentialsException;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidStateException;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryEventListener;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogCallBack;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl;
import com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RecoveryDirectorImpl
implements RecoveryDirector {
    private static final TraceComponent tc;
    public static final int CALLBACK_RECOVERYSTARTED = 1;
    public static final int CALLBACK_RECOVERYCOMPLETE = 2;
    public static final int CALLBACK_TERMINATIONSTARTED = 3;
    public static final int CALLBACK_TERMINATIONCOMPLETE = 4;
    public static final int CALLBACK_RECOVERYFAILED = 5;
    private static RecoveryDirectorImpl _instance;
    protected final TreeMap<Integer, ArrayList<RecoveryAgent>> _registeredRecoveryAgents;
    private final HashMap<RecoveryAgent, HashSet<FailureScope>> _outstandingInitializationRecords;
    private final HashMap<FailureScope, HashSet<RecoveryAgent>> _outstandingRecoveryRecords;
    private final HashMap<RecoveryAgent, HashSet<FailureScope>> _outstandingTerminationRecords;
    private boolean _registrationAllowed = true;
    protected FailureScope _currentFailureScope;
    private HashSet<RecoveryLogCallBack> _registeredCallbacks = new HashSet();
    private final RecoveryEventListener _eventListeners;
    private final HashSet<FailureScope> _initFailedFailureScopes;
    protected HashMap<String, RecoveryLogFactory> _customLogFactories = new HashMap();
    static final long serialVersionUID = -8389162195760902799L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    protected RecoveryDirectorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryDirectorImpl");
        }
        this._registeredRecoveryAgents = new TreeMap();
        this._outstandingInitializationRecords = new HashMap();
        this._outstandingRecoveryRecords = new HashMap();
        this._outstandingTerminationRecords = new HashMap();
        this._initFailedFailureScopes = new HashSet();
        this._eventListeners = RegisteredRecoveryEventListeners.instance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryDirectorImpl", (Object)this);
        }
    }

    public static synchronized RecoveryDirector instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instance");
        }
        if (_instance == null) {
            _instance = new RecoveryDirectorImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"instance", (Object)_instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecoveryLogManager registerService(RecoveryAgent recoveryAgent, int sequence) throws ConflictingCredentialsException, InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerService", (Object)new Object[]{recoveryAgent, new Integer(sequence), this});
        }
        RecoveryLogManagerImpl clientRLM = null;
        TreeMap<Integer, ArrayList<RecoveryAgent>> treeMap = this._registeredRecoveryAgents;
        synchronized (treeMap) {
            if (!this._registrationAllowed) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Client service registration attempted after recovery processing has been driven");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"registerService", (Object)"InvalidStateException");
                }
                throw new InvalidStateException(null);
            }
            int clientIdentifier = recoveryAgent.clientIdentifier();
            String clientName = recoveryAgent.clientName();
            Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
            for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
                for (RecoveryAgent registeredRecoveryAgent : registeredRecoveryAgentsArray) {
                    if (registeredRecoveryAgent.clientIdentifier() != clientIdentifier && !registeredRecoveryAgent.clientName().equals(clientName)) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Client service registration attempted with non-unique identity or name");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"registerService", (Object)"ConflictingCredentialsException");
                    }
                    throw new ConflictingCredentialsException(null);
                }
            }
            Integer sequenceI = new Integer(sequence);
            ArrayList<RecoveryAgent> sequenceArray = this._registeredRecoveryAgents.get(sequenceI);
            if (sequenceArray == null) {
                sequenceArray = new ArrayList();
                this._registeredRecoveryAgents.put(sequenceI, sequenceArray);
            }
            sequenceArray.add(recoveryAgent);
            clientRLM = new RecoveryLogManagerImpl(recoveryAgent, this._customLogFactories);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("New service '" + clientName + "' (" + clientIdentifier + ") registered with RecoveryDirectorImpl"));
            }
            if (clientIdentifier == 1) {
                Configuration.txRecoveryAgent(recoveryAgent);
                Configuration.setSnapshotSafe(recoveryAgent.isSnapshotSafe());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerService", (Object)clientRLM);
        }
        return clientRLM;
    }

    @Override
    public void serialRecoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serialRecoveryComplete", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeInitializationRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serialRecoveryComplete", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        this._eventListeners.clientRecoveryComplete(failureScope, recoveryAgent.clientIdentifier());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serialRecoveryComplete");
        }
    }

    @Override
    public void terminationComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminationComplete", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeTerminationRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as an outstaning termination request for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminationComplete", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminationComplete");
        }
    }

    @Override
    public synchronized FailureScope currentFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"currentFailureScope", (Object)this);
        }
        if (this._currentFailureScope == null) {
            this._currentFailureScope = new FileFailureScope();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"currentFailureScope", (Object)this._currentFailureScope);
        }
        return this._currentFailureScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @FFDCIgnore(value={RecoveryFailedException.class})
    public void directInitialization(FailureScope failureScope) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"directInitialization", (Object)new Object[]{failureScope, this});
        }
        FailureScope currentFailureScope = Configuration.localFailureScope();
        TreeMap<Integer, ArrayList<RecoveryAgent>> treeMap = this._registeredRecoveryAgents;
        // MONITORENTER : treeMap
        this._registrationAllowed = false;
        // MONITOREXIT : treeMap
        if (currentFailureScope.equals(failureScope)) {
            Tr.info((TraceComponent)tc, (String)"CWRLS0010_PERFORM_LOCAL_RECOVERY", (Object)failureScope.serverName());
        } else {
            Tr.info((TraceComponent)tc, (String)"CWRLS0011_PERFORM_PEER_RECOVERY", (Object)failureScope.serverName());
        }
        Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
        for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            for (RecoveryAgent recoveryAgent : registeredRecoveryAgentsArray) {
                recoveryAgent.prepareForRecovery(failureScope);
                this.addInitializationRecord(recoveryAgent, failureScope);
                this.addRecoveryRecord(recoveryAgent, failureScope);
            }
        }
        if (Configuration.HAEnabled()) {
            Configuration.getRecoveryLogComponent().joinCluster(failureScope);
        }
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(1, failureScope);
        }
        Iterator<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValuesIterator = registeredRecoveryAgentsValues.iterator();
        block10: while (true) {
            ArrayList<RecoveryAgent> registeredRecoveryAgentsArray;
            if (!registeredRecoveryAgentsValuesIterator.hasNext()) {
                if (currentFailureScope.equals(failureScope)) {
                    Tr.info((TraceComponent)tc, (String)"CWRLS0012_DIRECT_LOCAL_RECOVERY", (Object)failureScope.serverName());
                } else {
                    Tr.info((TraceComponent)tc, (String)"CWRLS0013_DIRECT_PEER_RECOVERY", (Object)failureScope.serverName());
                }
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"directInitialization");
                return;
            }
            registeredRecoveryAgentsArray = registeredRecoveryAgentsValuesIterator.next();
            Iterator<RecoveryAgent> registeredRecoveryAgentsArrayIterator = registeredRecoveryAgentsArray.iterator();
            while (true) {
                RecoveryAgent recoveryAgent;
                if (!registeredRecoveryAgentsArrayIterator.hasNext()) continue block10;
                recoveryAgent = registeredRecoveryAgentsArrayIterator.next();
                try {
                    RecoveryLog customRecLog;
                    this._eventListeners.clientRecoveryInitiated(failureScope, recoveryAgent.clientIdentifier());
                    boolean shouldBeRecovered = true;
                    boolean enableHADBPeerLocking = recoveryAgent.enableHADBPeerLocking();
                    if (enableHADBPeerLocking && (customRecLog = recoveryAgent.getCustomPartnerLog(failureScope)) != null) {
                        if (currentFailureScope.equals(failureScope)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"LOCAL RECOVERY, claim local logs");
                            }
                            shouldBeRecovered = recoveryAgent.claimLocalHADBLogs(customRecLog);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"LOCAL RECOVERY, so start heartbeat");
                            }
                            if (!shouldBeRecovered) {
                                RecoveryFailedException rfex = new RecoveryFailedException(new Exception("HADB Peer locking, local recovery failed"));
                                throw rfex;
                            }
                            recoveryAgent.startHADBLogAvailabilityHeartbeat(customRecLog);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"PEER RECOVERY, take lock, ie check staleness");
                            }
                            if (!(shouldBeRecovered = recoveryAgent.claimPeerHADBLogs(customRecLog))) {
                                RecoveryFailedException rfex = new RecoveryFailedException(new Exception("HADB Peer locking, peer recovery failed"));
                                throw rfex;
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("now initiateRecovery if shouldBeRecovered - " + shouldBeRecovered));
                    }
                    if (shouldBeRecovered) {
                        recoveryAgent.initiateRecovery(failureScope);
                    }
                }
                catch (RecoveryFailedException exc) {
                    if (!tc.isEntryEnabled()) throw exc;
                    Tr.exit((TraceComponent)tc, (String)"directInitialization", (Object)exc);
                    throw exc;
                }
                HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
                // MONITORENTER : hashMap
                while (this.initializationOutstanding(recoveryAgent, failureScope)) {
                    try {
                        this._outstandingInitializationRecords.wait();
                    }
                    catch (InterruptedException enableHADBPeerLocking) {
                        void exc;
                        FFDCFilter.processException((Throwable)enableHADBPeerLocking, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"740", (Object)this, (Object[])new Object[]{failureScope});
                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directInitialization", (String)"432", (Object)this);
                    }
                }
                // MONITOREXIT : hashMap
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void directTermination(FailureScope failureScope) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"directTermination", (Object)new Object[]{failureScope, this});
        }
        Tr.info((TraceComponent)tc, (String)"CWRLS0014_HALT_PEER_RECOVERY", (Object)failureScope.serverName());
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(3, failureScope);
        }
        if (Configuration.HAEnabled()) {
            Configuration.getRecoveryLogComponent().leaveCluster(failureScope);
        }
        Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
        for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            for (RecoveryAgent recoveryAgent : registeredRecoveryAgentsArray) {
                this.addTerminationRecord(recoveryAgent, failureScope);
                try {
                    recoveryAgent.terminateRecovery(failureScope);
                }
                catch (TerminationFailedException terminationFailedException) {
                    void exc;
                    FFDCFilter.processException((Throwable)terminationFailedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"811", (Object)this, (Object[])new Object[]{failureScope});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", (String)"540", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"directTermination", (Object)exc);
                    }
                    throw exc;
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"816", (Object)this, (Object[])new Object[]{failureScope});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", (String)"576", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"directTermination", (Object)exc);
                    }
                    throw new TerminationFailedException(exc);
                }
                HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
                synchronized (hashMap) {
                    while (this.terminationOutstanding(recoveryAgent, failureScope)) {
                        try {
                            this._outstandingTerminationRecords.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            void exc;
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"828", (Object)this, (Object[])new Object[]{failureScope});
                            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", (String)"549", (Object)this);
                        }
                    }
                }
            }
        }
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(4, failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"directTermination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInitializationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addInitializationRecord", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingInitializationRecords.get(recoveryAgent);
            if (failureScopeSet == null) {
                failureScopeSet = new HashSet();
                this._outstandingInitializationRecords.put(recoveryAgent, failureScopeSet);
            }
            failureScopeSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addInitializationRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTerminationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTerminationRecord", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingTerminationRecords.get(recoveryAgent);
            if (failureScopeSet == null) {
                failureScopeSet = new HashSet();
                this._outstandingTerminationRecords.put(recoveryAgent, failureScopeSet);
            }
            failureScopeSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTerminationRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInitializationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeInitializationRecord", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        boolean found = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingInitializationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                found = failureScopeSet.remove(failureScope);
            }
            this._outstandingInitializationRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeInitializationRecord", (Object)found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTerminationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeTerminationRecord", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        boolean found = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingTerminationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                found = failureScopeSet.remove(failureScope);
            }
            this._outstandingTerminationRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeTerminationRecord", (Object)found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializationOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializationOutstanding", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        boolean outstanding = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingInitializationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                outstanding = failureScopeSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializationOutstanding", (Object)outstanding);
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean terminationOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminationOutstanding", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        boolean outstanding = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingTerminationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                outstanding = failureScopeSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminationOutstanding", (Object)outstanding);
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void driveLocalRecovery() throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"driveLocalRecovery", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RLSHA: configuring for local only recovery");
        }
        RecoveryDirectorImpl recoveryDirectorImpl = this;
        synchronized (recoveryDirectorImpl) {
            if (this._currentFailureScope == null) {
                this._currentFailureScope = new FileFailureScope();
            }
        }
        try {
            this.directInitialization(this._currentFailureScope);
        }
        catch (RecoveryFailedException recoveryFailedException) {
            void exc;
            FFDCFilter.processException((Throwable)recoveryFailedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"1175", (Object)this, (Object[])new Object[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"driveLocalRecovery", (Object)exc);
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"driveLocalRecovery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoveryRecord", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap<FailureScope, HashSet<RecoveryAgent>> hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> recoveryAgentSet = this._outstandingRecoveryRecords.get(failureScope);
            if (recoveryAgentSet == null) {
                recoveryAgentSet = new HashSet();
                this._outstandingRecoveryRecords.put(failureScope, recoveryAgentSet);
            }
            recoveryAgentSet.add(recoveryAgent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoveryRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoveryRecord", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        boolean found = false;
        HashMap<FailureScope, HashSet<RecoveryAgent>> hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> recoveryAgentSet = this._outstandingRecoveryRecords.get(failureScope);
            if (recoveryAgentSet != null) {
                found = recoveryAgentSet.remove(recoveryAgent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoveryRecord", (Object)found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoveryOutstanding(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryOutstanding", (Object)new Object[]{failureScope, this});
        }
        boolean outstanding = false;
        HashMap<FailureScope, HashSet<RecoveryAgent>> hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> recoveryAgentSet = this._outstandingRecoveryRecords.get(failureScope);
            if (recoveryAgentSet != null && recoveryAgentSet.size() > 0) {
                outstanding = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryOutstanding", (Object)outstanding);
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void initialRecoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialRecoveryComplete", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialRecoveryComplete", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (!this.recoveryOutstanding(failureScope)) {
            boolean atLeastOneServiceReportedFailure = false;
            HashSet<FailureScope> hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                atLeastOneServiceReportedFailure = this._initFailedFailureScopes.remove(failureScope);
            }
            if (!atLeastOneServiceReportedFailure) {
                if (this._registeredCallbacks != null) {
                    this.driveCallBacks(2, failureScope);
                }
                if (failureScope.equals(Configuration.localFailureScope()) && Configuration.HAEnabled()) {
                    Configuration.getRecoveryLogComponent().enablePeerRecovery();
                }
            } else {
                if (this._registeredCallbacks != null) {
                    this.driveCallBacks(5, failureScope);
                }
                if (Configuration.localFailureScope().equals(failureScope)) {
                    Configuration.getRecoveryLogComponent().localRecoveryFailed();
                } else {
                    block18: {
                        try {
                            this.directTermination(failureScope);
                        }
                        catch (Exception exception) {
                            void exc;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"1432", (Object)this, (Object[])new Object[]{recoveryAgent, failureScope});
                            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.initialRecoveryComplete", (String)"1399", (Object)this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug((TraceComponent)tc, (String)"initialRecoveryComplete", (Object)"An unexpected excetion occured whilst terminating recovery processing");
                        }
                    }
                    Configuration.getRecoveryLogComponent().deactivateGroup(failureScope, 60);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialRecoveryComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialRecoveryFailed(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialRecoveryFailed", (Object)new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialRecoveryFailed", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (!this.recoveryOutstanding(failureScope)) {
            if (this._registeredCallbacks != null) {
                this.driveCallBacks(5, failureScope);
            }
            HashSet<FailureScope> hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                this._initFailedFailureScopes.remove(failureScope);
            }
            if (Configuration.localFailureScope().equals(failureScope)) {
                Configuration.getRecoveryLogComponent().localRecoveryFailed();
            } else {
                try {
                    this.directTermination(failureScope);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"1505", (Object)this, (Object[])new Object[]{recoveryAgent, failureScope});
                }
                Configuration.getRecoveryLogComponent().deactivateGroup(failureScope, 60);
            }
        } else {
            HashSet<FailureScope> hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                this._initFailedFailureScopes.add(failureScope);
            }
            int failedClientId = recoveryAgent.clientIdentifier();
            Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
            for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
                for (RecoveryAgent informRecoveryAgent : registeredRecoveryAgentsArray) {
                    if (informRecoveryAgent.clientIdentifier() == failedClientId) continue;
                    informRecoveryAgent.agentReportedFailure(failedClientId, failureScope);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialRecoveryFailed");
        }
    }

    @Override
    public synchronized void addCallBack(RecoveryLogCallBack callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCallBack", (Object)callback);
        }
        if (this._registeredCallbacks == null) {
            this._registeredCallbacks = new HashSet();
        }
        this._registeredCallbacks.add(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCallBack");
        }
    }

    private void driveCallBacks(int stage, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            switch (stage) {
                case 1: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object)new Object[]{"CALLBACK_RECOVERYSTARTED", failureScope});
                    break;
                }
                case 2: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object)new Object[]{"CALLBACK_RECOVERYCOMPLETE", failureScope});
                    break;
                }
                case 3: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object)new Object[]{"CALLBACK_TERMINATIONSTARTED", failureScope});
                    break;
                }
                case 4: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object)new Object[]{"CALLBACK_TERMINATIONCOMPLETE", failureScope});
                    break;
                }
                case 5: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object)new Object[]{"CALLBACK_RECOVERYFAILED", failureScope});
                    break;
                }
                default: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object)new Object[]{new Integer(stage), failureScope});
                }
            }
        }
        if (this._registeredCallbacks != null) {
            for (RecoveryLogCallBack callBack : this._registeredCallbacks) {
                switch (stage) {
                    case 1: {
                        callBack.recoveryStarted(failureScope);
                        break;
                    }
                    case 2: 
                    case 5: {
                        callBack.recoveryCompleted(failureScope);
                        break;
                    }
                    case 3: {
                        callBack.terminateStarted(failureScope);
                        break;
                    }
                    case 4: {
                        callBack.terminateCompleted(failureScope);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"driveCallBacks");
        }
    }

    @Override
    public Object getRecoveryLogConfiguration(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoveryLogConfiguration", (Object)failureScope);
        }
        Object recoveryLog = Configuration.getRecoveryLogComponent().getRecoveryLogConfig(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoveryLogConfiguration", (Object)recoveryLog);
        }
        return recoveryLog;
    }

    @Override
    public String getNonNullCurrentFailureScopeIDString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNonNullCurrentFailureScopeIDString");
        }
        String value = Configuration.getRecoveryLogComponent().getNonNullCurrentFailureScopeIDString(this.currentFailureScope().serverName());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNonNullCurrentFailureScopeIDString", (Object)value);
        }
        return value;
    }

    @Override
    public void registerRecoveryEventListener(RecoveryEventListener rel) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerRecoveryEventListener", (Object)rel);
        }
        RegisteredRecoveryEventListeners.instance().add(rel);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerRecoveryEventListener");
        }
    }

    @Override
    public boolean isHAEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isHAEnabled");
        }
        boolean haEnabled = Configuration.HAEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isHAEnabled", (Object)haEnabled);
        }
        return haEnabled;
    }

    public static void reset() {
        _instance = null;
    }

    @Override
    public void setRecoveryLogFactory(RecoveryLogFactory fac) {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(RecoveryDirectorImpl.class, null, null);
        tc = Tr.register(RecoveryDirectorImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    }
}

