/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class PropertyService
extends Properties {
    private static final long serialVersionUID = -6017388542378621407L;
    private static final TraceComponent tc = Tr.register(PropertyService.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    public static final List<String> DURATION_MIXED_PROPS = Arrays.asList("lockTimeout");
    private static final List<String> DURATION_MS_LONG_PROPS = Arrays.asList("ifxCPMServiceInterval");
    public static final List<String> DURATION_MS_INT_PROPS = Arrays.asList("ifxIFX_SOC_TIMEOUT", "soTimeout");
    public static final List<String> DURATION_S_INT_PROPS = Arrays.asList("abandonedConnectionTimeout", "affinityFailbackInterval", "blockingReadConnectionTimeout", "commandTimeout", "connectionRetryDelay", "connectionTimeout", "connectionWaitTimeout", "currentLockTimeout", "ifxIFX_LOCK_MODE_WAIT", "ifxINFORMIXCONTIME", "inactiveConnectionTimeout", "keepAliveTimeOut", "loginTimeout", "maxConnectionReuseTime", "maxIdleTime", "memberConnectTimeout", "queryTimeout", "retryIntervalForClientReroute", "secondsToTrustIdleConnection", "soLinger", "timeoutCheckInterval", "timeToLiveConnectionTimeout");
    public static final String FACTORY_PID = "com.ibm.ws.jdbc.dataSource.properties";
    static final String ID = "id";
    private static final List<String> PASSWORD_PROPS = Arrays.asList(DataSourceDef.password.name(), "accessToken", "apiKey", "keyStoreSecret", "trustStorePassword", "sslTrustStorePassword", "sslKeyStorePassword", "connectionProperties", "connectionFactoryProperties");
    public static final String PROPERTIES = "properties";
    private String factoryPID;

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getFactoryPID() {
        return this.factoryPID;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static final Map<?, ?> hidePasswords(Map<?, ?> map) {
        map = new HashMap(map);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() instanceof String && PropertyService.isPassword((String)entry.getKey())) {
                entry.setValue("******");
                continue;
            }
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !((String)entry.getKey()).toLowerCase().contains("url")) continue;
            entry.setValue(PropertyService.filterURL((String)entry.getValue()));
        }
        return map;
    }

    public static String filterURL(String url) {
        int first = url.indexOf(":");
        int second = url.indexOf(":", first + 1);
        int third = url.indexOf(":", second + 1);
        StringBuilder sb = new StringBuilder(url.length());
        Pattern alphanumericPattern = Pattern.compile("[\\w]*");
        if (first >= 0 && second >= 0) {
            if (third < 0) {
                sb.append(url.substring(0, second + 1));
            } else {
                String subString = url.substring(second + 1, third);
                if (alphanumericPattern.matcher(subString).matches()) {
                    sb.append(url.substring(0, third + 1));
                } else {
                    sb.append(url.substring(0, second + 1));
                }
            }
        }
        sb.append("****");
        return sb.toString();
    }

    public static final boolean isPassword(String name) {
        return PASSWORD_PROPS.contains(name) || name.toLowerCase().contains(DataSourceDef.password.name());
    }

    public static void parseDurationProperties(Map<String, Object> vendorProps, String className, ConnectorService connectorSvc) throws Exception {
        block15: {
            Object propValue;
            for (String propName : DURATION_MS_LONG_PROPS) {
                propValue = vendorProps.remove(propName);
                if (propValue == null) continue;
                try {
                    vendorProps.put(propName, MetatypeUtils.evaluateDuration((String)((String)propValue), (TimeUnit)TimeUnit.MILLISECONDS));
                }
                catch (Exception x) {
                    x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{propValue, propName, className});
                    if (x == null) continue;
                    throw x;
                }
            }
            for (String propName : DURATION_MS_INT_PROPS) {
                propValue = vendorProps.remove(propName);
                if (propValue == null) continue;
                try {
                    vendorProps.put(propName, MetatypeUtils.evaluateDuration((String)((String)propValue), (TimeUnit)TimeUnit.MILLISECONDS).intValue());
                }
                catch (Exception x) {
                    x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{propValue, propName, className});
                    if (x == null) continue;
                    throw x;
                }
            }
            for (String propName : DURATION_S_INT_PROPS) {
                propValue = vendorProps.remove(propName);
                if (propValue == null) continue;
                if (propValue instanceof String) {
                    try {
                        vendorProps.put(propName, MetatypeUtils.evaluateDuration((String)((String)propValue), (TimeUnit)TimeUnit.SECONDS).intValue());
                        continue;
                    }
                    catch (Exception x) {
                        x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{propValue, propName, className});
                        if (x == null) continue;
                        throw x;
                    }
                }
                vendorProps.put(propName, propValue);
            }
            Object lockTimeout = vendorProps.remove("lockTimeout");
            if (lockTimeout != null) {
                try {
                    if (className.startsWith("com.microsoft")) {
                        vendorProps.put("lockTimeout", MetatypeUtils.evaluateDuration((String)((String)lockTimeout), (TimeUnit)TimeUnit.MILLISECONDS));
                    } else {
                        vendorProps.put("lockTimeout", MetatypeUtils.evaluateDuration((String)((String)lockTimeout), (TimeUnit)TimeUnit.SECONDS).intValue());
                    }
                }
                catch (Exception x) {
                    x = (Exception)connectorSvc.ignoreWarnOrFail(tc, (Throwable)x, x.getClass(), "UNSUPPORTED_VALUE_J2CA8011", new Object[]{lockTimeout, "lockTimeout", className});
                    if (x == null) break block15;
                    throw x;
                }
            }
        }
    }

    public static final void parsePasswordProperties(Map<String, Object> vendorProps) {
        for (String propName : PASSWORD_PROPS) {
            String propValue = (String)vendorProps.remove(propName);
            if (propValue == null) continue;
            vendorProps.put(propName, new SerializableProtectedString(propValue.toCharArray()));
        }
    }

    public void setFactoryPID(String factoryPID) {
        this.factoryPID = factoryPID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Map<?, ?> copyWithPasswordsHidden;
        PropertyService propertyService = this;
        synchronized (propertyService) {
            copyWithPasswordsHidden = PropertyService.hidePasswords(this);
        }
        return copyWithPasswordsHidden.toString();
    }
}

