/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.websphere.config.mbeans.ServerSchemaGenerator;
import com.ibm.websphere.metatype.OutputVersion;
import com.ibm.websphere.metatype.SchemaGenerator;
import com.ibm.websphere.metatype.SchemaGeneratorOptions;
import com.ibm.websphere.metatype.SchemaVersion;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.management.StandardMBean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ServerSchemaGenerator.class}, property={"jmx.objectname=WebSphere:name=com.ibm.ws.config.serverSchemaGenerator", "service.vendor=IBM"})
public class ServerSchemaGeneratorImpl
extends StandardMBean
implements ServerSchemaGenerator {
    private static final TraceComponent tc = Tr.register(ServerSchemaGeneratorImpl.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    public static final String TRACE_BUNDLE_SCHEMA = "com.ibm.ws.config.internal.resources.SchemaData";
    private static final String SERVER_SCHEMA_DIR = "${server.output.dir}/" + File.separator + "schemagen";
    private ComponentContext context;
    private static final String KEY_SCHEMA_GEN = "schemaGen";
    private final AtomicServiceReference<SchemaGenerator> schemaGenRef = new AtomicServiceReference("schemaGen");
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private static final String SCHEMA_GEN_PREFIX = "schemaGenerator_";
    private static final String SERVER_SCHEMA_GEN_FILE = "server.xsd";
    private static final String SCHEMA_GEN_SUFFIX = ".xsd";
    static final long serialVersionUID = -3163889032617711872L;

    public ServerSchemaGeneratorImpl() {
        super(ServerSchemaGenerator.class, false);
    }

    @Activate
    protected void activate(ComponentContext ctxt) throws Exception {
        this.context = ctxt;
        this.schemaGenRef.activate(ctxt);
        this.locationAdminRef.activate(ctxt);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        this.schemaGenRef.deactivate(ctxt);
        this.locationAdminRef.deactivate(ctxt);
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    protected WsLocationAdmin getWsLocationAdmin() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin == null) {
            this.throwMissingServiceError("WsLocationAdmin");
        }
        return locationAdmin;
    }

    @Reference(name="schemaGen", service=SchemaGenerator.class)
    protected void setSchemaGen(ServiceReference<SchemaGenerator> ref) {
        this.schemaGenRef.setReference(ref);
    }

    protected void unsetSchemaGen(ServiceReference<SchemaGenerator> ref) {
        this.schemaGenRef.unsetReference(ref);
    }

    protected SchemaGenerator getSchemaGenerator() {
        SchemaGenerator schemaGen = (SchemaGenerator)this.schemaGenRef.getService();
        if (schemaGen == null) {
            this.throwMissingServiceError("SchemaGenerator");
        }
        return schemaGen;
    }

    public String generate() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String str = null;
        SchemaGeneratorOptions options = new SchemaGeneratorOptions();
        options.setEncoding("UTF-8");
        options.setBundles(this.context.getBundleContext().getBundles());
        options.setIsRuntime(true);
        try {
            this.getSchemaGenerator().generate((OutputStream)out, options);
            str = ((Object)out).toString();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.schemagen.internal.ServerSchemaGeneratorImpl", (String)"140", (Object)this, (Object[])new Object[0]);
        }
        return str;
    }

    public Map<String, Object> generateInstallSchema(String schemaVersion, String outputVersion, String encoding, String locale) {
        return this.commonGenerateInstallSchema(schemaVersion, outputVersion, encoding, locale, false, false);
    }

    public Map<String, Object> generateInstallSchema(String schemaVersion, String outputVersion, String encoding, String locale, boolean compactOutput) {
        return this.commonGenerateInstallSchema(schemaVersion, outputVersion, encoding, locale, compactOutput, true);
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, Object> commonGenerateInstallSchema(String schemaVersion, String outputVersion, String encoding, String locale, boolean compactOutput, boolean isCompact) {
        HashMap<String, Object> returnMap;
        try {
            ArrayList<String> commandList = new ArrayList<String>();
            String javaHome = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 6246769658513976867L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return System.getProperty("java.home");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
                }
            });
            String schemaGenPath = this.getWsLocationAdmin().resolveString("${wlp.install.dir}/bin/tools/ws-schemagen.jar");
            commandList.add(javaHome + "/bin/java");
            commandList.add("-jar");
            commandList.add(schemaGenPath);
            if (encoding != null && !encoding.trim().isEmpty()) {
                commandList.add("--encoding=" + encoding);
            }
            if (locale != null && !locale.trim().isEmpty()) {
                commandList.add("--locale=" + locale);
            }
            if (isCompact) {
                commandList.add("--compactOutput=" + compactOutput);
            }
            commandList.add("--schemaVersion=" + SchemaVersion.getEnum((String)schemaVersion));
            commandList.add("--outputVersion=" + OutputVersion.getEnum((String)outputVersion));
            File targetDirectory = new File(this.getWsLocationAdmin().resolveString("${server.state.dir}/"));
            if (!FileUtils.fileExists((File)targetDirectory)) {
                FileUtils.fileMkDirs((File)targetDirectory);
            }
            File generatedFile = File.createTempFile(SCHEMA_GEN_PREFIX, SCHEMA_GEN_SUFFIX, targetDirectory);
            commandList.add(generatedFile.getAbsolutePath());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (String command : commandList) {
                    sb.append(command);
                    sb.append("\n");
                }
                Tr.debug((TraceComponent)tc, (String)("List of commands:\n" + sb.toString()), (Object[])new Object[0]);
            }
            ProcessBuilder builder = new ProcessBuilder(commandList);
            builder.redirectErrorStream(true);
            Process schemaGenProc = builder.start();
            String output = this.getOutput(schemaGenProc);
            int exitVal = schemaGenProc.waitFor();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ExitVal: " + exitVal), (Object[])new Object[0]);
            }
            if (exitVal != 0) {
                return this.retError(output);
            }
            returnMap = new HashMap<String, Object>();
            returnMap.put("keyFilePath", generatedFile.getAbsolutePath());
            returnMap.put("keyOutput", output);
            returnMap.put("keyReturnCode", 0);
        }
        catch (IllegalArgumentException commandList) {
            void iae;
            FFDCFilter.processException((Throwable)commandList, (String)"com.ibm.ws.config.schemagen.internal.ServerSchemaGeneratorImpl", (String)"244", (Object)this, (Object[])new Object[]{schemaVersion, outputVersion, encoding, locale, compactOutput, isCompact});
            return this.retError("java.lang.IllegalArgumentException: " + iae.getMessage());
        }
        catch (IOException iae) {
            void ioe;
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.config.schemagen.internal.ServerSchemaGeneratorImpl", (String)"246", (Object)this, (Object[])new Object[]{schemaVersion, outputVersion, encoding, locale, compactOutput, isCompact});
            return this.retError("java.io.IOException: " + ioe.getMessage());
        }
        catch (InterruptedException ioe) {
            void ie;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.config.schemagen.internal.ServerSchemaGeneratorImpl", (String)"248", (Object)this, (Object[])new Object[]{schemaVersion, outputVersion, encoding, locale, compactOutput, isCompact});
            return this.retError("java.lang.InterruptedException: " + ie.getMessage());
        }
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOutput(Process joinProc) throws IOException {
        InputStream stream = joinProc.getInputStream();
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader reader = null;){
            int charsRead;
            reader = new InputStreamReader(stream);
            while ((charsRead = reader.read(buf)) > 0) {
                sb.append(buf, 0, charsRead);
            }
        }
        return sb.toString();
    }

    private void throwMissingServiceError(String service) {
        throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{service}));
    }

    private Map<String, Object> retError(String msg) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("keyOutput", msg);
        returnMap.put("keyReturnCode", 21);
        return returnMap;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> generateServerSchema(String schemaVersion, String outputVersion, String encoding, String locale) {
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        SchemaGeneratorOptions options = new SchemaGeneratorOptions();
        File targetDirectory = new File(this.getWsLocationAdmin().resolveString(SERVER_SCHEMA_DIR));
        if (!FileUtils.fileExists((File)targetDirectory)) {
            FileUtils.fileMkDirs((File)targetDirectory);
        }
        File generatedFile = null;
        try {
            generatedFile = new File(targetDirectory, SERVER_SCHEMA_GEN_FILE);
            PrintWriter writer = new PrintWriter(generatedFile, encoding);
            options.setEncoding(encoding);
            options.setLocale(this.getLocale(locale));
            options.setBundles(this.context.getBundleContext().getBundles());
            options.setIsRuntime(true);
            options.setOutputVersion(outputVersion);
            options.setSchemaVersion(schemaVersion);
            this.getSchemaGenerator().generate((Writer)writer, options);
        }
        catch (IOException writer) {
            void ioe;
            FFDCFilter.processException((Throwable)writer, (String)"com.ibm.ws.config.schemagen.internal.ServerSchemaGeneratorImpl", (String)"319", (Object)this, (Object[])new Object[]{schemaVersion, outputVersion, encoding, locale});
            return this.retError("java.io.IOException: " + ioe.getMessage());
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("keyFilePath", generatedFile.getAbsolutePath());
        returnMap.put("keyReturnCode", 0);
        returnMap.put("keyOutput", Integer.toString(0));
        return returnMap;
    }

    private Locale getLocale(String localeStr) {
        Locale retLocale = Locale.getDefault();
        if (localeStr != null) {
            int index = localeStr.indexOf(95);
            String country = index == -1 ? localeStr : localeStr.substring(0, index);
            retLocale = index == -1 ? new Locale(country) : new Locale(localeStr.substring(index + 1));
        }
        return retLocale;
    }
}

