/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.management.j2ee.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.management.j2ee.internal.JCAConnectionFactoryMBeanImpl;
import com.ibm.ws.jca.management.j2ee.internal.JCAManagedConnectionFactoryMBeanImpl;
import com.ibm.ws.jca.management.j2ee.internal.JCAResourceMBeanImpl;
import com.ibm.ws.jca.management.j2ee.internal.ResourceAdapterMBeanImpl;
import com.ibm.ws.jca.management.j2ee.internal.ResourceAdapterModuleMBeanImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceFactory;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.spi.BootstrapContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public class JCAMBeanRuntime {
    private static final TraceComponent tc = Tr.register(JCAMBeanRuntime.class, (String)"WAS.j2c");
    private static final String className = "JCAMBeanRuntime :";
    private static int counterSetConnectionFactory = 0;
    private static int counterSetResourceAdapter = 0;
    private static int counterUnsetConnectionFactory = 0;
    private static int counterUnsetResourceAdapter = 0;
    protected final ConcurrentHashMap<String, ResourceAdapterMBeanImpl> resourceAdapters = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, ResourceAdapterModuleMBeanImpl> resourceAdapterModules = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, JCAResourceMBeanImpl> jcaResources = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, JCAConnectionFactoryMBeanImpl> jcaConnectionFactorys = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, JCAManagedConnectionFactoryMBeanImpl> jcaManagedConnectionFactorys = new ConcurrentHashMap();
    static final long serialVersionUID = -5986071234778339755L;

    @Activate
    protected void activate(Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"JCAMBeanRuntime activated", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("JCAMBeanRuntime deactivated, reason=" + reason), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @Reference(service=ResourceFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.name=com.ibm.ws.jca.connectionFactory.supertype)")
    protected void setConnectionFactory(ServiceReference<ResourceFactory> ref) {
        String methodName = "setConnectionFactory";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConnectionFactory", (Object[])new Object[]{"Entry Count: " + ++counterSetConnectionFactory});
        }
        JCAMBeanRuntime jCAMBeanRuntime = this;
        synchronized (jCAMBeanRuntime) {
            String name = (String)ref.getProperty("config.displayId");
            String id = name.contains("]/") ? null : (String)ref.getProperty("id");
            String jndiName = (String)ref.getProperty("jndiName");
            String mcf = (String)ref.getProperty("properties.0.managedconnectionfactory-class");
            String resourceAdapter = (String)ref.getProperty("properties.0.resourceAdapterConfig.id");
            String jcaResourcName = resourceAdapter + "/JCAResource";
            BundleContext bndCtx = JCAMBeanRuntime.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
            String server = bndCtx.getProperty("wlp.server.name");
            JCAResourceMBeanImpl rmbean = this.jcaResources.get(jcaResourcName);
            if (rmbean == null) {
                rmbean = new JCAResourceMBeanImpl(jcaResourcName, resourceAdapter, server);
                rmbean.register(bndCtx);
                JCAResourceMBeanImpl rmbeanTemp = this.jcaResources.putIfAbsent(jcaResourcName, rmbean);
                if (rmbeanTemp != null && trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JCAResourceMBean: Unexpected put for the key: " + rmbean.getName() + " happened in " + className + "setConnectionFactory"), (Object[])new Object[0]);
                }
            }
            JCAConnectionFactoryMBeanImpl cfmbean = new JCAConnectionFactoryMBeanImpl(id, jndiName, name, server, mcf, resourceAdapter);
            cfmbean.register(bndCtx);
            JCAConnectionFactoryMBeanImpl cfmbeanTemp = this.jcaConnectionFactorys.putIfAbsent(name, cfmbean);
            if (cfmbeanTemp != null && trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JCAConnectionFactoryMBean: Unexpected put for the key: " + cfmbean.getName() + " happened in " + className + "setConnectionFactory"), (Object[])new Object[0]);
            }
            rmbean.setConnectionFactoryChild(cfmbean.getName(), cfmbean);
            JCAManagedConnectionFactoryMBeanImpl mcfmbean = new JCAManagedConnectionFactoryMBeanImpl(name, server);
            mcfmbean.register(bndCtx);
            JCAManagedConnectionFactoryMBeanImpl mcfmbeanTemp = this.jcaManagedConnectionFactorys.putIfAbsent(name, mcfmbean);
            if (mcfmbeanTemp != null && trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JCAManagedConnectionFactoryMBean: Unexpected put for the key: " + mcfmbean.getName() + " happened in " + className + "setConnectionFactory"), (Object[])new Object[0]);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConnectionFactory", (Object)"Normal Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    @Reference(service=BootstrapContext.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.name=com.ibm.ws.jca.resourceAdapter.properties)")
    protected void setResourceAdapter(ServiceReference<BootstrapContext> ref) {
        String methodName = "setResourceAdapter";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setResourceAdapter", (Object[])new Object[]{"Entry Count: " + ++counterSetResourceAdapter});
        }
        JCAMBeanRuntime jCAMBeanRuntime = this;
        synchronized (jCAMBeanRuntime) {
            ResourceAdapterModuleMBeanImpl ramMBean;
            URL fullPathToRAR;
            Collection urls;
            String rarFileName;
            String serverLocation;
            String server;
            BundleContext bndCtx;
            String appName;
            String id;
            String moduleName;
            String name;
            block19: {
                name = (String)ref.getProperty("config.displayId");
                moduleName = (String)ref.getProperty("module-name");
                if (moduleName == null) {
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"setResourceAdapter", (Object)"Short Exit. No MBeans were created.");
                    }
                    return;
                }
                id = (String)ref.getProperty("id");
                int appNameLength = id.length() - moduleName.length() - 1;
                appName = appNameLength > 0 ? id.substring(0, appNameLength) : null;
                bndCtx = JCAMBeanRuntime.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
                server = bndCtx.getProperty("wlp.server.name");
                serverLocation = bndCtx.getProperty("server.config.dir");
                rarFileName = null;
                urls = null;
                fullPathToRAR = null;
                ServiceReference<?>[] rasRef = null;
                try {
                    rasRef = JCAMBeanRuntime.getServiceReferences(bndCtx, "com.ibm.ws.jca.internal.ResourceAdapterService", (String)ref.getProperty("raDDPath"));
                    for (int i = 0; i < rasRef.length; ++i) {
                        String rasRefId = (String)rasRef[i].getProperty("id");
                        if (rasRefId == null || !rasRefId.equals(id)) continue;
                        rarFileName = (String)rasRef[i].getProperty("rarFileName");
                        urls = (Collection)rasRef[i].getProperty("urls");
                    }
                }
                catch (InvalidSyntaxException rasRefId) {
                    void e;
                    FFDCFilter.processException((Throwable)rasRefId, (String)"com.ibm.ws.jca.management.j2ee.internal.JCAMBeanRuntime", (String)"203", (Object)this, (Object[])new Object[]{ref});
                    if (!trace || !tc.isDebugEnabled()) break block19;
                    Tr.debug((TraceComponent)tc, (String)"ResourceAdapterModuleMBean: Failed to obtain the name of the RAR file happened in JCAMBeanRuntime :setResourceAdapter", (Object[])new Object[]{e});
                }
            }
            if (urls != null && !urls.isEmpty()) {
                String path;
                for (URL urlItem : urls) {
                    path = urlItem.getPath();
                    if (!path.endsWith(rarFileName)) continue;
                    fullPathToRAR = urlItem;
                    break;
                }
                if (fullPathToRAR == null) {
                    for (URL urlItem : urls) {
                        path = urlItem.getPath();
                        if (!path.contains(rarFileName)) continue;
                        fullPathToRAR = urlItem;
                        break;
                    }
                }
            } else if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ResourceAdapterModuleMBean: Failed to obtain the full path to the RAR file because the URLs Collection is null or empty. Used server: " + serverLocation + " This happened in " + className + "setResourceAdapter"), (Object[])new Object[0]);
            }
            if ((ramMBean = this.resourceAdapterModules.get(name)) == null) {
                ramMBean = new ResourceAdapterModuleMBeanImpl(id, name, server, appName, fullPathToRAR);
                ramMBean.register(bndCtx);
                ResourceAdapterModuleMBeanImpl rammbeanTemp = this.resourceAdapterModules.putIfAbsent(name, ramMBean);
                if (rammbeanTemp != null && trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ResourceAdapterModuleMBean: Unexpected put for the key: " + ramMBean.getName() + " happened in " + className + "setResourceAdapter"), (Object[])new Object[0]);
                }
            }
            ResourceAdapterMBeanImpl rambean = new ResourceAdapterMBeanImpl(id, name, server, appName, moduleName, this);
            rambean.register(bndCtx);
            ResourceAdapterMBeanImpl rambeanTemp = this.resourceAdapters.putIfAbsent(name, rambean);
            if (rambeanTemp != null && trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ResourceAdapterMBean: Unexpected put for the key: " + rambean.getName() + " happened in " + className + "setResourceAdapter"), (Object[])new Object[0]);
            }
            ramMBean.setResourceAdapterChild(rambean.getName(), rambean);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setResourceAdapter", (Object)"Normal Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected synchronized void unsetConnectionFactory(ServiceReference<ResourceFactory> ref) {
        String methodName = "unsetConnectionFactory";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetConnectionFactory", (Object[])new Object[]{"Entry Count: " + ++counterUnsetConnectionFactory});
        }
        JCAMBeanRuntime jCAMBeanRuntime = this;
        synchronized (jCAMBeanRuntime) {
            String name = (String)ref.getProperty("config.displayId");
            String resourceAdapter = (String)ref.getProperty("properties.0.resourceAdapterConfig.id");
            String jcaResourcName = resourceAdapter + "/JCAResource";
            JCAResourceMBeanImpl rmbean = this.jcaResources.get(jcaResourcName);
            JCAConnectionFactoryMBeanImpl cfmbean = this.jcaConnectionFactorys.get(name);
            JCAManagedConnectionFactoryMBeanImpl mcfmbean = this.jcaManagedConnectionFactorys.get(name);
            rmbean.removeConnectionFactoryChild(cfmbean.getName());
            this.jcaConnectionFactorys.remove(cfmbean.getName());
            cfmbean.unregister();
            if (rmbean.getConnectionFactoryChildrenCount() == 0) {
                this.jcaResources.remove(rmbean.getName());
                rmbean.unregister();
            }
            this.jcaManagedConnectionFactorys.remove(mcfmbean.getName());
            mcfmbean.unregister();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetConnectionFactory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void unsetResourceAdapter(ServiceReference<BootstrapContext> ref) {
        String methodName = "unsetResourceAdapter";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetResourceAdapter", (Object[])new Object[]{"Entry Count: " + ++counterUnsetResourceAdapter});
        }
        JCAMBeanRuntime jCAMBeanRuntime = this;
        synchronized (jCAMBeanRuntime) {
            String name = (String)ref.getProperty("config.displayId");
            ResourceAdapterMBeanImpl raMBean = this.resourceAdapters.get(name);
            ResourceAdapterModuleMBeanImpl ramMBean = this.resourceAdapterModules.get(name);
            if (raMBean == null || ramMBean == null) {
                if (trace && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"unsetResourceAdapter", (Object)"Short Exit. No MBeans were unregistered.");
                }
                return;
            }
            this.resourceAdapters.remove(raMBean.getName());
            raMBean.unregister();
            this.resourceAdapterModules.remove(ramMBean.getName());
            ramMBean.unregister();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetResourceAdapter");
        }
    }

    private static BundleContext getBundleContext(final Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getBundleContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){
            static final long serialVersionUID = -8472832915418810256L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public BundleContext run() {
                return bundle.getBundleContext();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, null, null);
            }
        });
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static ServiceReference<?>[] getServiceReferences(final BundleContext bCtx, final String clazz, final String filter) throws InvalidSyntaxException {
        if (System.getSecurityManager() == null) {
            return bCtx.getServiceReferences(clazz, filter);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceReference<?>[]>(){
                static final long serialVersionUID = 8196731421279671239L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ServiceReference<?>[] run() throws InvalidSyntaxException {
                    return bCtx.getServiceReferences(clazz, filter);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

