/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.config;

import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigurationSetting;
import com.ibm.ws.kernel.instrument.serialfilter.config.SimpleConfig;
import com.ibm.ws.kernel.instrument.serialfilter.config.ValidationMode;
import java.util.Properties;

interface ConfigSetting<I, O>
extends ConfigurationSetting<SimpleConfig, I, O> {

    public static enum ValidationModeGetter implements ConfigSetting<String, ValidationMode>
    {
        GET_VALIDATION_MODE;


        @Override
        public Class<String> getInputType() {
            return String.class;
        }

        @Override
        public Class<ValidationMode> getOutputType() {
            return ValidationMode.class;
        }

        @Override
        public ValidationMode apply(SimpleConfig config, String param) {
            return config.getValidationMode(param);
        }
    }

    public static enum DefaultValidationModeGetter implements ConfigSetting<Void, ValidationMode>
    {
        GET_DEFAULT_VALIDATION_MODE;


        @Override
        public Class<Void> getInputType() {
            return Void.class;
        }

        @Override
        public Class<ValidationMode> getOutputType() {
            return ValidationMode.class;
        }

        @Override
        public ValidationMode apply(SimpleConfig config, Void param) {
            return config.getDefaultMode();
        }
    }

    public static enum PropertiesSetter implements ConfigSetting<Properties, Void>
    {
        LOAD;


        @Override
        public Class<Properties> getInputType() {
            return Properties.class;
        }

        @Override
        public Class<Void> getOutputType() {
            return Void.class;
        }

        @Override
        public Void apply(SimpleConfig target, Properties props) {
            target.load(props);
            return null;
        }
    }

    public static enum Resetter implements ConfigSetting<Void, Void>
    {
        RESET;


        @Override
        public Class<Void> getInputType() {
            return Void.class;
        }

        @Override
        public Class<Void> getOutputType() {
            return Void.class;
        }

        @Override
        public Void apply(SimpleConfig config, Void param) {
            config.reset();
            return null;
        }
    }
}

