/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.config;

import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigurationSetting;
import com.ibm.ws.kernel.instrument.serialfilter.config.Configurator;
import com.ibm.ws.kernel.instrument.serialfilter.util.Functor;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfigurableFunctor<T, R, D>
extends Functor<R, D> {
    private final Logger log;
    private final T target;

    ConfigurableFunctor(T target) {
        this.target = target;
        this.log = Logger.getLogger(ConfigurableFunctor.class.getName());
    }

    @Override
    public final D put(R key, D value) {
        String str = (String)key;
        Object o = Configurator.destringify(str);
        if (o == null) {
            return this.handleUnknownConfig("Config key string could not be parsed", key, value);
        }
        if (!(o instanceof ConfigurationSetting)) {
            return this.handleUnknownConfig("Config key parsed as an unexpected type", o, value);
        }
        ConfigurationSetting setting = (ConfigurationSetting)o;
        if (!this.isExpectedType(setting.getClass())) {
            return this.handleUnknownConfig("Config key is not an expected type for this target", setting, value);
        }
        return this.apply(setting, value);
    }

    private D handleUnknownConfig(String msg, Object key, Object value) {
        if (!this.log.isLoggable(Level.SEVERE)) {
            return null;
        }
        String keyMsg = key == null ? "key = null" : "key = '" + key + "' of type " + key.getClass().getName();
        String valMsg = value == null ? "value = null" : "value = '" + value + "' of type " + value.getClass().getName();
        this.log.severe(msg + ": " + keyMsg + ", " + valMsg);
        return null;
    }

    protected abstract boolean isExpectedType(Class<? extends ConfigurationSetting> var1);

    private <I> D apply(ConfigurationSetting<T, I, ?> setting, D param) {
        try {
            I input = setting.getInputType().cast(param);
            return (D)setting.apply(this.target, input);
        }
        catch (ClassCastException e) {
            this.handleUnknownConfig("Config value does not match expected type for config key", setting, param);
            return null;
        }
    }
}

