/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.config;

import com.ibm.ws.kernel.instrument.serialfilter.config.ConfigurationSetting;
import java.util.Map;
import java.util.logging.Logger;

final class Configurator<T> {
    private final Map<Object, Object> configTarget;

    public Configurator(Map<?, ?> configTarget) {
        this.configTarget = configTarget;
    }

    public <I, O, C extends Enum<C>> O send(C option, I param) {
        Object result = this.configTarget.put(Configurator.stringify(option), param);
        Class outputType = ((ConfigurationSetting)((Object)option)).getOutputType();
        try {
            return ((ConfigurationSetting)((Object)option)).getOutputType().cast(result);
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)("Config option to map should have returned object of type " + outputType + " but returned object of type " + result.getClass()));
        }
    }

    private static String stringify(Enum<?> e) {
        return e.getClass().getName() + '#' + e.name();
    }

    public static <E extends Enum<E>> E destringify(String s) {
        String[] parts = s.split("#", 2);
        if (parts.length == 2) {
            String classname = parts[0];
            String memberName = parts[1];
            try {
                Class<?> enumClass = Class.forName(classname);
                return (E)Enum.valueOf(enumClass, memberName);
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(Configurator.class.getName()).severe("Could not find configuration option class: " + classname);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(Configurator.class.getName()).severe("Could not locate enum member: " + classname + "." + memberName);
            }
        } else {
            Logger.getLogger(Configurator.class.getName()).severe("Could not parse config key:" + s);
        }
        return null;
    }
}

