/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.instrument.serialfilter.digest;

import com.ibm.ws.kernel.instrument.serialfilter.digest.AnnotationDigester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.Digester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.DigesterSortedMap;
import com.ibm.ws.kernel.instrument.serialfilter.digest.FieldDigester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.MethodDigester;
import com.ibm.ws.kernel.instrument.serialfilter.digest.Processor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

class ClassDigester
extends ClassVisitor
implements Digester {
    private final Processor processor = new Processor();
    private final DigesterSortedMap<AnnotationDigester> annotations = new DigesterSortedMap();
    private final DigesterSortedMap<FieldDigester> fields = new DigesterSortedMap();
    private final DigesterSortedMap<MethodDigester> methods = new DigesterSortedMap();

    public ClassDigester() {
        super(458752);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.processor.consider(superName).consider(interfaces);
    }

    public AnnotationDigester visitAnnotation(String desc, boolean visible) {
        AnnotationDigester digester = new AnnotationDigester();
        this.annotations.put(desc, digester);
        return digester;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDigester digester = new FieldDigester(access, desc, value);
        this.fields.put(name, digester);
        return digester;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) == 4096) {
            return null;
        }
        MethodDigester digester = new MethodDigester(access);
        this.methods.put(name + "#" + desc, digester);
        return digester;
    }

    public final void visitEnd() {
        this.processor.consider(this.annotations).consider(this.fields).consider(this.methods);
    }

    @Override
    public byte[] getDigest() {
        return this.processor.getDigest();
    }

    public String getDigestAsString() {
        return this.processor.getDigestAsString();
    }
}

