/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MappingTable {
    public static final int METRIC_NAME = 0;
    public static final int METRIC_DISPLAYNAME = 1;
    public static final int METRIC_DESCRIPTION = 2;
    public static final int METRIC_TYPE = 3;
    public static final int METRIC_UNIT = 4;
    public static final int MBEAN_ATTRIBUTE = 5;
    public static final int MBEAN_SUBATTRIBUTE = 6;
    public static final int MBEAN_STATS_NAME = 7;
    public static final String THREADPOOL_TAG_NAME = "pool";
    public static final String SERVLET_TAG_NAME = "servlet";
    public static final String CONNECTIONPOOL_TAG_NAME = "datasource";
    public static final String SESSION_TAG_NAME = "appname";
    public static final String JAXWS_SERVER_TAG_NAME = "endpoint";
    public static final String JAXWS_CLIENT_TAG_NAME = "endpoint";
    public static final String COUNTER;
    public static final String GAUGE;
    private static MappingTable singleton;
    private Map<String, String[][]> mappingTable = new HashMap<String, String[][]>();
    static final long serialVersionUID = -131942407206209242L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static MappingTable getInstance() {
        if (singleton == null) {
            singleton = new MappingTable();
        }
        return singleton;
    }

    private MappingTable() {
        String[][] threadPoolTable = new String[][]{{"threadpool.activeThreads", "Active Threads", "threadpool.activeThreads.description", GAUGE, "none", "ActiveThreads", null, THREADPOOL_TAG_NAME}, {"threadpool.size", "Thread Pool Size", "threadpool.size.description", GAUGE, "none", "PoolSize", null, THREADPOOL_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=ThreadPoolStats,name=*", threadPoolTable);
        String[][] servletTable = new String[][]{{"servlet.request.total", "Total Request", "servlet.request.total.description", COUNTER, "none", "RequestCount", null, SERVLET_TAG_NAME}, {"servlet.responseTime.total", "Total Response Time", "servlet.responseTime.total.description", GAUGE, "nanoseconds", "ResponseTimeDetails", "total", SERVLET_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=ServletStats,name=*", servletTable);
        String[][] connectionPoolTable = new String[][]{{"connectionpool.create.total", "Create Count", "connectionpool.create.total.description", COUNTER, "none", "CreateCount", null, CONNECTIONPOOL_TAG_NAME}, {"connectionpool.destroy.total", "Destroy Count", "connectionpool.destroy.total.description", COUNTER, "none", "DestroyCount", null, CONNECTIONPOOL_TAG_NAME}, {"connectionpool.managedConnections", "Managed Connections Count", "connectionpool.managedConnections.description", GAUGE, "none", "ManagedConnectionCount", null, CONNECTIONPOOL_TAG_NAME}, {"connectionpool.connectionHandles", "Connection Handles Count", "connectionpool.connectionHandles.description", GAUGE, "none", "ConnectionHandleCount", null, CONNECTIONPOOL_TAG_NAME}, {"connectionpool.freeConnections", "Free Connections Count", "connectionpool.freeConnections.description", GAUGE, "none", "FreeConnectionCount", null, CONNECTIONPOOL_TAG_NAME}, {"connectionpool.waitTime.total", "Total Wait Time", "connectionpool.waitTime.total.description", GAUGE, "milliseconds", "WaitTimeDetails", "total", CONNECTIONPOOL_TAG_NAME}, {"connectionpool.inUseTime.total", "Total In Use Time", "connectionpool.inUseTime.total.description", GAUGE, "milliseconds", "InUseTimeDetails", "total", CONNECTIONPOOL_TAG_NAME}, {"connectionpool.queuedRequests.total", "Queued Connection Request Count", "connectionpool.queuedRequests.total.description", COUNTER, "none", "WaitTimeDetails", "count", CONNECTIONPOOL_TAG_NAME}, {"connectionpool.usedConnections.total", "Used Connections", "connectionpool.usedConnections.total.description", COUNTER, "none", "InUseTimeDetails", "count", CONNECTIONPOOL_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=ConnectionPoolStats,name=*", connectionPoolTable);
        String[][] sessionTable = new String[][]{{"session.create.total", "Total Create Count", "session.create.total.description", GAUGE, "none", "CreateCount", null, SESSION_TAG_NAME}, {"session.liveSessions", "Live Sessions Count", "session.liveSessions.description", GAUGE, "none", "LiveCount", null, SESSION_TAG_NAME}, {"session.activeSessions", "Active Sessions Count", "session.activeSessions.description", GAUGE, "none", "ActiveCount", null, SESSION_TAG_NAME}, {"session.invalidated.total", "Total Invalidated Sessions Count", "session.invalidated.total.description", COUNTER, "none", "InvalidatedCount", null, SESSION_TAG_NAME}, {"session.invalidatedbyTimeout.total", "Total Invalidated Sessions by Timeout Count", "session.invalidatedbyTimeout.total.description", COUNTER, "none", "InvalidatedCountbyTimeout", null, SESSION_TAG_NAME}};
        this.mappingTable.put("WebSphere:type=SessionStats,name=*", sessionTable);
        String[][] jaxwsServerTable = new String[][]{{"jaxws.server.invocations.total", "Total Endpoint Invocations Count", "jaxws.invocations.total.description", COUNTER, "none", "NumInvocations", null, "endpoint"}, {"jaxws.server.checkedApplicationFaults.total", "Total Checked Application Faults Count", "jaxws.checkedApplicationFaults.total.description", COUNTER, "none", "NumCheckedApplicationFaults", null, "endpoint"}, {"jaxws.server.logicalRuntimeFaults.total", "Total Logical Runtime Faults Count", "jaxws.logicalRuntimeFaults.total.description", COUNTER, "none", "NumLogicalRuntimeFaults", null, "endpoint"}, {"jaxws.server.runtimeFaults.total", "Total Runtime Faults Count", "jaxws.runtimeFaults.total.description", COUNTER, "none", "NumRuntimeFaults", null, "endpoint"}, {"jaxws.server.uncheckedApplicationFaults.total ", "Total Unchecked Application Faults Count", "jaxws.uncheckedApplicationFaults.total.description", COUNTER, "none", "NumUnCheckedApplicationFaults", null, "endpoint"}, {"jaxws.server.responseTime.total", "Total Response Time", "jaxws.responseTime.total.description", GAUGE, "milliseconds", "TotalHandlingTime", null, "endpoint"}};
        this.mappingTable.put("WebSphere:feature=jaxws,*,type=Performance.Counter.Server", jaxwsServerTable);
        String[][] jaxwsClientTable = new String[][]{{"jaxws.client.invocations.total", "Total Endpoint Invocations Count", "jaxws.invocations.total.description", COUNTER, "none", "NumInvocations", null, "endpoint"}, {"jaxws.client.checkedApplicationFaults.total", "Total Checked Application Faults Count", "jaxws.checkedApplicationFaults.total.description", COUNTER, "none", "NumCheckedApplicationFaults", null, "endpoint"}, {"jaxws.client.logicalRuntimeFaults.total", "Total Logical Runtime Faults Count", "jaxws.logicalRuntimeFaults.total.description", COUNTER, "none", "NumLogicalRuntimeFaults", null, "endpoint"}, {"jaxws.client.runtimeFaults.total", "Total Runtime Faults Count", "jaxws.runtimeFaults.total.description", COUNTER, "none", "NumRuntimeFaults", null, "endpoint"}, {"jaxws.client.uncheckedApplicationFaults.total ", "Total Unchecked Application Faults Count", "jaxws.uncheckedApplicationFaults.total.description", COUNTER, "none", "NumUnCheckedApplicationFaults", null, "endpoint"}, {"jaxws.client.responseTime.total", "Total Response Time", "jaxws.responseTime.total.description", GAUGE, "milliseconds", "TotalHandlingTime", null, "endpoint"}};
        this.mappingTable.put("WebSphere:feature=jaxws,*,type=Performance.Counter.Client", jaxwsClientTable);
    }

    private String getType(String objectName) {
        for (String subString : objectName.split(",")) {
            if (!(subString = subString.trim()).contains("type=")) continue;
            return subString.split("=")[1];
        }
        return "notype";
    }

    public String[][] getData(String objectName) {
        for (String k : this.mappingTable.keySet()) {
            if (!objectName.contains(this.getType(k))) continue;
            return this.mappingTable.get(k);
        }
        return null;
    }

    public boolean contains(String objectName) {
        for (String k : this.mappingTable.keySet()) {
            if (!objectName.contains(this.getType(k))) continue;
            return true;
        }
        return false;
    }

    public Set<String> getKeys() {
        return this.mappingTable.keySet();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MappingTable.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
        COUNTER = MetricType.COUNTER.toString().toUpperCase();
        GAUGE = MetricType.GAUGE.toString().toUpperCase();
        singleton = null;
    }
}

