/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Provider;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxws.AbstractJAXWSMethodInvoker;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.SingletonFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSMethodInvoker
extends AbstractJAXWSMethodInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXWSMethodInvoker.class);

    public JAXWSMethodInvoker(Object bean) {
        super((Factory)new SingletonFactory(bean));
    }

    public JAXWSMethodInvoker(Factory factory) {
        super(factory);
    }

    @Override
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        Map<String, Object> handlerScopedStuff = this.removeHandlerProperties(ctx);
        WebServiceContextImpl.setMessageContext(ctx);
        List res = null;
        try {
            if ((params == null || params.isEmpty()) && m.getDeclaringClass().equals(Provider.class)) {
                params = Collections.singletonList(null);
            }
            res = CastUtils.cast((List)((List)super.invoke(exchange, serviceObject, m, params)));
            if (serviceObject instanceof Provider && MessageUtils.getContextualBoolean((Message)exchange.getInMessage(), (String)"jaxws.provider.interpretNullAsOneway", (boolean)true) && res != null && !res.isEmpty() && res.get(0) == null && exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.EXECUTING) {
                res = null;
                this.changeToOneway(exchange);
            }
            this.updateWebServiceContext(exchange, ctx);
        }
        catch (Fault f) {
            this.updateHeader(exchange, ctx);
            throw f;
        }
        finally {
            if (serviceObject instanceof Provider) {
                LOG.log(Level.FINE, "Checking for cxf.add.attachments property in MessageContext...");
                boolean addAttachments = MessageUtils.isTrue((Object)ctx.get("cxf.add.attachments"));
                if (addAttachments) {
                    LOG.log(Level.FINE, "Setting cxf.add.attachments property in Message: " + addAttachments);
                    Message m1 = exchange.getOutMessage();
                    if (m1 != null) {
                        m1.put((Object)"cxf.add.attachments", (Object)Boolean.TRUE);
                    }
                }
            }
            WebServiceContextImpl.clear();
            this.addHandlerProperties(ctx, handlerScopedStuff);
        }
        return res;
    }

    private void changeToOneway(Exchange exchange) {
        exchange.setOneWay(true);
        HttpServletResponse httpresp = (HttpServletResponse)exchange.getInMessage().get((Object)"HTTP.RESPONSE");
        if (httpresp != null) {
            httpresp.setStatus(202);
        }
    }
}

