/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.concurrent.mp.ContextManagerImpl;
import com.ibm.ws.concurrent.mp.ContextManagerProviderImpl;
import com.ibm.ws.concurrent.mp.ContextOp;
import com.ibm.ws.concurrent.mp.ManagedExecutorImpl;
import com.ibm.ws.concurrent.mp.ThreadContextBuilderImpl;
import com.ibm.ws.concurrent.mp.ThreadContextImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.threading.PolicyExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManagedExecutorBuilderImpl
implements ManagedExecutor.Builder {
    private static final TraceComponent tc = Tr.register(ManagedExecutorBuilderImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    private static final int UNDEFINED = -2;
    private final ContextManagerImpl contextManager;
    private final ArrayList<ThreadContextProvider> contextProviders;
    private Set<String> cleared;
    private int maxAsync = -2;
    private int maxQueued = -2;
    private String name;
    private Set<String> propagated;
    static final long serialVersionUID = 710115452913496489L;

    ManagedExecutorBuilderImpl(ContextManagerImpl contextManager, ArrayList<ThreadContextProvider> contextProviders) {
        this.contextManager = contextManager;
        this.contextProviders = contextProviders;
    }

    public ManagedExecutor build() {
        String appName;
        ContextOp remaining;
        Set<String> cleared = this.cleared == null ? this.contextManager.getDefault("mp.context.ManagedExecutor.cleared", ThreadContextBuilderImpl.DEFAULT_CLEARED) : this.cleared;
        int maxAsync = this.maxAsync == -2 ? this.contextManager.getDefault("mp.context.ManagedExecutor.maxAsync", -1) : this.maxAsync;
        int maxQueued = this.maxQueued == -2 ? this.contextManager.getDefault("mp.context.ManagedExecutor.maxQueued", -1) : this.maxQueued;
        Set<String> propagated = this.propagated == null ? this.contextManager.getDefault("mp.context.ManagedExecutor.propagated", ThreadContextBuilderImpl.DEFAULT_PROPAGATED) : this.propagated;
        HashSet<String> unknown = new HashSet<String>(cleared);
        unknown.addAll(propagated);
        if (unknown.size() < cleared.size() + propagated.size()) {
            this.failOnOverlapOfClearedPropagated();
        }
        if (unknown.remove("Remaining")) {
            ContextOp contextOp = propagated.contains("Remaining") ? ContextOp.PROPAGATED : (remaining = cleared.contains("Remaining") ? ContextOp.CLEARED : null);
            if (remaining == null) {
                throw new ConcurrentModificationException();
            }
        } else {
            remaining = ContextOp.CLEARED;
        }
        LinkedHashMap<ThreadContextProvider, ContextOp> configPerProvider = new LinkedHashMap<ThreadContextProvider, ContextOp>();
        for (ThreadContextProvider provider : this.contextProviders) {
            String contextType = provider.getThreadContextType();
            unknown.remove(contextType);
            ContextOp op = propagated.contains(contextType) ? ContextOp.PROPAGATED : (cleared.contains(contextType) ? ContextOp.CLEARED : remaining);
            configPerProvider.put(provider, op);
        }
        if (unknown.size() > 0) {
            ThreadContextBuilderImpl.failOnUnknownContextTypes(unknown, this.contextProviders);
        }
        int hash = ContextManagerImpl.instanceCount.incrementAndGet();
        StringBuilder nameBuilder = new StringBuilder("ManagedExecutor@").append(Integer.toHexString(hash));
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        String string = appName = cData == null ? null : cData.getJ2EEName().getApplication();
        if (appName != null) {
            nameBuilder.append('_').append(appName);
        }
        if (this.name != null) {
            nameBuilder.append('_').append(this.name);
        }
        nameBuilder.append("(maxAsync=").append(maxAsync == -1 ? "max" : Integer.valueOf(maxAsync)).append(",maxQueued=").append(maxQueued == -1 ? "max" : Integer.valueOf(maxQueued));
        if (propagated.contains("Remaining")) {
            nameBuilder.append(",cleared=").append(cleared);
        } else {
            nameBuilder.append(",propagated=").append(propagated);
        }
        nameBuilder.append(')');
        String executorName = nameBuilder.toString();
        String threadContextName = nameBuilder.replace(2, 15, "ThreadContext").substring(2);
        ContextManagerProviderImpl cmProvider = this.contextManager.cmProvider;
        PolicyExecutor policyExecutor = cmProvider.policyExecutorProvider.create(executorName, appName).maxConcurrency(maxAsync).maxQueueSize(maxQueued);
        ThreadContextImpl mpThreadContext = new ThreadContextImpl(threadContextName, hash, cmProvider, configPerProvider);
        return new ManagedExecutorImpl(executorName, hash, policyExecutor, mpThreadContext, cmProvider.transactionContextProvider.transactionContextProviderRef);
    }

    public ManagedExecutor.Builder cleared(String ... types) {
        if (this.cleared == null) {
            this.cleared = new HashSet<String>();
        } else {
            this.cleared.clear();
        }
        Collections.addAll(this.cleared, types);
        return this;
    }

    private void failOnOverlapOfClearedPropagated() {
        HashSet<String> overlap = new HashSet<String>(this.cleared);
        overlap.retainAll(this.propagated);
        if (overlap.isEmpty()) {
            throw new ConcurrentModificationException();
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1151.context.lists.overlap", (Object[])new Object[]{overlap}));
    }

    public ManagedExecutor.Builder maxAsync(int max) {
        if (max == 0 || max < -1) {
            throw new IllegalArgumentException(Integer.toString(max));
        }
        this.maxAsync = max;
        return this;
    }

    public ManagedExecutor.Builder maxQueued(int max) {
        if (max == 0 || max < -1) {
            throw new IllegalArgumentException(Integer.toString(max));
        }
        this.maxQueued = max;
        return this;
    }

    public ManagedExecutor.Builder name(String name) {
        this.name = name;
        return this;
    }

    public ManagedExecutor.Builder propagated(String ... types) {
        if (this.propagated == null) {
            this.propagated = new HashSet<String>();
        } else {
            this.propagated.clear();
        }
        Collections.addAll(this.propagated, types);
        return this;
    }
}

