/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.mp.ContextManagerImpl;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MicroProfileClearedContextSnapshot
implements ThreadContext {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(MicroProfileClearedContextSnapshot.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    private static final HashSet<String> DO_NOT_CLEAR = new HashSet<String>(Arrays.asList("Application", "CDI", "Security", "SyncToOSThread", "Transaction", "Classification"));
    private final ArrayList<ThreadContextController> contextRestorers = new ArrayList();
    private final ArrayList<ThreadContextSnapshot> contextSnapshots;

    MicroProfileClearedContextSnapshot(ContextManagerImpl contextMgr) {
        this.contextSnapshots = new ArrayList();
        for (ThreadContextProvider provider : contextMgr.contextProviders) {
            if (DO_NOT_CLEAR.contains(provider.getThreadContextType())) continue;
            this.contextSnapshots.add(provider.clearedContext(Collections.emptyMap()));
        }
    }

    private MicroProfileClearedContextSnapshot(ArrayList<ThreadContextSnapshot> contextSnapshots) {
        this.contextSnapshots = contextSnapshots;
    }

    public ThreadContext clone() {
        return new MicroProfileClearedContextSnapshot(this.contextSnapshots);
    }

    public void taskStarting() throws RejectedExecutionException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        try {
            for (ThreadContextSnapshot snapshot : this.contextSnapshots) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("clearing " + snapshot), (Object[])new Object[0]);
                }
                this.contextRestorers.add(snapshot.begin());
            }
        }
        catch (Error | RuntimeException x) {
            this.taskStopping();
            throw x;
        }
    }

    public void taskStopping() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Throwable failure = null;
        for (int i = this.contextRestorers.size() - 1; i >= 0; --i) {
            try {
                ThreadContextController contextRestorer = this.contextRestorers.remove(i);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("restoring " + contextRestorer), (Object[])new Object[0]);
                }
                contextRestorer.endContext();
                continue;
            }
            catch (Error | RuntimeException x) {
                if (failure == null) continue;
                failure = x;
            }
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        outStream.putFields();
        outStream.writeFields();
    }
}

