/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.mp;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.mp.ContextManagerProviderImpl;
import com.ibm.ws.concurrent.mp.ContextOp;
import com.ibm.ws.concurrent.mp.ContextualBiConsumer;
import com.ibm.ws.concurrent.mp.ContextualBiFunction;
import com.ibm.ws.concurrent.mp.ContextualCallable;
import com.ibm.ws.concurrent.mp.ContextualConsumer;
import com.ibm.ws.concurrent.mp.ContextualExecutor;
import com.ibm.ws.concurrent.mp.ContextualFunction;
import com.ibm.ws.concurrent.mp.ContextualRunnable;
import com.ibm.ws.concurrent.mp.ContextualSupplier;
import com.ibm.ws.concurrent.mp.ManagedCompletableFuture;
import com.ibm.ws.concurrent.mp.ManagedCompletionStage;
import com.ibm.ws.concurrent.mp.ThreadContextDescriptorImpl;
import com.ibm.ws.concurrent.mp.UnusableExecutor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ThreadContextImpl
implements ThreadContext,
WSContextService {
    private static final TraceComponent tc = Tr.register(ThreadContextImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.mp.resources.CWWKCMessages");
    private final ContextManagerProviderImpl cmProvider;
    private final LinkedHashMap<ThreadContextProvider, ContextOp> configPerProvider;
    private final int hash;
    private final String name;
    static final long serialVersionUID = -8290757309782253694L;

    ThreadContextImpl(String name, int hash, ContextManagerProviderImpl cmProvider, LinkedHashMap<ThreadContextProvider, ContextOp> configPerProvider) {
        this.cmProvider = cmProvider;
        this.configPerProvider = configPerProvider;
        this.name = name;
        this.hash = hash;
    }

    public ThreadContextDescriptor captureThreadContext(Map<String, String> executionProperties, Map<String, ?> ... additionalThreadContextConfig) {
        return new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
    }

    public <R> Callable<R> contextualCallable(Callable<R> callable) {
        if (callable instanceof ContextualCallable) {
            throw new IllegalArgumentException(ContextualCallable.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualCallable<R>(contextDescriptor, callable);
    }

    public <T, U> BiConsumer<T, U> contextualConsumer(BiConsumer<T, U> consumer) {
        if (consumer instanceof ContextualBiConsumer) {
            throw new IllegalArgumentException(ContextualBiConsumer.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualBiConsumer<T, U>(contextDescriptor, consumer);
    }

    public <T> Consumer<T> contextualConsumer(Consumer<T> consumer) {
        if (consumer instanceof ContextualConsumer) {
            throw new IllegalArgumentException(ContextualConsumer.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualConsumer<T>(contextDescriptor, consumer);
    }

    public <T, U, R> BiFunction<T, U, R> contextualFunction(BiFunction<T, U, R> function) {
        if (function instanceof ContextualBiFunction) {
            throw new IllegalArgumentException(ContextualBiFunction.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualBiFunction<T, U, R>(contextDescriptor, function);
    }

    public <T, R> Function<T, R> contextualFunction(Function<T, R> function) {
        if (function instanceof ContextualFunction) {
            throw new IllegalArgumentException(ContextualFunction.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualFunction<T, R>(contextDescriptor, function);
    }

    public Runnable contextualRunnable(Runnable runnable) {
        if (runnable instanceof ContextualRunnable) {
            throw new IllegalArgumentException(ContextualRunnable.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualRunnable(contextDescriptor, runnable);
    }

    public <R> Supplier<R> contextualSupplier(Supplier<R> supplier) {
        if (supplier instanceof ContextualSupplier) {
            throw new IllegalArgumentException(ContextualSupplier.class.getSimpleName());
        }
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualSupplier<R>(contextDescriptor, supplier);
    }

    public <T> T createContextualProxy(ThreadContextDescriptor threadContextDescriptor, T instance, Class<T> intf) {
        throw new UnsupportedOperationException();
    }

    public Executor currentContextExecutor() {
        ThreadContextDescriptorImpl contextDescriptor = new ThreadContextDescriptorImpl(this.cmProvider, this.configPerProvider);
        return new ContextualExecutor(contextDescriptor);
    }

    @Trivial
    public int hashCode() {
        return this.hash;
    }

    @Trivial
    public String toString() {
        return this.name;
    }

    public <T> CompletableFuture<T> withContextCapture(CompletableFuture<T> stage) {
        UnusableExecutor executor = new UnusableExecutor(this);
        ManagedCompletableFuture newCompletableFuture = ManagedCompletableFuture.JAVA8 ? new ManagedCompletableFuture(new CompletableFuture(), executor, null) : new ManagedCompletableFuture(executor, null);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newCompletableFuture.complete(result);
            } else {
                newCompletableFuture.completeExceptionally((Throwable)failure);
            }
        });
        return newCompletableFuture;
    }

    public <T> CompletionStage<T> withContextCapture(CompletionStage<T> stage) {
        UnusableExecutor executor = new UnusableExecutor(this);
        ManagedCompletionStage newStage = ManagedCompletableFuture.JAVA8 ? new ManagedCompletionStage(new CompletableFuture(), executor, null) : new ManagedCompletionStage(executor);
        stage.whenComplete((result, failure) -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"whenComplete", (Object[])new Object[]{result, failure});
            }
            if (failure == null) {
                newStage.super_complete(result);
            } else {
                newStage.super_completeExceptionally((Throwable)failure);
            }
        });
        return newStage;
    }
}

