/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.client.internal.authentication;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.credentials.CredentialsService;
import com.ibm.ws.security.jaas.common.callback.CallbackHandlerAuthenticationData;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ClientAuthenticationService.class}, name="com.ibm.ws.security.client.authentication", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ClientAuthenticationService {
    static final String KEY_CREDENTIALS_SERVICE = "credentialsService";
    private final AtomicServiceReference<CredentialsService> credentialsServiceRef = new AtomicServiceReference("credentialsService");
    static final long serialVersionUID = 35954014810072179L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(service=CredentialsService.class, name="credentialsService")
    protected void setCredentialsService(ServiceReference<CredentialsService> reference) {
        this.credentialsServiceRef.setReference(reference);
    }

    protected void unsetCredentialsService(ServiceReference<CredentialsService> reference) {
        this.credentialsServiceRef.unsetReference(reference);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.credentialsServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.credentialsServiceRef.deactivate(cc);
    }

    /*
     * WARNING - void declaration
     */
    public Subject authenticate(CallbackHandler callbackHandler, Subject subject) throws WSLoginFailedException, CredentialException {
        if (callbackHandler == null) {
            throw new WSLoginFailedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages", (String)"JAAS_LOGIN_NO_CALLBACK_HANDLER", (Object[])new Object[0], (String)"CWWKS1170E: The login on the client application failed because the CallbackHandler implementation is null. Ensure a valid CallbackHandler implementation is specified either in the LoginContext constructor or in the client application's deployment descriptor."));
        }
        CallbackHandlerAuthenticationData cAuthData = new CallbackHandlerAuthenticationData(callbackHandler);
        AuthenticationData authenticationData = null;
        try {
            authenticationData = cAuthData.createAuthenticationData();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.client.internal.authentication.ClientAuthenticationService", (String)"97", (Object)this, (Object[])new Object[]{callbackHandler, subject});
            throw new WSLoginFailedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages", (String)"JAAS_LOGIN_UNEXPECTED_EXCEPTION", (Object[])new Object[]{e.getLocalizedMessage()}, (String)("CWWKS1172E: The login on the client application failed because of an unexpected exception. Review the logs to understand the cause of the exception. The exception is: " + e.getLocalizedMessage())));
        }
        catch (UnsupportedCallbackException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.client.internal.authentication.ClientAuthenticationService", (String)"105", (Object)this, (Object[])new Object[]{callbackHandler, subject});
            throw new WSLoginFailedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages", (String)"JAAS_LOGIN_UNEXPECTED_EXCEPTION", (Object[])new Object[]{e.getLocalizedMessage()}, (String)("CWWKS1172E: The login on the client application failed because of an unexpected exception. Review the logs to understand the cause of the exception. The exception is: " + e.getLocalizedMessage())));
        }
        return this.createBasicAuthSubject(authenticationData, subject);
    }

    protected Subject createBasicAuthSubject(AuthenticationData authenticationData, Subject subject) throws WSLoginFailedException, CredentialException {
        Subject basicAuthSubject = subject != null ? subject : new Subject();
        String loginRealm = (String)authenticationData.get("REALM");
        String username = (String)authenticationData.get("USERNAME");
        String password = this.getPassword((char[])authenticationData.get("PASSWORD"));
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            throw new WSLoginFailedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages", (String)"JAAS_LOGIN_MISSING_CREDENTIALS", (Object[])new Object[0], (String)"CWWKS1171E: The login on the client application failed because the user name or password is null. Ensure the CallbackHandler implementation is gathering the necessary credentials."));
        }
        CredentialsService credentialsService = (CredentialsService)this.credentialsServiceRef.getServiceWithException();
        credentialsService.setBasicAuthCredential(basicAuthSubject, loginRealm, username, password);
        WSPrincipal principal = new WSPrincipal(username, null, "basic");
        basicAuthSubject.getPrincipals().add((Principal)principal);
        return basicAuthSubject;
    }

    @Sensitive
    private String getPassword(@Sensitive char[] passwordBytes) {
        String password = null;
        if (passwordBytes != null) {
            password = String.valueOf(passwordBytes);
        }
        return password;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClientAuthenticationService.class, (String)"security", (String)"com.ibm.ws.security.client.internal.resources.SecurityClientMessages");
    }
}

