/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.sync;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.TaskRunner;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Callable;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SimpleTaskRunner<R>
implements TaskRunner<R> {
    private static final TraceComponent tc = Tr.register(SimpleTaskRunner.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    static final long serialVersionUID = 5675775488787388316L;

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public R runTask(Callable<R> task, ExecutionContextImpl executionContext) throws Exception {
        R result = null;
        try {
            result = task.call();
        }
        catch (InterruptedException e) {
            long remaining = executionContext.check();
            FTDebug.debugTime((TraceComponent)tc, (String)"Task Interrupted", (long)remaining);
            throw e;
        }
        finally {
            executionContext.end();
        }
        return result;
    }
}

