/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl.sync;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.faulttolerance.impl.CircuitBreakerImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.ExecutionContextImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.RetryImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.TaskRunner;
import com.ibm.ws.microprofile.faulttolerance.impl.TimeoutImpl;
import com.ibm.ws.microprofile.faulttolerance.impl.sync.SemaphoreTaskRunner;
import com.ibm.ws.microprofile.faulttolerance.impl.sync.SimpleTaskRunner;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException;
import com.ibm.ws.microprofile.faulttolerance.spi.Executor;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.SyncFailsafe;
import net.jodah.failsafe.function.CheckedFunction;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SynchronousExecutorImpl<R>
implements Executor<R> {
    private static final TraceComponent tc = Tr.register(SynchronousExecutorImpl.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    private TaskRunner<R> taskRunner;
    private TimeoutPolicy timeoutPolicy;
    private ScheduledExecutorService scheduledExecutorService;
    private CircuitBreakerImpl circuitBreaker;
    private FallbackPolicy fallbackPolicy;
    private com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy retryPolicy;
    protected MetricRecorder metricRecorder;
    static final long serialVersionUID = -5104489965145137130L;

    public SynchronousExecutorImpl(com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, ScheduledExecutorService scheduledExecutorService, MetricRecorder metricRecorder) {
        this.timeoutPolicy = timeoutPolicy;
        this.scheduledExecutorService = scheduledExecutorService;
        this.metricRecorder = metricRecorder;
        if (circuitBreakerPolicy != null) {
            this.circuitBreaker = new CircuitBreakerImpl(circuitBreakerPolicy);
        }
        this.fallbackPolicy = fallbackPolicy;
        this.retryPolicy = retryPolicy;
        this.taskRunner = bulkheadPolicy == null ? new SimpleTaskRunner() : new SemaphoreTaskRunner(bulkheadPolicy, metricRecorder);
        if (this.circuitBreaker != null) {
            this.circuitBreaker.onOpen(() -> ((MetricRecorder)metricRecorder).reportCircuitOpen());
            this.circuitBreaker.onHalfOpen(() -> ((MetricRecorder)metricRecorder).reportCircuitHalfOpen());
            this.circuitBreaker.onClose(() -> ((MetricRecorder)metricRecorder).reportCircuitClosed());
        }
    }

    protected SynchronousExecutorImpl() {
    }

    public FTExecutionContext newExecutionContext(String id, Method method, Object ... params) {
        TimeoutImpl timeout = null;
        if (this.timeoutPolicy != null && !this.timeoutPolicy.getTimeout().isZero()) {
            timeout = new TimeoutImpl(id, this.timeoutPolicy, this.scheduledExecutorService);
        }
        RetryImpl retry = new RetryImpl(this.retryPolicy);
        ExecutionContextImpl executionContext = new ExecutionContextImpl(id, method, params, timeout, this.circuitBreaker, this.fallbackPolicy, retry, this.metricRecorder);
        return executionContext;
    }

    protected Callable<R> createTask(Callable<R> callable, ExecutionContextImpl executionContext) {
        Callable<Object> task = () -> {
            R result = this.taskRunner.runTask(callable, executionContext);
            return result;
        };
        return task;
    }

    protected void preRun(ExecutionContextImpl executionContext) {
        executionContext.start();
    }

    protected void executionComplete(ExecutionContextImpl executionContext, Throwable t) {
        executionContext.onFullExecutionComplete(t);
    }

    protected void configureFailsafe(SyncFailsafe<R> failsafe, ExecutionContextImpl executionContextImpl) {
        failsafe.onRetry(t -> executionContextImpl.onRetry((Throwable)t));
        failsafe.onComplete((r, t) -> executionContextImpl.onMainExecutionComplete((Throwable)t));
        if (executionContextImpl.getCircuitBreaker() != null) {
            failsafe = (SyncFailsafe)failsafe.with((CircuitBreaker)executionContextImpl.getCircuitBreaker());
        }
        if (executionContextImpl.getFallbackPolicy() != null) {
            CheckedFunction fallback = t -> {
                executionContextImpl.onMainExecutionComplete((Throwable)t);
                executionContextImpl.onFallback();
                return executionContextImpl.getFallbackPolicy().getFallbackFunction().execute((Object)executionContextImpl);
            };
            failsafe = (SyncFailsafe)failsafe.withFallback(fallback);
        }
    }

    @FFDCIgnore(value={net.jodah.failsafe.CircuitBreakerOpenException.class, FailsafeException.class, Throwable.class})
    public R execute(Callable<R> callable, ExecutionContext executionContext) {
        ExecutionContextImpl executionContextImpl = (ExecutionContextImpl)executionContext;
        SyncFailsafe failsafe = Failsafe.with((RetryPolicy)executionContextImpl.getRetry());
        this.configureFailsafe(failsafe, executionContextImpl);
        Callable<R> task = this.createTask(callable, executionContextImpl);
        this.preRun(executionContextImpl);
        Object result = null;
        Throwable failure = null;
        try {
            result = failsafe.get(task);
        }
        catch (net.jodah.failsafe.CircuitBreakerOpenException e) {
            failure = e;
            executionContextImpl.onMainExecutionComplete(e);
            throw new CircuitBreakerOpenException((Throwable)e);
        }
        catch (FailsafeException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Fault tolerance execution ended in failure: {0} - {1}", (Object[])new Object[]{executionContextImpl.getMethod(), e});
            }
            failure = e;
            Throwable cause = e.getCause();
            if (cause instanceof FaultToleranceException) {
                throw (FaultToleranceException)cause;
            }
            throw new ExecutionException(cause);
        }
        catch (Throwable t) {
            failure = t;
            throw t;
        }
        finally {
            this.executionComplete(executionContextImpl, failure);
        }
        return (R)result;
    }

    public void close() {
    }
}

