/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FutureShell<V>
implements Future<V> {
    private final CompletableFuture<Future<V>> delegateHolder = new CompletableFuture();
    private volatile Future<V> delegate = null;
    private boolean mayInterruptWhenCancellingDelegate = false;
    private Consumer<Boolean> cancellationCallback;
    static final long serialVersionUID = -6725294837233037991L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public synchronized void setCancellationCallback(Consumer<Boolean> cancellationCallback) {
        this.cancellationCallback = cancellationCallback;
    }

    public synchronized void setDelegate(Future<V> delegate) {
        if (this.delegateHolder.isCancelled()) {
            delegate.cancel(this.mayInterruptWhenCancellingDelegate);
        } else {
            this.delegate = delegate;
            this.delegateHolder.complete(delegate);
        }
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.delegateHolder.cancel(false)) {
            this.mayInterruptWhenCancellingDelegate = mayInterruptIfRunning;
            if (this.cancellationCallback != null) {
                this.cancellationCallback.accept(mayInterruptIfRunning);
            }
            return true;
        }
        if (this.delegateHolder.isDone() && !this.delegateHolder.isCancelled()) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (this.delegateHolder.isDone()) {
            if (this.delegateHolder.isCancelled()) {
                return true;
            }
            return this.delegate.isCancelled();
        }
        return false;
    }

    @Override
    public boolean isDone() {
        if (this.delegateHolder.isDone()) {
            if (this.delegateHolder.isCancelled()) {
                return true;
            }
            return this.delegate.isDone();
        }
        return false;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegateHolder.get().get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutNanos = unit.toNanos(timeout);
        long startTime = System.nanoTime();
        Future<V> delegate = this.delegateHolder.get(timeoutNanos, TimeUnit.NANOSECONDS);
        long elapsedTime = System.nanoTime() - startTime;
        return delegate.get(timeoutNanos - elapsedTime, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        if (this.delegateHolder.isCancelled()) {
            return "FutureShell cancelled";
        }
        if (this.delegateHolder.isDone()) {
            return "FutureShell delegating to " + this.delegate;
        }
        return "FutureShell incomplete";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FutureShell.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    }
}

