/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.loose.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.artifact.loose.internal.LooseArtifactNotifier;
import com.ibm.ws.artifact.loose.internal.LooseContainer;
import com.ibm.ws.artifact.loose.internal.LooseContainerFactoryHelper;
import com.ibm.ws.artifact.loose.internal.LooseEntry;
import com.ibm.ws.artifact.loose.internal.PathUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LooseArchive
implements ArtifactContainer {
    private final File cacheDir;
    private final File xmlFile;
    private final LooseArchive parent;
    private final LooseContainerFactoryHelper cfh;
    private String pathInParent;
    private final List<EntryInfo> _entries = new ArrayList<EntryInfo>();
    private static final TraceComponent tc = Tr.register(LooseArchive.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
    private LooseArtifactNotifier artifactNotifier;
    static final long serialVersionUID = 345486831272892625L;

    public LooseArchive(File cacheDir, LooseContainerFactoryHelper cfh, File xmlPath) {
        this.cacheDir = cacheDir;
        this.parent = null;
        this.cfh = cfh;
        this.xmlFile = xmlPath;
    }

    public LooseArchive(File cacheDir, LooseContainerFactoryHelper cfh, LooseArchive prior, String pathInPrior, File xmlPath) {
        this.cacheDir = cacheDir;
        this.parent = prior;
        this.pathInParent = pathInPrior;
        this.cfh = cfh;
        this.xmlFile = xmlPath;
    }

    File getXMLFile() {
        return this.xmlFile;
    }

    public Iterator<ArtifactEntry> iterator() {
        return this.iterator("/");
    }

    public ArtifactContainer getEnclosingContainer() {
        if (this.parent != null) {
            return this.parent.getEntry(this.pathInParent).getEnclosingContainer();
        }
        return null;
    }

    public ArtifactEntry getEntryInEnclosingContainer() {
        if (this.parent != null) {
            return this.parent.getEntry(this.pathInParent);
        }
        return null;
    }

    public String getPath() {
        return "/";
    }

    public String getName() {
        return "/";
    }

    public void useFastMode() {
    }

    public void stopUsingFastMode() {
    }

    public boolean isRoot() {
        return true;
    }

    public ArtifactEntry getEntry(String pathAndName) {
        if (!PathUtils.isNormalizedPathAbsolute((String)(pathAndName = PathUtils.normalizeUnixStylePath((String)pathAndName)))) {
            return null;
        }
        if (pathAndName.equals("/") || pathAndName.equals("")) {
            return null;
        }
        if (!pathAndName.startsWith("/")) {
            pathAndName = '/' + pathAndName;
        }
        if (pathAndName.endsWith("/")) {
            pathAndName = pathAndName.substring(0, pathAndName.length() - 1);
        }
        for (EntryInfo ei : this._entries) {
            if (!ei.matches(pathAndName)) continue;
            return new LooseEntry(this, ei, pathAndName);
        }
        for (EntryInfo ei : this._entries) {
            if (!ei.isBeneath(pathAndName)) continue;
            return new LooseEntry(this, null, pathAndName);
        }
        return null;
    }

    public Iterator<ArtifactEntry> iterator(String path) {
        LinkedHashMap<String, EntryInfo> names = new LinkedHashMap<String, EntryInfo>();
        for (EntryInfo ei : this._entries) {
            if (ei.matches(path) && ei instanceof DirEntryInfo) {
                DirEntryInfo dei = (DirEntryInfo)ei;
                for (String s : dei.getChildren(path)) {
                    if (names.containsKey(s)) continue;
                    names.put(s, ei);
                }
            }
            if (!(ei instanceof FileEntryInfo) && !(ei instanceof DirEntryInfo) || !path.equals(PathUtil.getParent(ei.getVirtualLocation())) || names.containsKey(ei.getVirtualLocation())) continue;
            names.put(ei.getVirtualLocation(), ei);
        }
        for (EntryInfo ei : this._entries) {
            if (!ei.isBeneath(path)) continue;
            String startOfPath = "";
            String pathSeparator = "/";
            if (path.equals("/")) {
                startOfPath = path;
                pathSeparator = "";
            }
            String dir = PathUtil.getFirstPathComponent(startOfPath + ei.getVirtualLocation().substring(path.length()));
            dir = path + pathSeparator + dir;
            if (names.containsKey(dir)) continue;
            names.put(dir, null);
        }
        return new EntryIterator(names, this);
    }

    public ArtifactContainer getRoot() {
        return this;
    }

    public Collection<URL> getURLs() {
        return this.getURLs("/");
    }

    public String getPhysicalPath() {
        return this.getPhysicalPath("/");
    }

    String getPhysicalPath(String path) {
        for (EntryInfo ei : this._entries) {
            if (!ei.matches(path)) continue;
            return ei.getFirstPhysicalPath(path);
        }
        return null;
    }

    Collection<URL> getURLs(String path) {
        HashSet<URL> urls = new HashSet<URL>();
        for (EntryInfo ei : this._entries) {
            if (!ei.matches(path)) continue;
            urls.addAll(ei.getURLs(path));
        }
        return urls;
    }

    File getCacheDir() {
        return this.cacheDir;
    }

    public final synchronized ArtifactNotifier getArtifactNotifier() {
        if (this.artifactNotifier == null) {
            this.cascadeCreateArtifactNotifier();
        }
        return this.artifactNotifier;
    }

    private void cascadeCreateArtifactNotifier() {
        LooseArchive root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        root.createArtifactNotifier(null);
    }

    private LooseArtifactNotifier createArtifactNotifier(LooseArtifactNotifier parent) {
        this.artifactNotifier = new LooseArtifactNotifier(this, this._entries, this.cfh.getBundleContext(), parent, this.pathInParent);
        for (EntryInfo entry : this._entries) {
            if (!(entry instanceof ArchiveEntryInfo)) continue;
            LooseArchive childArchive = ((ArchiveEntryInfo)entry).la;
            this.artifactNotifier.addChild(entry, childArchive.createArtifactNotifier(this.artifactNotifier));
        }
        return this.artifactNotifier;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class EntryIterator
    implements Iterator<ArtifactEntry> {
        private final Iterator<Map.Entry<String, EntryInfo>> fileListIterator;
        private final LooseArchive looseArch;
        static final long serialVersionUID = 5876517846077886748L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EntryIterator(Map<String, EntryInfo> names, LooseArchive looseA) {
            this.fileListIterator = names.entrySet().iterator();
            this.looseArch = looseA;
        }

        @Override
        public boolean hasNext() {
            return this.fileListIterator.hasNext();
        }

        @Override
        public ArtifactEntry next() {
            Map.Entry<String, EntryInfo> t = this.fileListIterator.next();
            LooseEntry le = new LooseEntry(this.looseArch, t.getValue(), t.getKey());
            return le;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EntryIterator.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArchiveEntryInfo
    extends FileEntryInfo {
        private final LooseArchive la;
        static final long serialVersionUID = 8778423660531014843L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArchiveEntryInfo(String archiveFile, LooseArchive archive, LooseContainerFactoryHelper cfh) {
            super(archiveFile, null, cfh);
            this.la = archive;
        }

        @Override
        public void addMonitoringPaths(Set<String> files, Set<String> dirs, String path) {
        }

        @Override
        public InputStream getInputStream(String filename) {
            return null;
        }

        @Override
        public ArtifactContainer createContainer(boolean localOnly, LooseArchive parent, String path) {
            if (!localOnly) {
                return this.la;
            }
            return null;
        }

        @Override
        public long getSize(String fileName) {
            return 0L;
        }

        @Override
        public Collection<URL> getURLs(String path) {
            return this.la.getURLs();
        }

        @Override
        public String getFirstPhysicalPath(String path) {
            return this.la.getPhysicalPath();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ArchiveEntryInfo.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FileEntryInfo
    extends EntryInfo {
        private final String filenameInArchive;
        private final String filenameOnDisk;
        private final LooseContainerFactoryHelper containerFactoryHelper;
        private final File fileOnDisk;
        static final long serialVersionUID = 3253151582559506433L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public FileEntryInfo(String archiveFile, String onDiskFile, LooseContainerFactoryHelper cfh) {
            this.filenameInArchive = archiveFile;
            this.filenameOnDisk = onDiskFile;
            this.fileOnDisk = this.filenameOnDisk != null ? new File(this.filenameOnDisk) : null;
            this.containerFactoryHelper = cfh;
        }

        @Override
        public void addMonitoringPaths(Set<String> files, Set<String> dirs, String path) {
            String pathToAdd = path.startsWith("!") ? "!" + this.filenameOnDisk : this.filenameOnDisk;
            files.add(pathToAdd);
        }

        @Override
        public boolean matches(String fileName) {
            return this.matches(fileName, true);
        }

        @Override
        public boolean matches(String fileName, boolean checkIfExists) {
            if (this.filenameInArchive.equals(fileName)) {
                if (this.fileOnDisk != null) {
                    return checkIfExists ? FileUtils.fileExists((File)this.fileOnDisk) : true;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isBeneath(String fileName) {
            if (fileName.length() < this.filenameInArchive.length()) {
                if (!fileName.endsWith("/")) {
                    fileName = fileName + "/";
                }
                return this.filenameInArchive.startsWith(fileName);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public InputStream getInputStream(String fileName) {
            try {
                return FileUtils.getInputStream((File)new File(this.filenameOnDisk));
            }
            catch (FileNotFoundException fileNotFoundException) {
                void e;
                FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.artifact.loose.internal.LooseArchive$FileEntryInfo", (String)"571", (Object)this, (Object[])new Object[]{fileName});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"looseconfigxmlstreamerror");
                Tr.error((TraceComponent)tc, (String)"DECLARED_FILE_NOT_FOUND", (Object[])new Object[]{fileName});
                return null;
            }
        }

        @Override
        public ArtifactContainer createContainer(boolean localOnly, LooseArchive parent, String path) {
            ArtifactContainer rv = null;
            if (!localOnly) {
                LooseArchive owning = parent;
                ArtifactEntry e = owning.getEntry(path);
                ArtifactContainer c = e.getEnclosingContainer();
                File newCacheDir = null;
                String relativeLocation = c.getPath();
                newCacheDir = relativeLocation.equals("/") ? parent.getCacheDir() : new File(parent.getCacheDir(), relativeLocation.substring(1));
                rv = this.containerFactoryHelper.getContainerFactory().getContainer(newCacheDir, c, e, (Object)new File(this.filenameOnDisk));
            }
            return rv;
        }

        @Override
        public String getVirtualLocation() {
            return this.filenameInArchive;
        }

        @Override
        public long getSize(String fileName) {
            File f = new File(this.filenameOnDisk);
            if (FileUtils.fileIsFile((File)f) && FileUtils.fileExists((File)f)) {
                return FileUtils.fileLength((File)f);
            }
            return 0L;
        }

        @Override
        Collection<URL> getURLs(String path) {
            try {
                return Collections.singleton(new File(this.filenameOnDisk).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.loose.internal.LooseArchive$FileEntryInfo", (String)"624", (Object)this, (Object[])new Object[]{path});
                return Collections.emptySet();
            }
        }

        @Override
        String getFirstPhysicalPath(String path) {
            return new File(this.filenameOnDisk).getAbsolutePath();
        }

        @Override
        public long getLastModified(String filename) {
            File f = new File(this.filenameOnDisk);
            if (FileUtils.fileIsFile((File)f) && FileUtils.fileExists((File)f)) {
                return FileUtils.fileLastModified((File)f);
            }
            return 0L;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FileEntryInfo.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DirEntryInfo
    extends EntryInfo {
        private final String dirPrefixInArchive;
        private final String dirOnDisk;
        private String formattedDirOnDisk = null;
        private Pattern excludesPattern = null;
        private final LooseContainerFactoryHelper containerFactoryHelper;
        static final long serialVersionUID = -5091028722111519494L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DirEntryInfo(String location, String onDiskDir, LooseContainerFactoryHelper cfh) {
            this.dirPrefixInArchive = DirEntryInfo.stripTrailingSeparator(location);
            this.dirOnDisk = DirEntryInfo.stripTrailingSeparator(onDiskDir);
            this.containerFactoryHelper = cfh;
        }

        public DirEntryInfo(String location, String onDiskDir, String excludesString, LooseContainerFactoryHelper cfh) {
            this(location, onDiskDir, cfh);
            this.convertToRegex(excludesString);
        }

        @Override
        public void addMonitoringPaths(Set<String> files, Set<String> dirs, String path) {
            boolean recurse = true;
            if (path.startsWith("!")) {
                recurse = false;
                path = path.substring(1);
            }
            String pathForAdd = recurse ? "" : "!";
            pathForAdd = pathForAdd + this.dirOnDisk;
            if (path.length() > this.dirPrefixInArchive.length() && path.startsWith(this.dirPrefixInArchive)) {
                String frag = path.substring(this.dirPrefixInArchive.length());
                frag = frag.replace('/', File.separatorChar);
                pathForAdd = new File(this.dirOnDisk, frag).getAbsolutePath();
                pathForAdd = recurse ? pathForAdd : "!" + pathForAdd;
            }
            dirs.add(pathForAdd);
            files.add(pathForAdd);
        }

        @Override
        public String getVirtualLocation() {
            return this.dirPrefixInArchive;
        }

        @Override
        public boolean matches(String fileName) {
            return this.matches(fileName, true);
        }

        @Override
        public boolean matches(String fileName, boolean checkIfExists) {
            fileName = DirEntryInfo.stripTrailingSeparator(fileName);
            String onDiskPath = null;
            String cutFileName = null;
            if (fileName.length() > this.dirPrefixInArchive.length() && fileName.startsWith(this.dirPrefixInArchive)) {
                cutFileName = fileName.substring(this.dirPrefixInArchive.length());
                onDiskPath = DirEntryInfo.isSeparatorChar(cutFileName.charAt(0)) ? this.dirOnDisk + cutFileName : this.dirOnDisk + '/' + cutFileName;
            } else if (this.dirPrefixInArchive.equals(fileName)) {
                onDiskPath = this.dirOnDisk;
                cutFileName = "";
            }
            if (onDiskPath != null) {
                File f = new File(onDiskPath);
                if (!(checkIfExists && !FileUtils.fileExists((File)f) || this.excludesPattern != null && !this.fileNotExcluded(this.dirOnDisk + "/", f))) {
                    return PathUtils.checkCase((File)f, (String)cutFileName);
                }
            }
            return false;
        }

        @Override
        public boolean isBeneath(String fileName) {
            String s = DirEntryInfo.stripTrailingSeparator(fileName);
            if (s.length() < this.dirPrefixInArchive.length()) {
                if (s.length() > 1 && s.length() == fileName.length()) {
                    fileName = fileName + '/';
                }
                return this.dirPrefixInArchive.startsWith(fileName);
            }
            return false;
        }

        @Override
        public ArtifactContainer createContainer(boolean localOnly, LooseArchive parent, String path) {
            String onDiskPath = this.createOnDiskPath(path);
            File f = new File(onDiskPath);
            if (FileUtils.fileIsDirectory((File)f)) {
                return new LooseContainer(parent, this, path);
            }
            ArtifactContainer rv = null;
            if (!localOnly) {
                LooseArchive owning = parent;
                ArtifactEntry e = owning.getEntry(path);
                ArtifactContainer c = e.getEnclosingContainer();
                File newCacheDir = null;
                String relativeLocation = c.getPath();
                newCacheDir = relativeLocation.equals("/") ? parent.getCacheDir() : new File(parent.getCacheDir(), relativeLocation.substring(1));
                rv = this.containerFactoryHelper.getContainerFactory().getContainer(newCacheDir, c, e, (Object)f);
            }
            return rv;
        }

        public List<String> getChildren(String path) {
            String onDiskPath = this.createOnDiskPath(path);
            File fdir = new File(onDiskPath);
            File[] flist = FileUtils.listFiles((File)fdir);
            if (flist == null) {
                return new ArrayList<String>(0);
            }
            ArrayList<String> retval = new ArrayList<String>(flist.length);
            if (this.excludesPattern != null && this.formattedDirOnDisk == null) {
                this.formattedDirOnDisk = this.dirOnDisk.replace('\\', '/') + '/';
            }
            boolean pathIsRoot = path.length() == 1 && DirEntryInfo.isSeparatorChar(path.charAt(0));
            String prefix = pathIsRoot ? "/" : DirEntryInfo.stripTrailingSeparator(path) + '/';
            for (File f : flist) {
                if (this.excludesPattern != null && !this.fileNotExcluded(this.formattedDirOnDisk, f)) continue;
                retval.add(prefix + f.getName());
            }
            return retval;
        }

        /*
         * WARNING - void declaration
         */
        public void convertToRegex(String excludeString) {
            String originalString = excludeString;
            if (excludeString.contains(".")) {
                excludeString = excludeString.replace(".", "\\.");
            }
            if (excludeString.endsWith("/")) {
                excludeString = excludeString.substring(0, excludeString.length() - 1);
            }
            if (excludeString.contains("**")) {
                excludeString = excludeString.replace("**", ".*");
            }
            if (excludeString.contains("/*")) {
                excludeString = excludeString.replace("/*", "/.*");
            }
            if (excludeString.contains("/")) {
                excludeString = excludeString.replace("/", "\\/");
            }
            if (excludeString.contains("**")) {
                excludeString = excludeString.replace("**", "*");
            }
            if (excludeString.startsWith("*")) {
                excludeString = "." + excludeString;
            }
            if (excludeString.contains("[")) {
                excludeString = excludeString.replace("[", "\\[");
            }
            if (excludeString.contains("]")) {
                excludeString = excludeString.replace("]", "\\]");
            }
            if (excludeString.contains("-")) {
                excludeString = excludeString.replace("-", "\\-");
            }
            try {
                this.excludesPattern = Pattern.compile(excludeString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                void pse;
                FFDCFilter.processException((Throwable)patternSyntaxException, (String)"com.ibm.ws.artifact.loose.internal.LooseArchive$DirEntryInfo", (String)"354", (Object)this, (Object[])new Object[]{excludeString});
                FFDCFilter.processException((Throwable)pse, (String)this.getClass().getName(), (String)"looseconfigxmlpse");
                Tr.error((TraceComponent)tc, (String)"INVALID_EXCLUDE_PATTERN", (Object[])new Object[]{originalString});
                this.excludesPattern = null;
            }
        }

        public boolean fileNotExcluded(String rootPath, File currentFile) {
            rootPath = rootPath.replace("//", "/");
            if ('\\' == File.separatorChar) {
                rootPath = rootPath.replace(File.separatorChar, '/');
            }
            if (this.excludesPattern.matcher(currentFile.getAbsolutePath().replace("\\", "/").replace(rootPath, "/").replace("//", "/")).matches()) {
                return false;
            }
            while (currentFile.getAbsolutePath().replace("\\", "/").startsWith(rootPath)) {
                if (this.excludesPattern.matcher(currentFile.getAbsolutePath().replace("\\", "/").replace(rootPath, "/")).matches()) {
                    return false;
                }
                currentFile = currentFile.getParentFile();
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public InputStream getInputStream(String filename) {
            String onDiskPath = this.dirOnDisk + '/' + filename.substring(this.dirPrefixInArchive.length());
            File f = new File(onDiskPath);
            if (FileUtils.fileIsFile((File)f) && FileUtils.fileExists((File)f)) {
                try {
                    return FileUtils.getInputStream((File)f);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    void e;
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.artifact.loose.internal.LooseArchive$DirEntryInfo", (String)"408", (Object)this, (Object[])new Object[]{filename});
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"looseconfigxmlstreamerrorindir");
                    Tr.error((TraceComponent)tc, (String)"DECLARED_FILE_NOT_FOUND", (Object[])new Object[]{f.getAbsolutePath()});
                    return null;
                }
            }
            return null;
        }

        @Override
        public long getSize(String filename) {
            String onDiskPath = this.dirOnDisk + '/' + filename.substring(this.dirPrefixInArchive.length());
            File f = new File(onDiskPath);
            if (FileUtils.fileIsFile((File)f) && FileUtils.fileExists((File)f)) {
                return FileUtils.fileLength((File)f);
            }
            return 0L;
        }

        @Override
        @FFDCIgnore(value={PrivilegedActionException.class})
        Collection<URL> getURLs(String path) {
            String pathToDirectory = this.getFirstPhysicalPath(path);
            if (System.getSecurityManager() == null) {
                try {
                    return Collections.singleton(new File(pathToDirectory).toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.loose.internal.LooseArchive$DirEntryInfo", (String)"435", (Object)this, (Object[])new Object[]{path});
                    return Collections.emptySet();
                }
            }
            final String f_pathToDirectory = pathToDirectory;
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<URL>>(){
                    static final long serialVersionUID = 8419678641849059495L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Collection<URL> run() throws MalformedURLException {
                        return Collections.singleton(new File(f_pathToDirectory).toURI().toURL());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                return Collections.emptySet();
            }
        }

        @Override
        String getFirstPhysicalPath(String path) {
            String pathToAppend = path.substring(this.dirPrefixInArchive.length());
            String pathToDirectory = this.dirOnDisk;
            if (!pathToDirectory.endsWith("/")) {
                if (!pathToAppend.startsWith("/")) {
                    pathToDirectory = pathToDirectory + "/";
                }
            } else if (pathToAppend.startsWith("/")) {
                pathToAppend = pathToAppend.substring(1);
            }
            pathToDirectory = pathToDirectory + pathToAppend;
            return new File(pathToDirectory).getAbsolutePath();
        }

        @Override
        public long getLastModified(String filename) {
            String onDiskPath = this.dirOnDisk + '/' + filename.substring(this.dirPrefixInArchive.length());
            File f = new File(onDiskPath);
            if (FileUtils.fileIsFile((File)f) && FileUtils.fileExists((File)f)) {
                return FileUtils.fileLastModified((File)f);
            }
            return 0L;
        }

        private static String stripTrailingSeparator(String s) {
            if (s.length() < 2) {
                return s;
            }
            if (DirEntryInfo.isSeparatorChar(s.charAt(s.length() - 1))) {
                return s.substring(0, s.length() - 1);
            }
            return s;
        }

        private String createOnDiskPath(String path) {
            String dir = DirEntryInfo.stripTrailingSeparator(path).substring(this.dirPrefixInArchive.length());
            if (dir.length() > 1 && DirEntryInfo.isSeparatorChar(dir.charAt(0))) {
                return this.dirOnDisk + dir;
            }
            return this.dirOnDisk + '/' + dir;
        }

        private static boolean isSeparatorChar(char c) {
            if (File.separatorChar != '/' && c == File.separatorChar) {
                return true;
            }
            return c == '/';
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DirEntryInfo.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static abstract class EntryInfo {
        static final long serialVersionUID = 2605968823933132150L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public abstract boolean matches(String var1);

        public abstract boolean matches(String var1, boolean var2);

        public abstract InputStream getInputStream(String var1);

        public abstract ArtifactContainer createContainer(boolean var1, LooseArchive var2, String var3);

        public abstract String getVirtualLocation();

        public abstract boolean isBeneath(String var1);

        public abstract long getSize(String var1);

        public abstract long getLastModified(String var1);

        public abstract void addMonitoringPaths(Set<String> var1, Set<String> var2, String var3);

        abstract Collection<URL> getURLs(String var1);

        @Deprecated
        abstract String getFirstPhysicalPath(String var1);

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EntryInfo.class, (String)"archive.artifact.xml", (String)"com.ibm.ws.artifact.loose.internal.resources.LooseApiMessages");
        }
    }

    public static enum EntryType {
        DIR{

            @Override
            public void put(LooseArchive la, String archiveDir, Object onDiskDir, LooseContainerFactoryHelper cfh) {
                la._entries.add(new DirEntryInfo(archiveDir, (String)onDiskDir, cfh));
            }

            @Override
            public void put(LooseArchive la, String archiveDir, Object onDiskDir, String excludes, LooseContainerFactoryHelper cfh) {
                la._entries.add(new DirEntryInfo(archiveDir, (String)onDiskDir, excludes, cfh));
            }
        }
        ,
        FILE{

            @Override
            public void put(LooseArchive la, String archiveFile, Object onDiskFile, LooseContainerFactoryHelper cfh) {
                la._entries.add(new FileEntryInfo(archiveFile, (String)onDiskFile, cfh));
            }

            @Override
            public void put(LooseArchive la, String archiveFile, Object onDiskFile, String ignoreValue, LooseContainerFactoryHelper cfh) {
                la._entries.add(new FileEntryInfo(archiveFile, (String)onDiskFile, cfh));
                Tr.warning((TraceComponent)tc, (String)"EXCLUDES_ON_FILE", (Object[])new Object[]{onDiskFile});
            }
        }
        ,
        ARCHIVE{

            @Override
            public void put(LooseArchive la, String archiveFile, Object looseArchive, LooseContainerFactoryHelper cfh) {
                la._entries.add(new ArchiveEntryInfo(archiveFile, (LooseArchive)looseArchive, cfh));
            }

            @Override
            public void put(LooseArchive la, String archiveFile, Object looseArchive, String ignoreValue, LooseContainerFactoryHelper cfh) {
                la._entries.add(new ArchiveEntryInfo(archiveFile, (LooseArchive)looseArchive, cfh));
                Tr.warning((TraceComponent)tc, (String)"EXCLUDES_ON_ARCHIVE", (Object[])new Object[]{archiveFile});
            }
        };


        public abstract void put(LooseArchive var1, String var2, Object var3, LooseContainerFactoryHelper var4);

        public abstract void put(LooseArchive var1, String var2, Object var3, String var4, LooseContainerFactoryHelper var5);
    }
}

