/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;

public class H2MuxTCPWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(H2MuxTCPWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    H2WriteQEntry qEntry = null;
    H2WorkQInterface h2WorkQ = null;

    public void setCurrentQEntry(H2WriteQEntry x) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("muxCallback entry set to stream-id: " + x.getStreamID()), (Object[])new Object[0]);
        }
        this.qEntry = x;
    }

    public void setH2WorkQ(H2WorkQInterface x) {
        this.h2WorkQ = x;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext twc) {
        this.commonProcessing(vc, twc, null, true);
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext twc, IOException ioe) {
        this.commonProcessing(vc, twc, ioe, false);
    }

    public void commonProcessing(VirtualConnection vc, TCPWriteRequestContext twc, IOException ioe, boolean complete) {
        if (this.qEntry == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no queue entries for this callback", (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("hit write complete latch for qentry: " + this.qEntry.hashCode()), (Object[])new Object[0]);
        }
        this.qEntry.hitWriteCompleteLatch();
        if (this.h2WorkQ != null) {
            this.h2WorkQ.notifyStandBy();
        }
    }
}

